<?php $url = Yii::app()->getBaseUrl(true) . '/home/attendance'; ?>

<!DOCTYPE html>
<html>
<head>
    <title id="pageTitle">QR Code Generator with Timer</title>
    <style>
        body {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            height: 100vh;
            margin: 0;
            background-color: black; /* Set the background to black */
        }

        #qrcode {
            max-width: 100%;
            display: flex;
            justify-content: center;
            background-color: white; /* Set the QR code background to white */
            padding: 10px; /* Add padding to the QR code container */
        }

        #timer {
            margin-top: 20px;
            font-size: 18px;
            color: white; /* Set the timer text color to white */
        }

        h1 {
            color: white; /* Set the heading color to white */
        }
        
        img{
            width:460px !important;
            height:460px !important;
        }
    </style>
</head>
<body>
    <h1 id="greeting">QR Code Generator with Timer</h1>
    <div id="qrcode"></div>
    <div id="timer">Timer: <span id="countdown">60</span> seconds</div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcode-generator/1.4.4/qrcode.min.js"></script>
    <script>
        function generateQRCode(content) {
            const qrCodeDiv = document.getElementById('qrcode');
            qrCodeDiv.innerHTML = '';

            const qr = qrcode(0, 'L');
            qr.addData(content);
            qr.make();
            const qrImage = qr.createImgTag(5, 10);
            qrCodeDiv.innerHTML = qrImage;
        }

        function startTimer(duration) {
            let timer = duration;
            const countdownElement = document.getElementById('countdown');

            const timerInterval = setInterval(function () {
                countdownElement.textContent = timer;
                timer--;

                if (timer < 0) {
                    clearInterval(timerInterval);
                    // Generate a new QR code when the timer reaches 0
                    generateNewQRCode();
                }
            }, 1000);
        }

        function generateRandomCode(length) {
            const characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
            let result = '';
            const charactersLength = characters.length;
            for (let i = 0; i < length; i++) {
                result += characters.charAt(Math.floor(Math.random() * charactersLength));
            }
            return result;
        }

        function generateNewQRCode() {
            // Replace this with the URL or content you want to generate a QR code for
            const qrContent = '<?php echo $url; ?>';


            // Get the current date and time

// Format the date and time as strings



const currentDate = new Date();
currentDate.setHours(12);
currentDate.setMinutes(34);
currentDate.setSeconds(56);

// Format the date and time as before.
const formattedDate = currentDate.toISOString().split('T')[0];
const formattedTime = currentDate.toISOString().split('T')[1].slice(0, 8);

console.log('Formatted Date:', formattedDate);
console.log('Formatted Time:', formattedTime);

// Generate a random code of length 12 characters
const randomCode = generateRandomCode(12);

// Append the formatted date, time, and random code to the qrContent
const qrContentWithDateTimeAndRandomCode = qrContent + `?date=${encodeURIComponent(formattedDate)}&time=${encodeURIComponent(formattedTime)}&code=${encodeURIComponent(randomCode)}`;

// Generate the QR code
generateQRCode(qrContentWithDateTimeAndRandomCode);

// Restart the timer for the next QR code generation
startTimer(5);


            // Send the scanned QR code content to the specified link (Replace 'https://your-api-endpoint.com' with your actual API endpoint)
            const scannedContent = qrContentWithDateTimeAndRandomCode; // You would replace this with the actual scanned QR code content
            sendScannedContent(scannedContent);
        }

        function sendScannedContent(content) {
            // Replace 'https://your-api-endpoint.com' with your actual API endpoint to send the scanned content
            const apiUrl = 'https://your-api-endpoint.com';
            const xhr = new XMLHttpRequest();
            const params = `content=${encodeURIComponent(content)}`;
            xhr.open('GET', `${apiUrl}?${params}`, true);
            xhr.send();
        }

        // Function to update the page title based on the time of day
        function updatePageTitle() {
            const currentTime = new Date();
            const hours = currentTime.getHours();

            let greeting;

            if (hours >= 5 && hours < 12) {
                greeting = 'Good morning';
            } else if (hours >= 12 && hours < 18) {
                greeting = 'Good afternoon';
            } else {
                greeting = 'Good evening';
            }

            document.getElementById('greeting').innerText = `${greeting} `;
        }

        // Initial update of the page title
        updatePageTitle();

        // Call the updatePageTitle function every minute to keep the greeting updated
        setInterval(updatePageTitle, 60000); // 60000 milliseconds = 1 minute

        // Initial generation of QR code and start the timer
        generateNewQRCode();
    </script>
</body>
</html>
