<?php
session_start();
header('Content-Type: text/html; charset=utf-8');
// Turn on error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Include TCPDF library
require_once('tcpdf/tcpdf.php');

// Extend the TCPDF class to create a custom Header and Footer
class MYPDF extends TCPDF {
    // Page header
    public function Header() {
        // Set the path to your header image
        $headerImage = 'images/header.jpg';
        $this->Image($headerImage, 10, 10, 190, '', '', '', 'T', false, 300, '', false, false, 0, false, false, false);
        $this->SetY(30); // Adjust to avoid content overlapping with the header
    }

    // Page footer
    // Page footer
public function Footer() {
    // Position at 15 mm from bottom
    $this->SetY(15);
    
    // Set the path to your footer image
    $footerImage = 'images/footer.jpg';
    $this->Image($footerImage, 10, $this->GetY(), 190, '', '', '', 'T', false, 300, '', false, false, 0, false, false, false);
    
    // Move Y to avoid overlapping with the footer image
    $this->SetY(-35); 

    // Set font
    $this->SetFont('dejavusans', '', 12);

    // Create a table-like structure using Cells
    // First column (Second Party)
    $this->Cell(95, 10, 'الطرف الاول', 0, 0, 'C');
    
    // Second column (First Party)
    $this->Cell(95, 10, 'الطرف الثاني', 0, 1, 'C');
}

}
// Create new PDF document
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);


// Set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Solid');
$pdf->SetTitle('Contract');
$pdf->SetSubject('Solid');
$pdf->SetKeywords('Solid, Contract, Solid CRM');

// Set default header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// Set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// Set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// Set auto page breaks
$pdf->SetAutoPageBreak(TRUE, 40);

// Set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// Add a page
$pdf->AddPage();

// Define font file paths
$fontFilePath1 = 'fonts/andalus.ttf';
$fontFilePath2 = 'fonts/Cairo-Regular.ttf';
$fontFilePath3 = 'fonts/gESSTwoLight-Light.ttf';
$fontFilePath4 = 'fonts/SomarSans-Regular.ttf';
$fontFilePath5 = 'fonts/Rubik-Regular.ttf';
$fontFilePath6 = 'fonts/Beiruti-Regular.ttf';
$fontFilePath7 = 'fonts/Tajawal-Regular.ttf';
$fontFilePath8 = 'fonts/IBMPlexSansArabic-Regular.ttf';
$fontFilePath9 = 'fonts/Arial.ttf';





// Add fonts to TCPDF
$fontname1 = TCPDF_FONTS::addTTFfont($fontFilePath1, 'TrueTypeUnicode', '', 96);
$fontname2 = TCPDF_FONTS::addTTFfont($fontFilePath2, 'TrueTypeUnicode', '', 96);
$fontname3 = TCPDF_FONTS::addTTFfont($fontFilePath3, 'TrueTypeUnicode', '', 96);
$fontname4 = TCPDF_FONTS::addTTFfont($fontFilePath4, 'TrueTypeUnicode', '', 96);
$fontname5 = TCPDF_FONTS::addTTFfont($fontFilePath5, 'TrueTypeUnicode', '', 96);
$fontname6 = TCPDF_FONTS::addTTFfont($fontFilePath6, 'TrueTypeUnicode', '', 96);
$fontname7 = TCPDF_FONTS::addTTFfont($fontFilePath7, 'TrueTypeUnicode', '', 96);
$fontname8 = TCPDF_FONTS::addTTFfont($fontFilePath8, 'TrueTypeUnicode', '', 96);
$fontname9 = TCPDF_FONTS::addTTFfont($fontFilePath9, 'TrueTypeUnicode', '', 96);




// Assign content from model
$content = $model->contract;

// Remove any font-family style attributes from the HTML content
$content = preg_replace('/style="font-family:[^"]*"/i', '', $content);

// Convert content to UTF-8
$content = mb_convert_encoding($content, 'UTF-8', mb_detect_encoding($content));

$pdf->SetFont($fontname8, '', 12); // Use Arabic-supporting font
$pdf->setRTL(true); // Set RTL if Arabic characters are found


// Print content
$pdf->writeHTML($content, true, false, true, false, '');

// Close PDF object
$pdf->lastPage();

// Output the PDF directly to the browser for inline display
$pdf->Output('Solid Contract.pdf', 'I');

// Clean up
$pdf->close();
?>
