<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (Yii::app()->request->isAjaxRequest) {
    $startdate = Yii::app()->request->getPost('startdate');
    $enddate = Yii::app()->request->getPost('enddate');
    $coldtype = Yii::app()->request->getPost('coldtype');
    $part = Yii::app()->request->getParam('part');

    if (empty($startdate) || empty($enddate) || empty($coldtype) || empty($part)) {
        var_dump($startdate, $enddate, $coldtype, $part);
        echo "Missing required parameters.";
        Yii::app()->end();
    }

    function build_table($array, $part)
    {
        if (empty($array)) {
            return "<p>No data retrieved for the given parameters.</p>";
        }
    
        // Define table IDs based on the part
        $tableIds = [
    'main' => 'exportable_table14',
    'part1' => 'exportable_table15',
    'part2' => 'exportable_table16',
    'part3' => 'exportable_table17'
];
    
        // Get the id for the current part
        $tableId = isset($tableIds[$part]) ? $tableIds[$part] : '';
    
        // Build the HTML for the table
        $html = '<div class="col p-0"><table id="' . htmlspecialchars($tableId) . '" class="table table-bordered table-striped table-fixed-header">';
        $html .= '<thead style="background: #607D8B;position: sticky;top: 80px;color: white;font-weight: 900;height: 140px"><tr>';
    
        foreach ($array[0] as $key => $value) {
            if (!in_array($key, ['Agents ID', 'startdate', 'enddate', 'coldtype', 'Leads ID Group'])) {
                $html .= '<th>' . htmlspecialchars($key) . '</th>';
            }
        }
        $html .= '</tr></thead><tbody>';
    
        foreach ($array as $row) {
            $html .= '<tr>';
            foreach ($row as $key => $value) {
                if (!in_array($key, ['Agents ID', 'startdate', 'enddate', 'coldtype', 'Leads ID Group'])) {
                    $href = generate_dynamic_link($part, $key, $value, $row['startdate'], $row['enddate'], $row['Agents ID'], $row['coldtype'], $row['Leads ID Group']);
                    $html .= '<td height="70" style="vertical-align: middle;"><a href="' . $href . '">' . htmlspecialchars($value) . '</a></td>';
                }
            }
            $html .= '</tr>';
        }
        $html .= '</tbody></table></div>';
        return $html;
    }



    function generate_dynamic_link($part, $column, $cellValue, $startdate, $enddate, $agentsID, $coldtype, $leadIdsQueryParam)
    {
        switch ($part) {
            case 'main':
                if ($column === 'Activities') {
                    return Yii::app()->getBaseUrl(true) . '/sales/searchactivities?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&userr=' . $agentsID . '&yt0=Search';
                }
                if ($column === 'Act Answer') {
                    return Yii::app()->getBaseUrl(true) . '/sales/searchactivities?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&userr=' . $agentsID . '&answer=1&yt0=Search';
                }
                if ($column === 'Act No Answer') {
                    return Yii::app()->getBaseUrl(true) . '/sales/searchactivities?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&userr=' . $agentsID . '&answer=2&yt0=Search';
                }
                if ($column === 'Leads') {
                    $leadIds = explode(',', $leadIdsQueryParam);
                    $leadIdsQueryString = implode('&ids%5B%5D=', $leadIds);
                    return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&ids%5B%5D=' . $leadIdsQueryString . '&yt0=Search';
                }
                break;

            case 'part1':
                if ($column === 'Answer') {
                    return Yii::app()->getBaseUrl(true) . '/sales/Actiontocalss?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&sales=' . $agentsID . '&answer=1';
                }
                if ($column === 'No Answer') {
                    return Yii::app()->getBaseUrl(true) . '/sales/Actiontocalss?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&sales=' . $agentsID . '&answer=2';
                }
                if ($column === 'Local') {
                    return Yii::app()->getBaseUrl(true) . '/sales/Actiontocalss?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&sales=' . $agentsID . '&local=1';
                }
                if ($column === 'Global') {
                    return Yii::app()->getBaseUrl(true) . '/sales/Actiontocalss?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&sales=' . $agentsID . '&local=2';
                }
                if ($column === 'Qualified') {
                    return Yii::app()->getBaseUrl(true) . '/sales/Actiontocalss?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&sales=' . $agentsID . '&leadstate=1';
                }
                if ($column === 'Non Qualified') {
                    return Yii::app()->getBaseUrl(true) . '/sales/Actiontocalss?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&sales=' . $agentsID . '&leadstate=2';
                }
                if ($column === 'Not Clear') {
                    return Yii::app()->getBaseUrl(true) . '/sales/Actiontocalss?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&sales=' . $agentsID . '&leadstate=3';
                }
                if ($column === 'Mixed') {
                    return Yii::app()->getBaseUrl(true) . '/sales/Actiontocalss?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&sales=' . $agentsID . '&leadstate=4';
                }
                if ($column === 'Mix. Q > NQ') {
                    return Yii::app()->getBaseUrl(true) . '/sales/Actiontocalss?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&sales=' . $agentsID . '&leadstate=5';
                }
                if ($column === 'Mix. NQ > Q') {
                    return Yii::app()->getBaseUrl(true) . '/sales/Actiontocalss?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&sales=' . $agentsID . '&leadstate=6';
                }
                break;

            case 'part2':
                if ($column === 'Reservation') {
                    return Yii::app()->getBaseUrl(true) . '/reservation/view?agent=' . $agentsID . '&startdate=' . $startdate . '&enddate=' . $enddate;
                }
                if ($column === 'Contract') {
                    return Yii::app()->getBaseUrl(true) . '/contract/view?agent=' . $agentsID . '&startdate=' . $startdate . '&enddate=' . $enddate;
                }
                break;

            case 'part3':
                if ($column === 'Sales Visit') {
                    return Yii::app()->getBaseUrl(true) . '/marketing/searchvisit?Search%5Buser%5D=' . $agentsID . '&Search%5Bstartdate%5D=' . $startdate . '&Search%5Benddate%5D=' . $enddate . '&yt0=Search';
                }
                if ($column === 'Visits from Telesales') {
                    return Yii::app()->getBaseUrl(true) . '/marketing/searchvisit?Search%5Buser%5D=' . $agentsID . '&Search%5Bstartdate%5D=' . $startdate . '&Search%5Benddate%5D=' . $enddate . '&yt0=Search';
                }
                if ($column === 'Telesales Visits') {
                    return '#';
                }
                break;
        }
        return '#';
    }

    function getReportData($part, $startdate, $enddate, $coldtype)
    {
        $extraCondition = '';
        if ($coldtype == 1) {
            $extraCondition = ' AND leads.coldcall = 1';
        } elseif ($coldtype == 2) {
            $extraCondition = ' AND leads.coldcall IS NULL';
        } elseif ($coldtype == 3) {
            $extraCondition = ' AND leads.coldcall = 3';
        }

        switch ($part) {
            case 'main':
                $sql = "SELECT
                CONCAT(user.fname, ' ', user.lname) AS Agents,
                CONCAT(user.id ) as 'Agents ID',
                COUNT(DISTINCT activities.id) AS Activities,
                COUNT(DISTINCT CASE WHEN activities.answer = 1 THEN activities.id END) AS 'Act Answer',
                COUNT(DISTINCT CASE WHEN activities.answer = 2 THEN activities.id END) AS 'Act No Answer',
                COUNT(DISTINCT CASE WHEN activities.type = 1 THEN activities.id END) AS 'Calls',
                COUNT(DISTINCT CASE WHEN activities.type = 2 THEN activities.id END) AS 'Meetings',
                COUNT(DISTINCT CASE WHEN activities.type = 3 THEN activities.id END) AS 'Emails',
                COUNT(DISTINCT CASE WHEN activities.type = 4 THEN activities.id END) AS 'WhatsApp',
                COUNT(DISTINCT CASE WHEN activities.type = 5 THEN activities.id END) AS 'SMS',
                COUNT(DISTINCT CASE WHEN activities.type IS NULL THEN activities.id END) AS 'Other',
                COUNT(DISTINCT activities.leads_id) AS Leads,
                GROUP_CONCAT(DISTINCT activities.leads_id) AS 'Leads ID Group',
                :startdate AS startdate,
                :enddate AS enddate,
                :coldtype AS coldtype
                
                FROM
                user
                LEFT JOIN
                activities ON user.id = activities.user_id AND activities.date BETWEEN :startdate AND :enddate
                LEFT JOIN
                leads ON activities.leads_id = leads.id AND activities.date BETWEEN :startdate AND :enddate
                WHERE
                user.level != 5 AND activities.date BETWEEN :startdate AND :enddate {$extraCondition}
                GROUP BY
                CONCAT(user.fname, ' ', user.lname), user.id";
                break;
            case 'part1':
                $sql = "SELECT
                CONCAT(user.id ) as 'Agents ID',
                GROUP_CONCAT(DISTINCT activities.leads_id) AS 'Leads ID Group',
                COUNT(DISTINCT CASE WHEN leads.answer = 1 THEN activities.leads_id END) AS 'Answer',
                COUNT(DISTINCT CASE WHEN leads.answer = 2 THEN activities.leads_id END) AS 'No Answer',
                COUNT(DISTINCT CASE WHEN leads.international_code = 20 THEN activities.leads_id END) AS 'Local',
                COUNT(DISTINCT CASE WHEN leads.international_code <> 20 THEN activities.leads_id END) AS 'Global',
                COUNT(DISTINCT CASE WHEN leads.qualified = 1 AND leads.nonqualified IS NULL THEN activities.leads_id END) AS Qualified,
                COUNT(DISTINCT CASE WHEN leads.qualified IS NULL AND leads.nonqualified = 1 THEN activities.leads_id END) AS 'Non Qualified',
                COUNT(DISTINCT CASE WHEN leads.qualified IS NULL AND leads.nonqualified IS NULL THEN activities.leads_id END) AS 'Not Clear',
                COUNT(DISTINCT CASE WHEN leads.qualified = 1 AND leads.nonqualified = 1 THEN activities.leads_id END) AS 'Mixed',
                COUNT(DISTINCT CASE WHEN leads.qualified = 1 AND leads.nonqualified = 1 AND leads.first_classification = 1 THEN activities.leads_id END) AS 'Mix. Q > NQ',
                COUNT(DISTINCT CASE WHEN leads.qualified = 1 AND leads.nonqualified = 1 AND leads.first_classification = 2 THEN activities.leads_id END) AS 'Mix. NQ > Q',
                :startdate AS startdate,
                :enddate AS enddate,
                :coldtype AS coldtype
                
                FROM
                user
                LEFT JOIN
                activities ON user.id = activities.user_id AND activities.date BETWEEN :startdate AND :enddate
                LEFT JOIN
                leads ON activities.leads_id = leads.id AND activities.date BETWEEN :startdate AND :enddate
                WHERE
                user.level != 5 AND activities.date BETWEEN :startdate AND :enddate {$extraCondition}
                GROUP BY
                CONCAT(user.fname, ' ', user.lname), user.id";
                break;
            case 'part2':
                $sql = "SELECT
                CONCAT(user.id ) as 'Agents ID',
                GROUP_CONCAT(DISTINCT activities.leads_id) AS 'Leads ID Group',
                COUNT(DISTINCT CASE WHEN request_reservation.res=1 AND request_reservation.con IS NULL AND request_reservation.con_date IS NULL  THEN activities.leads_id END) 'Reservation',
                COUNT(DISTINCT CASE WHEN request_reservation.con=1 AND request_reservation.con_date IS NOT NULL  THEN activities.leads_id END)  'Contract',
                :startdate AS startdate,
                :enddate AS enddate,
                :coldtype AS coldtype
                
                FROM
                user
                LEFT JOIN
                activities ON user.id = activities.user_id AND activities.date BETWEEN :startdate AND :enddate
                LEFT JOIN
                leads ON activities.leads_id = leads.id AND activities.date BETWEEN :startdate AND :enddate
                LEFT JOIN
                request_reservation on leads.id = request_reservation.lead_id AND activities.date BETWEEN :startdate AND :enddate
                WHERE
                user.level != 5 AND activities.date BETWEEN :startdate AND :enddate {$extraCondition}
                GROUP BY
                CONCAT(user.fname, ' ', user.lname), user.id";
                break;
            case 'part3':
                $sql = "SELECT
                CONCAT(user.id ) as 'Agents ID',
                GROUP_CONCAT(DISTINCT activities.leads_id) AS 'Leads ID Group',
                COUNT(DISTINCT CASE WHEN visit.id AND visit.confirmsales IS NOT NULL AND visit.attended IS NULL THEN visit.id END) AS 'Sales Visit',
                COUNT(DISTINCT CASE WHEN visit.id AND visit.confirm IS NOT NULL THEN visit.id END) AS 'Visits from Telesales',
                COUNT(DISTINCT CASE WHEN visit.id AND visit.confirmsales IS NULL THEN visit.id END) AS 'Telesales Visits',
                :startdate AS startdate,
                :enddate AS enddate,
                :coldtype AS coldtype
                
                FROM
                user
                LEFT JOIN
                activities ON user.id = activities.user_id AND activities.date BETWEEN :startdate AND :enddate
                LEFT JOIN
                leads ON activities.leads_id = leads.id AND activities.date BETWEEN :startdate AND :enddate
                LEFT JOIN
                visit ON user.id = visit.user_id AND visit.date BETWEEN :startdate AND :enddate
                WHERE
                user.level != 5 AND activities.date BETWEEN :startdate AND :enddate {$extraCondition}
                GROUP BY
                CONCAT(user.fname, ' ', user.lname), user.id";
                break;
        }

        try {
            $command = Yii::app()->db->createCommand($sql);
            $command->bindParam(":startdate", $startdate);
            $command->bindParam(":enddate", $enddate);
            $command->bindParam(":coldtype", $coldtype);
            $result = $command->queryAll();

            if (empty($result)) {
                echo "Query executed but returned no data.";
                Yii::app()->end();
            }
            return $result;
        } catch (Exception $e) {
            echo "SQL Error: " . $e->getMessage();
            Yii::app()->end();
        }
    }

    $data = getReportData($part, $startdate, $enddate, $coldtype);
    echo build_table($data, $part);
    Yii::app()->end();
}
?>
<script>
function exportTables() {
    var table1 = document.getElementById("exportable_table14");
    var table2 = document.getElementById("exportable_table15");
    var table3 = document.getElementById("exportable_table16");
    var table4 = document.getElementById("exportable_table17");

    if (!table1 || !table2 || !table3 || !table4) {
        console.error("One or more tables not found.");
        return;
    }

    // Convert each table to a worksheet
    var sheet1 = XLSX.utils.table_to_sheet(table1);
    var sheet2 = XLSX.utils.table_to_sheet(table2);
    var sheet3 = XLSX.utils.table_to_sheet(table3);
    var sheet4 = XLSX.utils.table_to_sheet(table4);

    // Create a new worksheet to combine all tables
    var combinedSheet = {};

    // Copy data from sheet1
    for (var cell in sheet1) {
        if (sheet1.hasOwnProperty(cell) && !cell.startsWith("!")) {
            combinedSheet[cell] = sheet1[cell];
        }
    }

    // Calculate column offset for the next sheet
    var colOffset = XLSX.utils.decode_range(sheet1["!ref"]).e.c + 2; // Add spacing after sheet1

    // Copy data from sheet2 with column offset
    for (var cell in sheet2) {
        if (sheet2.hasOwnProperty(cell) && !cell.startsWith("!")) {
            var cellRef = XLSX.utils.decode_cell(cell);
            var newCell = XLSX.utils.encode_cell({ r: cellRef.r, c: cellRef.c + colOffset });
            combinedSheet[newCell] = sheet2[cell];
        }
    }

    colOffset += XLSX.utils.decode_range(sheet2["!ref"]).e.c + 2; // Add spacing after sheet2

    // Copy data from sheet3 with column offset
    for (var cell in sheet3) {
        if (sheet3.hasOwnProperty(cell) && !cell.startsWith("!")) {
            var cellRef = XLSX.utils.decode_cell(cell);
            var newCell = XLSX.utils.encode_cell({ r: cellRef.r, c: cellRef.c + colOffset });
            combinedSheet[newCell] = sheet3[cell];
        }
    }

    colOffset += XLSX.utils.decode_range(sheet3["!ref"]).e.c + 2; // Add spacing after sheet3

    // Copy data from sheet4 with column offset
    for (var cell in sheet4) {
        if (sheet4.hasOwnProperty(cell) && !cell.startsWith("!")) {
            var cellRef = XLSX.utils.decode_cell(cell);
            var newCell = XLSX.utils.encode_cell({ r: cellRef.r, c: cellRef.c + colOffset });
            combinedSheet[newCell] = sheet4[cell];
        }
    }

    // Define the new range for the combined sheet
    var lastRow = Math.max(
        XLSX.utils.decode_range(sheet1["!ref"]).e.r,
        XLSX.utils.decode_range(sheet2["!ref"]).e.r,
        XLSX.utils.decode_range(sheet3["!ref"]).e.r,
        XLSX.utils.decode_range(sheet4["!ref"]).e.r
    );
    var lastCol = colOffset + XLSX.utils.decode_range(sheet4["!ref"]).e.c;
    combinedSheet["!ref"] = XLSX.utils.encode_range({ r: 0, c: 0 }, { r: lastRow, c: lastCol });

    // Create a new workbook and append the combined sheet
    var workbook = XLSX.utils.book_new();
    XLSX.utils.book_append_sheet(workbook, combinedSheet, "Combined Tables");

    // Export the workbook to Excel
    XLSX.writeFile(workbook, "combined_tables.xlsx");
}

</script>