				<?php
                if (Yii::app()->request->isAjaxRequest) {
                $startdate = Yii::app()->request->getPost('startdate');
                $enddate = Yii::app()->request->getPost('enddate');
                $coldtype = Yii::app()->request->getPost('coldtype');
                                function build_table($array)
                                {
                                    // start table
                                    $html = '<table class="table table-bordered table-striped table-fixed-header" id="exportable_table17">';
                                    // header row
                                    $html .= '<thead style="background: #607D8B;position: sticky;top: 80px;color: white;font-weight: 900;height: 140px"><tr>';
                                    foreach ($array[0] as $key => $value) {
                                        if (!in_array($key, ['Agents ID', 'startdate', 'enddate', 'coldtype', 'Leads ID Group'])) {
                                            $html .= '<th>' . htmlspecialchars($key) . '</th>';
                                        }
                                    }
                                    $html .= '</tr></thead>';

                                    // data rows
                                    foreach ($array as $key => $value) {
                                        $html .= '<tr>';
                                        foreach ($value as $key2 => $value2) {
                                            if (!in_array($key2, ['Agents ID', 'startdate', 'enddate', 'coldtype', 'Leads ID Group'])) {
                                                // Check if the current column is 'Agents'
                                                if ($key2 === 'Agents') {
                                                    // Display 'Agents' without <a> tag
                                                    $html .= '<td height="70" style="vertical-align: middle;">' . htmlspecialchars($value2) . '</td>';
                                                } else {
                                                    // Generate a dynamic link based on the cell value
                                                    $href = generate_dynamic_link($key2, $value2, $value['startdate'], $value['enddate'], $value['Agents ID'], $value['coldtype'], $value['Leads ID Group']);
                                                    $html .= '<td height="70" style="vertical-align: middle;"><a href="' . $href . '">' . htmlspecialchars($value2) . '</a></td>';
                                                }
                                            }
                                        }
                                        $html .= '</tr>';
                                    }

                                    // header row
                                    $html .= '<tfoot style="background: #d7d7d7;"><tr>';
                                    foreach ($array[0] as $key => $value) {
                                        if (!in_array($key, ['Agents ID', 'startdate', 'enddate', 'coldtype', 'Leads ID Group', 'Actual Leads ID Group'])) {
                                            $class = '';
                                            switch ($key) {
                                                case 'Fresh Leads':
                                                case 'Actual Leads':
                                                    $class = 'fresh-leads-title';
                                                    break;
                                                case 'Qualified':
                                                    $class = 'qualified-title';
                                                    break;
                                                case 'Not Comm.':
                                                case 'Non Qualified':
                                                case 'Mixed':
                                                    $class = 'non-qualified-title';
                                                    break;
                                            }
                                            $html .= '<th>' . htmlspecialchars($key) . '</th>';
                                        }
                                    }
                                    $html .= '</tr></tfoot>';
                                	// finish table and return it
                                	$html .= '</table>
                                		<script>
                                        function exportTables() {
                                            var table1 = document.getElementById("exportable_table14");
                                            var table2 = document.getElementById("exportable_table15");
                                            var table3 = document.getElementById("exportable_table16");
                                            var table4 = document.getElementById("exportable_table17");
                                        
                                            if (!table1 || !table2 || !table3 || !table4) {
                                                console.error("One or more tables not found.");
                                                return;
                                            }
                                        
                                            // Convert each table to a worksheet
                                            var sheet1 = XLSX.utils.table_to_sheet(table1);
                                            var sheet2 = XLSX.utils.table_to_sheet(table2);
                                            var sheet3 = XLSX.utils.table_to_sheet(table3);
                                            var sheet4 = XLSX.utils.table_to_sheet(table4);
                                        
                                            // Create a new worksheet to combine all tables
                                            var combinedSheet = {};
                                        
                                            // Copy data from sheet1
                                            for (var cell in sheet1) {
                                                if (sheet1.hasOwnProperty(cell) && !cell.startsWith("!")) {
                                                    combinedSheet[cell] = sheet1[cell];
                                                }
                                            }
                                        
                                            // Calculate row offset for the next sheet
                                            var rowOffset = XLSX.utils.decode_range(sheet1["!ref"]).e.r + 2; // Add spacing after sheet1
                                        
                                            // Copy data from sheet2 with row offset
                                            for (var cell in sheet2) {
                                                if (sheet2.hasOwnProperty(cell) && !cell.startsWith("!")) {
                                                    var cellRef = XLSX.utils.decode_cell(cell);
                                                    var newCell = XLSX.utils.encode_cell({ r: cellRef.r + rowOffset, c: cellRef.c });
                                                    combinedSheet[newCell] = sheet2[cell];
                                                }
                                            }
                                        
                                            rowOffset += XLSX.utils.decode_range(sheet2["!ref"]).e.r + 2; // Add spacing after sheet2
                                    
                                            // Copy data from sheet3 with row offset
                                            for (var cell in sheet3) {
                                                if (sheet3.hasOwnProperty(cell) && !cell.startsWith("!")) {
                                                    var cellRef = XLSX.utils.decode_cell(cell);
                                                    var newCell = XLSX.utils.encode_cell({ r: cellRef.r + rowOffset, c: cellRef.c });
                                                    combinedSheet[newCell] = sheet3[cell];
                                                }
                                            }
                                    
                                            rowOffset += XLSX.utils.decode_range(sheet3["!ref"]).e.r + 2; // Add spacing after sheet3
                                    
                                            // Copy data from sheet4 with row offset
                                            for (var cell in sheet4) {
                                                if (sheet4.hasOwnProperty(cell) && !cell.startsWith("!")) {
                                                    var cellRef = XLSX.utils.decode_cell(cell);
                                                    var newCell = XLSX.utils.encode_cell({ r: cellRef.r + rowOffset, c: cellRef.c });
                                                    combinedSheet[newCell] = sheet4[cell];
                                                }
                                            }
                                    
                                            // Define the new range for the combined sheet
                                            var lastRow = rowOffset + XLSX.utils.decode_range(sheet4["!ref"]).e.r;
                                            var lastCol = Math.max(
                                                XLSX.utils.decode_range(sheet1["!ref"]).e.c,
                                                XLSX.utils.decode_range(sheet2["!ref"]).e.c,
                                                XLSX.utils.decode_range(sheet3["!ref"]).e.c,
                                                XLSX.utils.decode_range(sheet4["!ref"]).e.c
                                            );
                                            combinedSheet["!ref"] = XLSX.utils.encode_range({ r: 0, c: 0 }, { r: lastRow, c: lastCol });
                                        
                                            // Create a new workbook and append the combined sheet
                                            var workbook = XLSX.utils.book_new();
                                            XLSX.utils.book_append_sheet(workbook, combinedSheet, "Combined Tables");
                                        
                                            // Export the workbook to Excel
                                            XLSX.writeFile(workbook, "combined_tables.xlsx");
                                        }
                                    </script>';
                                
                                	return $html;
                                }

								$extraConditionLink = array(); // Initialize as an array

								if ($cold == 1) {
									$extraConditionLink[] = '1';
								} elseif ($cold == 2) {
									// You can add a default condition for cold == 2 if needed
									$extraConditionLink[] = '2';
								} elseif ($cold == 3) {
									$extraConditionLink[] = '3';
								}

								// Function to generate dynamic links based on cell values
								function generate_dynamic_link($column, $cellValue, $startdate, $enddate, $agentsID, $coldtype, $leadIdsQueryParam)
								{
									if ($column === 'Sales Visit') {
										return Yii::app()->getBaseUrl(true) . '/marketing/searchvisit?Search%5Buser%5D=' . $agentsID . '&Search%5Bstartdate%5D=' . $startdate . '&Search%5Benddate%5D=' . $enddate . '&yt0=Search';
									}
									if ($column === 'Visits from Telesales') {
										return Yii::app()->getBaseUrl(true) . '/marketing/searchvisit?Search%5Buser%5D=' . $agentsID . '&Search%5Bstartdate%5D=' . $startdate . '&Search%5Benddate%5D=' . $enddate . '&yt0=Search';
									}
									if ($column === 'Telesales Visits') {
										return '#';
									}

									return '#';
								}

								if ($cold == 1)
									$extraCondition = ' and leads.coldcall is not null';
								elseif ($cold == 2)
									$extraCondition = ' and leads.coldcall is null';
								elseif ($cold == 3)
									$extraCondition = ' and leads.coldcall = 3';

                                $sql = "SELECT
    CONCAT(user.id ) as 'Agents ID',
    GROUP_CONCAT(DISTINCT activities.leads_id) AS 'Leads ID Group',
    COUNT(DISTINCT CASE WHEN visit.id AND visit.confirmsales IS NOT NULL AND visit.attended IS NULL THEN visit.id END) AS 'Sales Visit',
    COUNT(DISTINCT CASE WHEN visit.id AND visit.confirm IS NOT NULL THEN visit.id END) AS 'Visits from Telesales',
    COUNT(DISTINCT CASE WHEN visit.id AND visit.confirmsales IS NULL THEN visit.id END) AS 'Telesales Visits',
    :startdate AS startdate,
    :enddate AS enddate,
    :coldtype AS coldtype

FROM
    user
LEFT JOIN
    activities ON user.id = activities.user_id AND activities.date BETWEEN :startdate AND :enddate
LEFT JOIN
    leads ON activities.leads_id = leads.id AND activities.date BETWEEN :startdate AND :enddate
LEFT JOIN
    visit ON user.id = visit.user_id AND visit.date BETWEEN :startdate AND :enddate
WHERE
    user.level != 5 AND activities.date BETWEEN :startdate AND :enddate {$extraCondition}
GROUP BY
    CONCAT(user.fname, ' ', user.lname), user.id";
								$command = Yii::app()->db->createCommand($sql);
								$command->bindParam(":startdate", $startdate);
								$command->bindParam(":enddate", $enddate);
								$command->bindParam(":coldtype", $extraConditionLink[0]);
								$list = $command->queryAll();

								$leadIdsQueryParam = isset($list[0]['Leads ID Group']) ? '&ids%5B%5D=' . $list[0]['Leads ID Group'] : '';

								// Output the table
                    echo build_table($list);
                    Yii::app()->end();
                }
                ?>