<?php


	ini_set('max_execution_time', 300);
	ini_set('memory_limit', '-1');



	?>
	<div class="kt-portlet kt-portlet--height-fluid col-xl-12 col-md-12 col-lg-12" id="reportHolder">
		<div class="kt-portlet__head">
			<div class="kt-portlet__head-label">
				<h3 class="kt-portlet__head-title">
					Cash Flow Statement/التدفقات النقدية 
				</h3>
			</div>
			<div class="kt-portlet__head-toolbar">
				<div class="kt-widget__action mr-1">
					<button type="button" class="btn btn-bold btn-label-brand btn-sm"  onclick="ExportExcel1('xlsx')">Excel</button>
				</div>
				<div class="kt-widget__action">
					<button type="button" class="btn btn-bold btn-label-brand btn-sm" id="pngReportButton">PNG</button>
				</div>
			</div>
		</div>
				<div class="kt-portlet__body">
					<!--Solid Form-->
					<div class="kt-portlet__body kt-portlet__body--fit"  >
<?php
// Execute the SQL query using Yii's DB connection
$sql = "
    SELECT 
        mt.title AS main_category,
        t1.id AS tree_id,
        t1.title AS tree_title,
        t1.code AS tree_code,
        t1.credit_balance_till AS balance,
        COALESCE(t2.title, 'N/A') AS parent_title,
        COALESCE(t2.code, 'N/A') AS parent_code
    FROM 
        fi_tree t1
    LEFT JOIN 
        fi_tree t2 ON t1.tree_id = t2.id
    INNER JOIN 
        fi_main_tree mt ON t1.main_tree_id = mt.id
    ORDER BY 
        mt.id, t1.tree_id, t1.code;
";

$command = Yii::app()->db->createCommand($sql);
$results = $command->queryAll();

// Initialize arrays for each cash flow category
$operating_activities = [];
$investing_activities = [];
$financing_activities = [];

// Distribute results into the appropriate categories
foreach ($results as $row) {
    switch ($row['main_category']) {
        case 'Revenues':
        case 'Expenses':
            $operating_activities[] = $row;
            break;
        case 'Assets':
            $investing_activities[] = $row;
            break;
        case 'Liabilities':
        case 'Equity':
            $financing_activities[] = $row;
            break;
    }
}
?>

<table border="1" class="table thead-light striped bordered condensed responsive dataTable">

<!-- Operating Activities -->
<h3 class="section-title">التدفقات النقدية من الأنشطة التشغيلية</h3>
<table class="table thead-light striped bordered condensed responsive dataTable">
      <thead>
        <tr>
            <th>الفئة الرئيسية</th>
            <th>ID</th>
            <th>العنوان</th>
            <th>الكود</th>
            <th>الرصيد</th>
            <th>العنوان الأب</th>
            <th>كود الأب</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($operating_activities as $row): ?>
        <tr>
            <td><?php echo CHtml::encode($row['main_category']); ?></td>
            <td><?php echo CHtml::encode($row['tree_id']); ?></td>
            <td><?php echo CHtml::encode($row['tree_title']); ?></td>
            <td><?php echo CHtml::encode($row['tree_code']); ?></td>
            <td><?php echo CHtml::encode(number_format($row['balance'], 2)); ?></td>
            <td><?php echo CHtml::encode($row['parent_title']); ?></td>
            <td><?php echo CHtml::encode($row['parent_code']); ?></td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<!-- Investing Activities -->
<h3 class="section-title">التدفقات النقدية من الأنشطة الاستثمارية</h3>
<table class="table thead-light striped bordered condensed responsive dataTable">
    <thead>
        <tr>
            <th>الفئة الرئيسية</th>
            <th>ID</th>
            <th>العنوان</th>
            <th>الكود</th>
            <th>الرصيد</th>
            <th>العنوان الأب</th>
            <th>كود الأب</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($investing_activities as $row): ?>
        <tr>
            <td><?php echo CHtml::encode($row['main_category']); ?></td>
            <td><?php echo CHtml::encode($row['tree_id']); ?></td>
            <td><?php echo CHtml::encode($row['tree_title']); ?></td>
            <td><?php echo CHtml::encode($row['tree_code']); ?></td>
            <td><?php echo CHtml::encode(number_format($row['balance'], 2)); ?></td>
            <td><?php echo CHtml::encode($row['parent_title']); ?></td>
            <td><?php echo CHtml::encode($row['parent_code']); ?></td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<!-- Financing Activities -->
<h3 class="section-title">التدفقات النقدية من الأنشطة التمويلية</h3>
<table class="table thead-light striped bordered condensed responsive dataTable">
   <thead>
        <tr>
            <th>الفئة الرئيسية</th>
            <th>ID</th>
            <th>العنوان</th>
            <th>الكود</th>
            <th>الرصيد</th>
            <th>العنوان الأب</th>
            <th>كود الأب</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($financing_activities as $row): ?>
        <tr>
            <td><?php echo CHtml::encode($row['main_category']); ?></td>
            <td><?php echo CHtml::encode($row['tree_id']); ?></td>
            <td><?php echo CHtml::encode($row['tree_title']); ?></td>
            <td><?php echo CHtml::encode($row['tree_code']); ?></td>
            <td><?php echo CHtml::encode(number_format($row['balance'], 2)); ?></td>
            <td><?php echo CHtml::encode($row['parent_title']); ?></td>
            <td><?php echo CHtml::encode($row['parent_code']); ?></td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>

				</div>
			</div>
		</div>