<?php


	ini_set('max_execution_time', 300);
	ini_set('memory_limit', '-1');



	?>
	<div class="kt-portlet kt-portlet--height-fluid col-xl-12 col-md-12 col-lg-12" id="reportHolder">
		<div class="kt-portlet__head">
			<div class="kt-portlet__head-label">
				<h3 class="kt-portlet__head-title">
					Net Assets Value (NAV)/صافي الاصول 
				</h3>
			</div>
			<div class="kt-portlet__head-toolbar">
				<div class="kt-widget__action mr-1">
					<button type="button" class="btn btn-bold btn-label-brand btn-sm"  onclick="ExportExcel1('xlsx')">Excel</button>
				</div>
				<div class="kt-widget__action">
					<button type="button" class="btn btn-bold btn-label-brand btn-sm" id="pngReportButton">PNG</button>
				</div>
			</div>
		</div>
				<div class="kt-portlet__body">
					<!--Solid Form-->
					<div class="kt-portlet__body kt-portlet__body--fit"  >
<?php
// Query to fetch the summary of net assets
$command = Yii::app()->db->createCommand("
    SELECT 
        SUM(CASE WHEN fi_main_tree.id = 1 THEN fi_tree.credit_balance_till ELSE 0 END) AS TotalAssets,
        SUM(CASE WHEN fi_main_tree.id = 2 THEN fi_tree.credit_balance_till ELSE 0 END) AS TotalLiabilities,
        (SUM(CASE WHEN fi_main_tree.id = 1 THEN fi_tree.credit_balance_till ELSE 0 END) 
         - 
         SUM(CASE WHEN fi_main_tree.id = 2 THEN fi_tree.credit_balance_till ELSE 0 END)) AS NetAssets
    FROM 
        fi_tree
    INNER JOIN 
        fi_main_tree ON fi_tree.main_tree_id = fi_main_tree.id
    WHERE 
        fi_main_tree.id IN (1, 2);
");

$summary = $command->queryRow();
?>

<?php
// Query to fetch detailed breakdown of assets and liabilities
$command = Yii::app()->db->createCommand("
    SELECT 
        fi_main_tree.title AS Category,
        fi_tree.title AS SubCategory,
        fi_tree.credit_balance_till AS Balance
    FROM 
        fi_tree
    INNER JOIN 
        fi_main_tree ON fi_tree.main_tree_id = fi_main_tree.id
    WHERE 
        fi_main_tree.id IN (1, 2) -- Assets and Liabilities
    ORDER BY 
        fi_main_tree.id, fi_tree.id;
");

$results = $command->queryAll();
?>

<h3>ملخص التقرير</h3>
<table border="1" class="table thead-light striped bordered condensed responsive dataTable">
    <thead>
   <tr>
        <th>إجمالي الأصول</th>
        <th>إجمالي الالتزامات</th>
        <th>صافي الأصول</th>
    </tr>
    </thead>
    <tbody>
    <tr>
        <td><?php echo number_format($summary['TotalAssets'], 2); ?></td>
        <td><?php echo number_format($summary['TotalLiabilities'], 2); ?></td>
        <td><?php echo number_format($summary['NetAssets'], 2); ?></td>
    </tr>
    </tbody>
</table>

<h3>تفاصيل الأصول والالتزامات</h3>
<table border="1" class="table thead-light striped bordered condensed responsive dataTable">
    <thead>
   <tr>
        <th>الفئة</th>
        <th>العنوان الفرعي</th>
        <th>الرصيد</th>
    </tr>
    </thead>
    <tbody>
    <?php foreach($results as $row): ?>
    <tr>
        <td><?php echo $row['Category']; ?></td>
        <td><?php echo $row['SubCategory']; ?></td>
        <td><?php echo number_format($row['Balance'], 2); ?></td>
    </tr>
    <?php endforeach; ?>
    </tbody>
</table>
				</div>
			</div>
		</div>