<?php
$startdate = date('Y-m-1'); 
$enddate = date('Y-m-31');
$list = Yii::app()->db->createCommand("
SELECT
    CONCAT(u.fname, ' ', u.lname) AS 'Agents',
    
    -- Reservation Shares
    SUM(CASE WHEN r.sales1 = u.id AND (r.con_date = '' OR r.con_date IS NULL) AND r.confirm IS NULL THEN 1 ELSE 0 END) AS 'Reservation 1st Share',
    SUM(CASE WHEN r.sales2 = u.id AND (r.con_date = '' OR r.con_date IS NULL) AND r.confirm IS NULL THEN 1 ELSE 0 END) AS 'Reservation 2nd Share',
    SUM(CASE WHEN r.sales3 = u.id AND (r.con_date = '' OR r.con_date IS NULL) AND r.confirm IS NULL THEN 1 ELSE 0 END) AS 'Reservation 3rd Share',
    SUM(CASE WHEN r.sales4 = u.id AND (r.con_date = '' OR r.con_date IS NULL) AND r.confirm IS NULL THEN 1 ELSE 0 END) AS 'Reservation 4th Share',
    SUM(CASE WHEN r.sales5 = u.id AND (r.con_date = '' OR r.con_date IS NULL) AND r.confirm IS NULL THEN 1 ELSE 0 END) AS 'Reservation 5th Share',
    SUM(CASE WHEN r.sales6 = u.id AND (r.con_date = '' OR r.con_date IS NULL) AND r.confirm IS NULL THEN 1 ELSE 0 END) AS 'Reservation 6th Share',
    
    -- Reservation Amounts
    SUM(CASE WHEN r.sales1 = u.id AND (r.con_date = '' OR r.con_date IS NULL) AND r.confirm IS NULL THEN (r.unit_price * r.sales1ra) / 100 ELSE 0 END) AS 'Reservation Amount 1st Share',
    SUM(CASE WHEN r.sales2 = u.id AND (r.con_date = '' OR r.con_date IS NULL) AND r.confirm IS NULL THEN (r.unit_price * r.sales2ra) / 100 ELSE 0 END) AS 'Reservation Amount 2nd Share',
    SUM(CASE WHEN r.sales3 = u.id AND (r.con_date = '' OR r.con_date IS NULL) AND r.confirm IS NULL THEN (r.unit_price * r.sales3ra) / 100 ELSE 0 END) AS 'Reservation Amount 3rd Share',
    SUM(CASE WHEN r.sales4 = u.id AND (r.con_date = '' OR r.con_date IS NULL) AND r.confirm IS NULL THEN (r.unit_price * r.sales4ra) / 100 ELSE 0 END) AS 'Reservation Amount 4th Share',
    SUM(CASE WHEN r.sales5 = u.id AND (r.con_date = '' OR r.con_date IS NULL) AND r.confirm IS NULL THEN (r.unit_price * r.sales5ra) / 100 ELSE 0 END) AS 'Reservation Amount 5th Share',
    SUM(CASE WHEN r.sales6 = u.id AND (r.con_date = '' OR r.con_date IS NULL) AND r.confirm IS NULL THEN (r.unit_price * r.sales6ra) / 100 ELSE 0 END) AS 'Reservation Amount 6th Share',
    
    -- Contract Shares
    SUM(CASE WHEN r.sales1 = u.id AND r.confirm IS NOT NULL THEN 1 ELSE 0 END) AS 'Contract 1st Share',
    SUM(CASE WHEN r.sales2 = u.id AND r.confirm IS NOT NULL THEN 1 ELSE 0 END) AS 'Contract 2nd Share',
    SUM(CASE WHEN r.sales3 = u.id AND r.confirm IS NOT NULL THEN 1 ELSE 0 END) AS 'Contract 3rd Share',
    SUM(CASE WHEN r.sales4 = u.id AND r.confirm IS NOT NULL THEN 1 ELSE 0 END) AS 'Contract 4th Share',
    SUM(CASE WHEN r.sales5 = u.id AND r.confirm IS NOT NULL THEN 1 ELSE 0 END) AS 'Contract 5th Share',
    SUM(CASE WHEN r.sales6 = u.id AND r.confirm IS NOT NULL THEN 1 ELSE 0 END) AS 'Contract 6th Share',
    
    -- Contract Amounts
    SUM(CASE WHEN r.sales1 = u.id AND r.confirm IS NOT NULL THEN (r.unit_price * r.sales1ra) / 100 ELSE 0 END) AS 'Contract Amount 1st Share',
    SUM(CASE WHEN r.sales2 = u.id AND r.confirm IS NOT NULL THEN (r.unit_price * r.sales2ra) / 100 ELSE 0 END) AS 'Contract Amount 2nd Share',
    SUM(CASE WHEN r.sales3 = u.id AND r.confirm IS NOT NULL THEN (r.unit_price * r.sales3ra) / 100 ELSE 0 END) AS 'Contract Amount 3rd Share',
    SUM(CASE WHEN r.sales4 = u.id AND r.confirm IS NOT NULL THEN (r.unit_price * r.sales4ra) / 100 ELSE 0 END) AS 'Contract Amount 4th Share',
    SUM(CASE WHEN r.sales5 = u.id AND r.confirm IS NOT NULL THEN (r.unit_price * r.sales5ra) / 100 ELSE 0 END) AS 'Contract Amount 5th Share',
    SUM(CASE WHEN r.sales6 = u.id AND r.confirm IS NOT NULL THEN (r.unit_price * r.sales6ra) / 100 ELSE 0 END) AS 'Contract Amount 6th Share'
FROM `user` AS u
LEFT JOIN reservation AS r
    ON u.id IN (r.sales1, r.sales2, r.sales3, r.sales4, r.sales5, r.sales6)
WHERE r.cancel IS NULL 
AND r.date BETWEEN :startdate AND :enddate
GROUP BY u.id
")->bindValues([
    ':startdate' => $startdate, //first day in each month 
    ':enddate' => $enddate // last day in each month 
])->queryAll();

// Prepare data for the chart
$chartData = [];
foreach ($list as $row) {
    $chartData[] = [
        'category' => $row['Agents'],
        'reservation' => array_sum(array_slice($row, 1, 6)), // Total reservations
        'reservationAmount' => array_sum(array_slice($row, 7, 6)), // Total reservation amounts
        'contract' => array_sum(array_slice($row, 13, 6)), // Total contracts
        'contractAmount' => array_sum(array_slice($row, 19, 6)) // Total contract amounts
    ];
}
?>
<div id="chartdivcon"></div>
<style>
    #chartdivcon{
        width:100%;height:500px;
    }
</style>
<script>
am4core.ready(function() {

// Themes begin
am4core.useTheme(am4themes_animated);
// Themes end

var chart = am4core.create("chartdivcon", am4charts.XYChart);

// Embed PHP data into JavaScript
var data = <?php echo json_encode($chartData); ?>;

chart.data = data;

var categoryAxis = chart.xAxes.push(new am4charts.CategoryAxis());
categoryAxis.dataFields.category = "category";
categoryAxis.renderer.minGridDistance = 20;

var valueAxis = chart.yAxes.push(new am4charts.ValueAxis());
valueAxis.title.text = "Counts and Amounts";

var series1 = chart.series.push(new am4charts.ColumnSeries());
series1.dataFields.valueY = "reservation";
series1.dataFields.categoryX = "category";
series1.name = "Reservations";
series1.tooltipText = "{name}: [bold]{valueY}[/]";
series1.stacked = true;

var series2 = chart.series.push(new am4charts.ColumnSeries());
series2.dataFields.valueY = "contract";
series2.dataFields.categoryX = "category";
series2.name = "Contracts";
series2.tooltipText = "{name}: [bold]{valueY}[/]";
series2.stacked = true;

var series3 = chart.series.push(new am4charts.LineSeries());
series3.dataFields.valueY = "reservationAmount";
series3.dataFields.categoryX = "category";
series3.name = "Reservation Amount";
series3.strokeWidth = 2;
series3.bullets.push(new am4charts.CircleBullet());
series3.tooltipText = "{name}: [bold]{valueY}[/]";

var series4 = chart.series.push(new am4charts.LineSeries());
series4.dataFields.valueY = "contractAmount";
series4.dataFields.categoryX = "category";
series4.name = "Contract Amount";
series4.strokeWidth = 2;
series4.strokeDasharray = "3,3";
series4.bullets.push(new am4charts.CircleBullet());
series4.tooltipText = "{name}: [bold]{valueY}[/]";

chart.legend = new am4charts.Legend();

chart.cursor = new am4charts.XYCursor();

}); // end am4core.ready()
</script>
