<?php $today = date("Y-m-d"); ?>
<?php
$userId = Yii::app()->user->id;
$list= Yii::app()->db->createCommand("SELECT 
concat(user.fname,' ',user.lname ) as 'Agents', 
count(distinct (case when freshleads.id and freshleads.coldcall is null then freshleads.id end)) 'Fresh Leads',
count(distinct (case when freshleads.id and freshleads.coldcall ='1' then freshleads.id end)) 'Cold Leads',
count(distinct (case when freshleads.id and freshleads.coldcall ='3' then freshleads.id end)) 'Indirect Leads',
count(distinct (case when freshleads.id and freshleads.coldcall is null and freshleads.communication is null and freshleads.transfer is null and freshleads.close is null then freshleads.id end)) 'Fresh Leads Not Communication',
count(distinct (case when freshleads.id and freshleads.coldcall ='1' and freshleads.communication is null and freshleads.transfer is null and freshleads.close is null then freshleads.id end)) 'Cold Leads Not Communication',
count(distinct (case when freshleads.id and freshleads.coldcall ='3' and freshleads.communication is null and freshleads.transfer is null and freshleads.close is null then freshleads.id end)) 'Indirect Leads Not Communication',
count(distinct (case when actualleads.id and actualleads.coldcall is null and actualleads.communication is null and actualleads.transfer = '1' then actualleads.id end)) 'Fresh Leads Rotation',
count(distinct (case when actualleads.id and actualleads.coldcall ='1' and actualleads.communication is null and actualleads.transfer = '1' then actualleads.id end)) 'Cold Leads Rotation',
count(distinct (case when actualleads.id and actualleads.coldcall ='3' and actualleads.communication is null and actualleads.transfer = '1' then actualleads.id end)) 'Indirect Leads Rotation',
count(distinct (case when actualleads.id and actualleads.coldcall is null and actualleads.follow_date < '$today' and actualleads.close is null and actualleads.communication is not null then actualleads.id end)) 'Fresh Leads Delay',
count(distinct (case when actualleads.id and actualleads.coldcall ='1' and actualleads.follow_date < '$today' and actualleads.close is null and actualleads.communication is not null then actualleads.id end)) 'Cold Leads Delay',
count(distinct (case when actualleads.id and actualleads.coldcall ='3' and actualleads.follow_date < '$today' and actualleads.close is null and actualleads.communication is not null then actualleads.id end)) 'Indirect Leads Delay',
count(distinct (case when actualleads.id and actualleads.coldcall is null and actualleads.follow_date = '$today' then actualleads.id end)) 'Fresh Leads Follow Up',
count(distinct (case when actualleads.id and actualleads.coldcall ='1' and actualleads.follow_date = '$today' then actualleads.id end)) 'Cold Leads Follow Up',
count(distinct (case when actualleads.id and actualleads.coldcall ='3' and actualleads.follow_date = '$today' then actualleads.id end)) 'Indirect Leads Follow Up'

FROM `user` 
left join leads as freshleads on freshleads.fresh_sales = user.id
left join leads as actualleads on actualleads.user_sales = user.id
left join teamleader on user.id = teamleader.sales_id 

WHERE user.level != 5 and teamleader.leader_id = :userId
GROUP by user.id")
    ->bindParam(':userId', $userId, PDO::PARAM_INT)
    ->queryAll();
?>
<div class="row">
<!-- Daily Distributed Leads by Type -->
<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
<div class="kt-portlet kt-portlet--fit kt-portlet--head-lg kt-portlet--head-overlay kt-portlet--skin-solid kt-portlet--height-fluid">
<div class="kt-portlet__head kt-portlet__head--noborder kt-portlet__space-x">
<div class="kt-portlet__head-label">
<h3 class="kt-portlet__head-title kt-font-dark">
Daily Distributed Leads by Type
</h3>
</div>
<div class="kt-portlet__head-toolbar">
</div>
</div>
<div class="kt-portlet__body kt-portlet__body--fit mt-0">
<div id="chartAgentRanking" class="chartdiv"></div>
</div>
</div>
</div>
<script>
am4core.useTheme(am4themes_animated);
var chart = am4core.create("chartAgentRanking", am4charts.XYChart);chart.hiddenState.properties.opacity = 0; // this creates initial fade-in
chart.colors.step = 2;

chart.legend = new am4charts.Legend()
chart.legend.position = 'top'
chart.legend.paddingBottom = 20
chart.legend.labels.template.maxWidth = 95

chart.colors.list = [
  am4core.color("#845EC2"),
  am4core.color("#D65DB1"),
  am4core.color("#FF6F91"),
  am4core.color("#FF9671"),
  am4core.color("#FFC75F"),
  am4core.color("#F9F871")
];

var xAxis = chart.xAxes.push(new am4charts.CategoryAxis())
xAxis.dataFields.category = 'category'
xAxis.renderer.cellStartLocation = 0.1
xAxis.renderer.cellEndLocation = 0.9
xAxis.renderer.grid.template.location = 0;

var yAxis = chart.yAxes.push(new am4charts.ValueAxis());
yAxis.min = 0;

function createSeries(value, name) {
    var series = chart.series.push(new am4charts.ColumnSeries())
    series.dataFields.valueY = value
    series.dataFields.categoryX = 'category'
    series.name = name

    series.events.on("hidden", arrangeColumns);
    series.events.on("shown", arrangeColumns);
    series.tooltipText = "[bold]{valueY}[/]";

    var bullet = series.bullets.push(new am4charts.LabelBullet())
    bullet.interactionsEnabled = false
    bullet.dy = 30;
    bullet.label.text = '{valueY}'
    bullet.label.fill = am4core.color('#ffffff')

    return series;
}

chart.data = [
    <?php
    if(!empty($list)){
    foreach($list as  $item){ ?>           
    {
        category: '<?php echo $item['Agents']?>',
        first: <?php echo $item['Fresh Leads']?>,
        second: <?php echo $item['Cold Leads']?>,
        third: <?php echo $item['Indirect Leads']?>
    },
    <?php } } ?>
]

var dataSource = chart.createChild(am4core.TextLink)
dataSource.text = "Data source: Distributed Leads by Type";
dataSource.fontSize = 12;
dataSource.align = "left";
dataSource.valign = "top"
dataSource.url = "<?php echo Yii::app()->getBaseUrl(true) ?>/engineering/showdashboard?typedate=1&startdate=2000-01-01&enddate=2100-01-01&cold=2&type=&branch=&view=1975&yt0=Get+Report"
dataSource.urlTarget = "_blank";
dataSource.fill = am4core.color("#927459");
dataSource.padding(10,10,10,10);
dataSource.marginLeft = 30;
dataSource.marginTop = 30;
dataSource.background = new am4core.RoundedRectangle()
dataSource.background.cornerRadius(10,10,10,10);
dataSource.background.strokeOpacity = 0.3;
dataSource.background.stroke =am4core.color("#927459");
dataSource.background.fill = am4core.color("#f9e3ce");
dataSource.background.fillOpacity = 0.6;

createSeries('first', 'Fresh');
createSeries('second', 'Cold');
createSeries('third', 'Indirect');

function arrangeColumns() {

    var series = chart.series.getIndex(0);

    var w = 1 - xAxis.renderer.cellStartLocation - (1 - xAxis.renderer.cellEndLocation);
    if (series.dataItems.length > 1) {
        var x0 = xAxis.getX(series.dataItems.getIndex(0), "categoryX");
        var x1 = xAxis.getX(series.dataItems.getIndex(1), "categoryX");
        var delta = ((x1 - x0) / chart.series.length) * w;
        if (am4core.isNumber(delta)) {
            var middle = chart.series.length / 2;

            var newIndex = 0;
            chart.series.each(function(series) {
                if (!series.isHidden && !series.isHiding) {
                    series.dummyData = newIndex;
                    newIndex++;
                }
                else {
                    series.dummyData = chart.series.indexOf(series);
                }
            })
            var visibleCount = newIndex;
            var newMiddle = visibleCount / 2;

            chart.series.each(function(series) {
                var trueIndex = chart.series.indexOf(series);
                var newIndex = series.dummyData;

                var dx = (newIndex - trueIndex + middle - newMiddle) * delta

                series.animate({ property: "dx", to: dx }, series.interpolationDuration, series.interpolationEasing);
                series.bulletsContainer.animate({ property: "dx", to: dx }, series.interpolationDuration, series.interpolationEasing);
            })
        }
    }
}// Add simple vertical scrollbar
chart.scrollbarY = new am4core.Scrollbar();
// Add horizotal scrollbar with preview
var scrollbarX = new am4charts.XYChartScrollbar();
scrollbarX.series.push(series);
chart.scrollbarX = scrollbarX;
// Add cursor
chart.cursor = new am4charts.XYCursor();
</script>
<!-- /Daily Distributed Leads by Type -->
<!-- Not Communicated Leads by Type -->
<div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
<div class="kt-portlet kt-portlet--fit kt-portlet--head-lg kt-portlet--head-overlay kt-portlet--skin-solid kt-portlet--height-fluid">
<div class="kt-portlet__head kt-portlet__head--noborder kt-portlet__space-x">
<div class="kt-portlet__head-label">
<h3 class="kt-portlet__head-title kt-font-dark">
Not Communicated Leads by Type
</h3>
</div>
<div class="kt-portlet__head-toolbar">
</div>
</div>
<div class="kt-portlet__body kt-portlet__body--fit mt-0">
<div id="chartNotCommunicated" class="chartdiv"></div>
</div>
</div>
</div>
<script>
am4core.useTheme(am4themes_animated);
var chartNotCommunicated = am4core.create("chartNotCommunicated", am4charts.XYChart);chart.hiddenState.properties.opacity = 0; // this creates initial fade-in
chartNotCommunicated.colors.step = 2;

chartNotCommunicated.legend = new am4charts.Legend()
chartNotCommunicated.legend.position = 'top'
chartNotCommunicated.legend.paddingBottom = 20
chartNotCommunicated.legend.labels.template.maxWidth = 95

chartNotCommunicated.colors.list = [
  am4core.color("#845EC2"),
  am4core.color("#D65DB1"),
  am4core.color("#FF6F91"),
  am4core.color("#FF9671"),
  am4core.color("#FFC75F"),
  am4core.color("#F9F871")
];

var xAxis = chartNotCommunicated.xAxes.push(new am4charts.CategoryAxis())
xAxis.dataFields.category = 'category'
xAxis.renderer.cellStartLocation = 0.1
xAxis.renderer.cellEndLocation = 0.9
xAxis.renderer.grid.template.location = 0;

var yAxis = chartNotCommunicated.yAxes.push(new am4charts.ValueAxis());
yAxis.min = 0;

function createSeries(value, name) {
    var series = chartNotCommunicated.series.push(new am4charts.ColumnSeries())
    series.dataFields.valueY = value
    series.dataFields.categoryX = 'category'
    series.name = name

    series.events.on("hidden", arrangeColumns);
    series.events.on("shown", arrangeColumns);
    series.tooltipText = "[bold]{valueY}[/]";

    var bullet = series.bullets.push(new am4charts.LabelBullet())
    bullet.interactionsEnabled = false
    bullet.dy = 30;
    bullet.label.text = '{valueY}'
    bullet.label.fill = am4core.color('#ffffff')

    return series;
}

chartNotCommunicated.data = [
    <?php
    if(!empty($list)){
    foreach($list as  $item){ ?>           
    {
        category: '<?php echo $item['Agents']?>',
        first: <?php echo $item['Fresh Leads Not Communication']?>,
        second: <?php echo $item['Cold Leads Not Communication']?>,
        third: <?php echo $item['Indirect Leads Not Communication']?>
    },
    <?php } } ?>
]

var dataSource = chartNotCommunicated.createChild(am4core.TextLink)
dataSource.text = "Data source: Not Communicated Leads by Type";
dataSource.fontSize = 12;
dataSource.align = "left";
dataSource.valign = "top"
dataSource.url = "<?php echo Yii::app()->getBaseUrl(true) ?>/engineering/showdashboard?typedate=1&startdate=2000-01-01&enddate=2100-01-01&cold=2&type=&branch=&view=1976&yt0=Get+Report"
dataSource.urlTarget = "_blank";
dataSource.fill = am4core.color("#927459");
dataSource.padding(10,10,10,10);
dataSource.marginLeft = 30;
dataSource.marginTop = 30;
dataSource.background = new am4core.RoundedRectangle()
dataSource.background.cornerRadius(10,10,10,10);
dataSource.background.strokeOpacity = 0.3;
dataSource.background.stroke =am4core.color("#927459");
dataSource.background.fill = am4core.color("#f9e3ce");
dataSource.background.fillOpacity = 0.6;

createSeries('first', 'Fresh');
createSeries('second', 'Cold');
createSeries('third', 'Indirect');

function arrangeColumns() {

    var series = chartNotCommunicated.series.getIndex(0);

    var w = 1 - xAxis.renderer.cellStartLocation - (1 - xAxis.renderer.cellEndLocation);
    if (series.dataItems.length > 1) {
        var x0 = xAxis.getX(series.dataItems.getIndex(0), "categoryX");
        var x1 = xAxis.getX(series.dataItems.getIndex(1), "categoryX");
        var delta = ((x1 - x0) / chartNotCommunicated.series.length) * w;
        if (am4core.isNumber(delta)) {
            var middle = chartNotCommunicated.series.length / 2;

            var newIndex = 0;
            chartNotCommunicated.series.each(function(series) {
                if (!series.isHidden && !series.isHiding) {
                    series.dummyData = newIndex;
                    newIndex++;
                }
                else {
                    series.dummyData = chartNotCommunicated.series.indexOf(series);
                }
            })
            var visibleCount = newIndex;
            var newMiddle = visibleCount / 2;

            chartNotCommunicated.series.each(function(series) {
                var trueIndex = chartNotCommunicated.series.indexOf(series);
                var newIndex = series.dummyData;

                var dx = (newIndex - trueIndex + middle - newMiddle) * delta

                series.animate({ property: "dx", to: dx }, series.interpolationDuration, series.interpolationEasing);
                series.bulletsContainer.animate({ property: "dx", to: dx }, series.interpolationDuration, series.interpolationEasing);
            })
        }
    }
}// Add simple vertical scrollbar
chartNotCommunicated.scrollbarY = new am4core.Scrollbar();
// Add horizotal scrollbar with preview
var scrollbarX = new am4charts.XYChartScrollbar();
scrollbarX.series.push(series);
chartNotCommunicated.scrollbarX = scrollbarX;
// Add cursor
chartNotCommunicated.cursor = new am4charts.XYCursor();
</script>
<!-- /Not Communicated Leads by Type -->
<!-- Follow Ups Leads by Type -->
<div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
<div class="kt-portlet kt-portlet--fit kt-portlet--head-lg kt-portlet--head-overlay kt-portlet--skin-solid kt-portlet--height-fluid">
<div class="kt-portlet__head kt-portlet__head--noborder kt-portlet__space-x">
<div class="kt-portlet__head-label">
<h3 class="kt-portlet__head-title kt-font-dark">
Follow Ups Leads by Type
</h3>
</div>
<div class="kt-portlet__head-toolbar">
</div>
</div>
<div class="kt-portlet__body kt-portlet__body--fit mt-0">
<div id="chartFollowUps" class="chartdiv"></div>
</div>
</div>
</div>
<script>
am4core.useTheme(am4themes_animated);
var chartFollowUps = am4core.create("chartFollowUps", am4charts.XYChart);chart.hiddenState.properties.opacity = 0; // this creates initial fade-in
chartFollowUps.colors.step = 2;

chartFollowUps.legend = new am4charts.Legend()
chartFollowUps.legend.position = 'top'
chartFollowUps.legend.paddingBottom = 20
chartFollowUps.legend.labels.template.maxWidth = 95

chartFollowUps.colors.list = [
  am4core.color("#845EC2"),
  am4core.color("#D65DB1"),
  am4core.color("#FF6F91"),
  am4core.color("#FF9671"),
  am4core.color("#FFC75F"),
  am4core.color("#F9F871")
];

var xAxis = chartFollowUps.xAxes.push(new am4charts.CategoryAxis())
xAxis.dataFields.category = 'category'
xAxis.renderer.cellStartLocation = 0.1
xAxis.renderer.cellEndLocation = 0.9
xAxis.renderer.grid.template.location = 0;

var yAxis = chartFollowUps.yAxes.push(new am4charts.ValueAxis());
yAxis.min = 0;

function createSeries(value, name) {
    var series = chartFollowUps.series.push(new am4charts.ColumnSeries())
    series.dataFields.valueY = value
    series.dataFields.categoryX = 'category'
    series.name = name
    series.tooltipText = "[bold]{valueY}[/]";

    series.events.on("hidden", arrangeColumns);
    series.events.on("shown", arrangeColumns);

    var bullet = series.bullets.push(new am4charts.LabelBullet())
    bullet.interactionsEnabled = false
    bullet.dy = 30;
    bullet.label.text = '{valueY}'
    bullet.label.fill = am4core.color('#ffffff')

    return series;
}

chartFollowUps.data = [
    <?php
    if(!empty($list)){
    foreach($list as  $item){ ?>           
    {
        category: '<?php echo $item['Agents']?>',
        first: <?php echo $item['Fresh Leads Follow Up']?>,
        second: <?php echo $item['Cold Leads Follow Up']?>,
        third: <?php echo $item['Indirect Leads Follow Up']?>
    },
    <?php } } ?>
]

var dataSource = chartFollowUps.createChild(am4core.TextLink)
dataSource.text = "Data source: Follow Ups Leads by Type";
dataSource.fontSize = 12;
dataSource.align = "left";
dataSource.valign = "top"
dataSource.url = "<?php echo Yii::app()->getBaseUrl(true) ?>/engineering/showdashboard?typedate=1&startdate=2000-01-01&enddate=2100-01-01&cold=2&type=&branch=&view=1977&yt0=Get+Report"
dataSource.urlTarget = "_blank";
dataSource.fill = am4core.color("#927459");
dataSource.padding(10,10,10,10);
dataSource.marginLeft = 30;
dataSource.marginTop = 30;
dataSource.background = new am4core.RoundedRectangle()
dataSource.background.cornerRadius(10,10,10,10);
dataSource.background.strokeOpacity = 0.3;
dataSource.background.stroke =am4core.color("#927459");
dataSource.background.fill = am4core.color("#f9e3ce");
dataSource.background.fillOpacity = 0.6;

createSeries('first', 'Fresh');
createSeries('second', 'Cold');
createSeries('third', 'Indirect');

function arrangeColumns() {

    var series = chartFollowUps.series.getIndex(0);

    var w = 1 - xAxis.renderer.cellStartLocation - (1 - xAxis.renderer.cellEndLocation);
    if (series.dataItems.length > 1) {
        var x0 = xAxis.getX(series.dataItems.getIndex(0), "categoryX");
        var x1 = xAxis.getX(series.dataItems.getIndex(1), "categoryX");
        var delta = ((x1 - x0) / chartFollowUps.series.length) * w;
        if (am4core.isNumber(delta)) {
            var middle = chartFollowUps.series.length / 2;

            var newIndex = 0;
            chartFollowUps.series.each(function(series) {
                if (!series.isHidden && !series.isHiding) {
                    series.dummyData = newIndex;
                    newIndex++;
                }
                else {
                    series.dummyData = chartFollowUps.series.indexOf(series);
                }
            })
            var visibleCount = newIndex;
            var newMiddle = visibleCount / 2;

            chartFollowUps.series.each(function(series) {
                var trueIndex = chartFollowUps.series.indexOf(series);
                var newIndex = series.dummyData;

                var dx = (newIndex - trueIndex + middle - newMiddle) * delta

                series.animate({ property: "dx", to: dx }, series.interpolationDuration, series.interpolationEasing);
                series.bulletsContainer.animate({ property: "dx", to: dx }, series.interpolationDuration, series.interpolationEasing);
            })
        }
    }
}// Add simple vertical scrollbar
chartFollowUps.scrollbarY = new am4core.Scrollbar();
// Add horizotal scrollbar with preview
var scrollbarX = new am4charts.XYChartScrollbar();
scrollbarX.series.push(series);
chartFollowUps.scrollbarX = scrollbarX;
// Add cursor
chartFollowUps.cursor = new am4charts.XYCursor();
</script>
<!-- /Follow Ups Leads by Type -->
<!-- Delay Leads by Type -->
<div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
<div class="kt-portlet kt-portlet--fit kt-portlet--head-lg kt-portlet--head-overlay kt-portlet--skin-solid kt-portlet--height-fluid">
<div class="kt-portlet__head kt-portlet__head--noborder kt-portlet__space-x">
<div class="kt-portlet__head-label">
<h3 class="kt-portlet__head-title kt-font-dark">
Delay Leads by Type
</h3>
</div>
<div class="kt-portlet__head-toolbar">
</div>
</div>
<div class="kt-portlet__body kt-portlet__body--fit mt-0">
<div id="chartDelay" class="chartdiv"></div>
</div>
</div>
</div>
<script>
am4core.useTheme(am4themes_animated);
var chartDelay = am4core.create("chartDelay", am4charts.XYChart);chart.hiddenState.properties.opacity = 0; // this creates initial fade-in
chartDelay.colors.step = 2;

chartDelay.legend = new am4charts.Legend()
chartDelay.legend.position = 'top'
chartDelay.legend.paddingBottom = 20
chartDelay.legend.labels.template.maxWidth = 95

chartDelay.colors.list = [
  am4core.color("#845EC2"),
  am4core.color("#D65DB1"),
  am4core.color("#FF6F91"),
  am4core.color("#FF9671"),
  am4core.color("#FFC75F"),
  am4core.color("#F9F871")
];

var xAxis = chartDelay.xAxes.push(new am4charts.CategoryAxis())
xAxis.dataFields.category = 'category'
xAxis.renderer.cellStartLocation = 0.1
xAxis.renderer.cellEndLocation = 0.9
xAxis.renderer.grid.template.location = 0;

var yAxis = chartDelay.yAxes.push(new am4charts.ValueAxis());
yAxis.min = 0;

function createSeries(value, name) {
    var series = chartDelay.series.push(new am4charts.ColumnSeries())
    series.dataFields.valueY = value
    series.dataFields.categoryX = 'category'
    series.name = name
    series.tooltipText = "[bold]{valueY}[/]";

    series.events.on("hidden", arrangeColumns);
    series.events.on("shown", arrangeColumns);

    var bullet = series.bullets.push(new am4charts.LabelBullet())
    bullet.interactionsEnabled = false
    bullet.dy = 30;
    bullet.label.text = '{valueY}'
    bullet.label.fill = am4core.color('#ffffff')

    return series;
}

chartDelay.data = [
    <?php
    if(!empty($list)){
    foreach($list as  $item){ ?>           
    {
        category: '<?php echo $item['Agents']?>',
        first: <?php echo $item['Fresh Leads Delay']?>,
        second: <?php echo $item['Cold Leads Delay']?>,
        third: <?php echo $item['Indirect Leads Delay']?>
    },
    <?php } } ?>
]

var dataSource = chartDelay.createChild(am4core.TextLink)
dataSource.text = "Data source: Delay Leads by Type";
dataSource.fontSize = 12;
dataSource.align = "left";
dataSource.valign = "top"
dataSource.url = "<?php echo Yii::app()->getBaseUrl(true) ?>/engineering/showdashboard?typedate=1&startdate=2000-01-01&enddate=2100-01-01&cold=2&type=&branch=&view=1978&yt0=Get+Report"
dataSource.urlTarget = "_blank";
dataSource.fill = am4core.color("#927459");
dataSource.padding(10,10,10,10);
dataSource.marginLeft = 30;
dataSource.marginTop = 30;
dataSource.background = new am4core.RoundedRectangle()
dataSource.background.cornerRadius(10,10,10,10);
dataSource.background.strokeOpacity = 0.3;
dataSource.background.stroke =am4core.color("#927459");
dataSource.background.fill = am4core.color("#f9e3ce");
dataSource.background.fillOpacity = 0.6;

createSeries('first', 'Fresh');
createSeries('second', 'Cold');
createSeries('third', 'Indirect');

function arrangeColumns() {

    var series = chartDelay.series.getIndex(0);

    var w = 1 - xAxis.renderer.cellStartLocation - (1 - xAxis.renderer.cellEndLocation);
    if (series.dataItems.length > 1) {
        var x0 = xAxis.getX(series.dataItems.getIndex(0), "categoryX");
        var x1 = xAxis.getX(series.dataItems.getIndex(1), "categoryX");
        var delta = ((x1 - x0) / chartDelay.series.length) * w;
        if (am4core.isNumber(delta)) {
            var middle = chartDelay.series.length / 2;

            var newIndex = 0;
            chartDelay.series.each(function(series) {
                if (!series.isHidden && !series.isHiding) {
                    series.dummyData = newIndex;
                    newIndex++;
                }
                else {
                    series.dummyData = chartDelay.series.indexOf(series);
                }
            })
            var visibleCount = newIndex;
            var newMiddle = visibleCount / 2;

            chartDelay.series.each(function(series) {
                var trueIndex = chartDelay.series.indexOf(series);
                var newIndex = series.dummyData;

                var dx = (newIndex - trueIndex + middle - newMiddle) * delta

                series.animate({ property: "dx", to: dx }, series.interpolationDuration, series.interpolationEasing);
                series.bulletsContainer.animate({ property: "dx", to: dx }, series.interpolationDuration, series.interpolationEasing);
            })
        }
    }
}// Add simple vertical scrollbar
chartDelay.scrollbarY = new am4core.Scrollbar();
// Add horizotal scrollbar with preview
var scrollbarX = new am4charts.XYChartScrollbar();
scrollbarX.series.push(series);
chartDelay.scrollbarX = scrollbarX;
// Add cursor
chartDelay.cursor = new am4charts.XYCursor();
</script>
<!-- /Delay Leads by Type -->
<!-- Rotation Leads by Type -->
<div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
<div class="kt-portlet kt-portlet--fit kt-portlet--head-lg kt-portlet--head-overlay kt-portlet--skin-solid kt-portlet--height-fluid">
<div class="kt-portlet__head kt-portlet__head--noborder kt-portlet__space-x">
<div class="kt-portlet__head-label">
<h3 class="kt-portlet__head-title kt-font-dark">
Rotation Leads by Type
</h3>
</div>
<div class="kt-portlet__head-toolbar">
</div>
</div>
<div class="kt-portlet__body kt-portlet__body--fit mt-0">
<div id="chartRotation" class="chartdiv"></div>
</div>
</div>
</div>
<script>
am4core.useTheme(am4themes_animated);
var chartRotation = am4core.create("chartRotation", am4charts.XYChart);chart.hiddenState.properties.opacity = 0; // this creates initial fade-in
chartRotation.colors.step = 2;

chartRotation.legend = new am4charts.Legend()
chartRotation.legend.position = 'top'
chartRotation.legend.paddingBottom = 20
chartRotation.legend.labels.template.maxWidth = 95

chartRotation.colors.list = [
  am4core.color("#845EC2"),
  am4core.color("#D65DB1"),
  am4core.color("#FF6F91"),
  am4core.color("#FF9671"),
  am4core.color("#FFC75F"),
  am4core.color("#F9F871")
];

var xAxis = chartRotation.xAxes.push(new am4charts.CategoryAxis())
xAxis.dataFields.category = 'category'
xAxis.renderer.cellStartLocation = 0.1
xAxis.renderer.cellEndLocation = 0.9
xAxis.renderer.grid.template.location = 0;

var yAxis = chartRotation.yAxes.push(new am4charts.ValueAxis());
yAxis.min = 0;

function createSeries(value, name) {
    var series = chartRotation.series.push(new am4charts.ColumnSeries())
    series.dataFields.valueY = value
    series.dataFields.categoryX = 'category'
    series.name = name
    series.tooltipText = "[bold]{valueY}[/]";

    series.events.on("hidden", arrangeColumns);
    series.events.on("shown", arrangeColumns);

    var bullet = series.bullets.push(new am4charts.LabelBullet())
    bullet.interactionsEnabled = false
    bullet.dy = 30;
    bullet.label.text = '{valueY}'
    bullet.label.fill = am4core.color('#ffffff')

    return series;
}

chartRotation.data = [
    <?php
    if(!empty($list)){
    foreach($list as  $item){ ?>           
    {
        category: '<?php echo $item['Agents']?>',
        first: <?php echo $item['Fresh Leads Rotation']?>,
        second: <?php echo $item['Cold Leads Rotation']?>,
        third: <?php echo $item['Indirect Leads Rotation']?>
    },
    <?php } } ?>
]

var dataSource = chartRotation.createChild(am4core.TextLink)
dataSource.text = "Data source: Rotation Leads by Type";
dataSource.fontSize = 12;
dataSource.align = "left";
dataSource.valign = "top"
dataSource.url = "<?php echo Yii::app()->getBaseUrl(true) ?>/engineering/showdashboard?typedate=1&startdate=2000-01-01&enddate=2100-01-01&cold=2&type=&branch=&view=1979&yt0=Get+Report"
dataSource.urlTarget = "_blank";
dataSource.fill = am4core.color("#927459");
dataSource.padding(10,10,10,10);
dataSource.marginLeft = 30;
dataSource.marginTop = 30;
dataSource.background = new am4core.RoundedRectangle()
dataSource.background.cornerRadius(10,10,10,10);
dataSource.background.strokeOpacity = 0.3;
dataSource.background.stroke =am4core.color("#927459");
dataSource.background.fill = am4core.color("#f9e3ce");
dataSource.background.fillOpacity = 0.6;

createSeries('first', 'Fresh');
createSeries('second', 'Cold');
createSeries('third', 'Indirect');

function arrangeColumns() {

    var series = chartRotation.series.getIndex(0);

    var w = 1 - xAxis.renderer.cellStartLocation - (1 - xAxis.renderer.cellEndLocation);
    if (series.dataItems.length > 1) {
        var x0 = xAxis.getX(series.dataItems.getIndex(0), "categoryX");
        var x1 = xAxis.getX(series.dataItems.getIndex(1), "categoryX");
        var delta = ((x1 - x0) / chartRotation.series.length) * w;
        if (am4core.isNumber(delta)) {
            var middle = chartRotation.series.length / 2;

            var newIndex = 0;
            chartRotation.series.each(function(series) {
                if (!series.isHidden && !series.isHiding) {
                    series.dummyData = newIndex;
                    newIndex++;
                }
                else {
                    series.dummyData = chartRotation.series.indexOf(series);
                }
            })
            var visibleCount = newIndex;
            var newMiddle = visibleCount / 2;

            chartRotation.series.each(function(series) {
                var trueIndex = chartRotation.series.indexOf(series);
                var newIndex = series.dummyData;

                var dx = (newIndex - trueIndex + middle - newMiddle) * delta

                series.animate({ property: "dx", to: dx }, series.interpolationDuration, series.interpolationEasing);
                series.bulletsContainer.animate({ property: "dx", to: dx }, series.interpolationDuration, series.interpolationEasing);
            })
        }
    }
}// Add simple vertical scrollbar
chartRotation.scrollbarY = new am4core.Scrollbar();
// Add horizotal scrollbar with preview
var scrollbarX = new am4charts.XYChartScrollbar();
scrollbarX.series.push(series);
chartRotation.scrollbarX = scrollbarX;
// Add cursor
chartRotation.cursor = new am4charts.XYCursor();
</script>
<!-- /Rotation Leads by Type -->
</div>