<?php
// Include the QR Code library
require_once(Yii::getPathOfAlias('application.extensions.phpqrcode.qrlib') . '.php');

// Fetch data for Lead ID = 1000
$criteria = new CDbCriteria();
$criteria->select = 'title, id, user_sales, project_id, details';
$criteria->condition = 'id = :id';
$criteria->params = [':id' => 78608];
$lead = Leads::model()->find($criteria);

if ($lead) {
    // Fetch the project title based on project_id
    $projectTitle = null;
    if ($lead->project_id) {
        $project = Yii::app()->db->createCommand()
            ->select('title')
            ->from('projects')
            ->where('id = :id', [':id' => $lead->project_id])
            ->queryRow();
        $projectTitle = $project['title'] ?? 'No Project Title';
    }

    // Fetch the user full name based on user_sales
    $userFullName = null;
    if ($lead->user_sales) {
        $user = Yii::app()->db->createCommand()
            ->select('fname, lname')
            ->from('user')
            ->where('id = :id', [':id' => $lead->user_sales])
            ->queryRow();
        $userFullName = $user ? $user['fname'] . ' ' . $user['lname'] : 'No User Found';
    }

    // Base URL for the lead profile
    $leadProfileUrl = Yii::app()->getBaseUrl(true) . '/leads/profile/' . $lead->id;

    // Generate the QR code directly into a string
    ob_start();
    QRcode::png($leadProfileUrl, null, QR_ECLEVEL_L, 4);
    $imageData = ob_get_contents();
    ob_end_clean();

    // Encode the image data as Base64
    $base64Image = base64_encode($imageData);

    // Display the lead details and the QR code
    echo "<h1 style='text-align: center; margin-bottom: 20px;'>Lead Details and QR Code</h1>";
    echo "<div style='text-align: center; margin-bottom: 20px;'>";
    echo "<img src='data:image/png;base64," . $base64Image . "' alt='QR Code'>";
    echo "<p>Scan this code to visit: <a href='" . $leadProfileUrl . "'>" . CHtml::encode($leadProfileUrl) . "</a></p>";
    echo "</div>";

    // Display all the details of the lead
    echo "<table border='1' style='margin: 0 auto; border-collapse: collapse;'>";
    echo "<tr><th>Field</th><th>Value</th></tr>";
    echo "<tr><td>Title</td><td>" . CHtml::encode($lead->title) . "</td></tr>";
    echo "<tr><td>ID</td><td>" . CHtml::encode($lead->id) . "</td></tr>";
    echo "<tr><td>User Sales</td><td>" . CHtml::encode($userFullName) . "</td></tr>";
    echo "<tr><td>Project Title</td><td>" . CHtml::encode($projectTitle) . "</td></tr>";
    echo "<tr><td>Details</td><td>" . CHtml::encode($lead->details) . "</td></tr>";
    echo "</table>";
} else {
    echo "<p>No lead found with ID = 1000.</p>";
}
?>
