<?php
// Register necessary scripts and meta tags
Yii::app()->clientScript->registerMetaTag(Yii::app()->request->csrfToken, 'csrf-token');
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/megabox/vendors/general/jquery/dist/jquery.js');
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/js/jquery.ba-bbq.js');
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/js/jquery.yiigridview.js');
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/megabox/vendors/general/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js');

// Add custom JS for filtering and datepicker
Yii::app()->clientScript->registerScript('search', "
var \$j = jQuery.noConflict();

function debounce(fn, delay) {
    let timer = null;
    return function () {
        const context = this, args = arguments;
        clearTimeout(timer);
        timer = setTimeout(() => fn.apply(context, args), delay);
    };
}

\$j(function() {
    // Initialize the datepicker for the filters
    \$j('.datepicker').datepicker({
        format: 'yyyy-mm-dd', // Adjust format to match your database date format
        autoclose: true,
        todayHighlight: true
    });

    // Apply filters with debounce
    \$j('#filter-id, #filter-date, #filter-title, #filter-tel, #filter-lead_id, #filter-user_id, #filter-building, #filter-from-date, #filter-to-date').on('keyup change', debounce(function() {
        \$j('#loading-spinner').show(); // Show the spinner

        \$j.fn.yiiGridView.update('eoi-grid', {
            type: 'POST',
            data: {
                'YII_CSRF_TOKEN': \$j('meta[name=csrf-token]').attr('content'), // Add CSRF token for security
                'Eoiform[id]': \$j('#filter-id').val(),
                'Eoiform[date]': \$j('#filter-date').val(),
                'Eoiform[title]': \$j('#filter-title').val(),
                'Eoiform[tel]': \$j('#filter-tel').val(),
                'Eoiform[lead_id]': \$j('#filter-lead_id').val(),
                'Eoiform[user_id]': \$j('#filter-user_id').val(),
                'Eoiform[building]': \$j('#filter-building').val(),
                'Eoiform[from_date]': \$j('#filter-from-date').val(),
                'Eoiform[to_date]': \$j('#filter-to-date').val()
            },
            complete: function() {
                console.log('Filter applied successfully');
                \$j('#loading-spinner').hide(); // Hide the spinner
            },
            error: function(xhr, status, error) {
                console.error('Error applying filter:', error);
                \$j('#loading-spinner').hide(); // Hide the spinner
            }
        });
    }, 300));
});
");
?>
	<script type="text/javascript" src="<?php echo Yii::app()->getBaseUrl(true) ?>/megabox/js/demo6/pages/custom/xlsx.full.min.js"> </script>
	<script type="text/javascript">
function ExportExcel1(type, fn, dl) {
    // Locate the table inside the GridView
    var elt = document.querySelector('#eoi-grid table'); // Ensures we get the table element

    if (!elt) {
        console.error('Table element not found!');
        alert('Table not found. Please ensure the table is visible on the page.');
        return;
    }

    // Loop through table headers to escape date-like values
    var headers = elt.getElementsByTagName("th");
    for (var i = 0; i < headers.length; i++) {
        if (/(\d{1,2}\/\d{1,2}\/\d{4})/.test(headers[i].innerText)) {
            headers[i].innerText = "'" + headers[i].innerText; // Prepend apostrophe
        }
    }

    var wb = XLSX.utils.table_to_book(elt, { sheet: "Sheet JS" });
    return dl
        ? XLSX.write(wb, { bookType: type, bookSST: true, type: 'base64' })
        : XLSX.writeFile(wb, fn || ('SheetJSTableExport.' + (type || 'xlsx')));
}


	</script>
<div class="kt-portlet">
        <div class="kt-portlet__head">
            <div class="kt-portlet__head-label">
                <h3 class="kt-portlet__head-title">
                    EOI Search
                </h3>
            </div>
        </div>
        <div class="kt-portlet__body">
            <!-- Solid Form -->
            <div class="kt-portlet__body kt-portlet__body--fit">
<div class="filters row">
    <div class="col-md-4 mb-1 mt-1">
        <label>EOI Code:</label>
        <?php echo CHtml::textField('Eoiform[id]', $model->id, array('id' => 'filter-id')); ?>
    </div>
    <div class="col-md-4 mb-1 mt-1">
        <label>From Date:</label>
        <?php echo CHtml::textField('Eoiform[from_date]', '', array('id' => 'filter-from-date', 'class' => 'datepicker')); ?>
    </div>
    <div class="col-md-4 mb-1 mt-1">
        <label>To Date:</label>
        <?php echo CHtml::textField('Eoiform[to_date]', '', array('id' => 'filter-to-date', 'class' => 'datepicker')); ?>
    </div>
    <div class="col-md-4 mb-1 mt-1">
        <label>Name:</label>
        <?php echo CHtml::textField('Eoiform[title]', $model->title, array('id' => 'filter-title')); ?>
    </div>
    <div class="col-md-4 mb-1 mt-1">
        <label>1st Telephone:</label>
        <?php echo CHtml::textField('Eoiform[tel]', $model->tel, array('id' => 'filter-tel')); ?>
    </div>
    <div class="col-md-4 mb-1 mt-1">
        <label>Lead ID:</label>
        <?php echo CHtml::textField('Eoiform[lead_id]', $model->lead_id, array('id' => 'filter-lead_id')); ?>
    </div>
    <div class="col-md-4 mb-1 mt-1">
        <label>EOI Created By:</label>
        <?php echo CHtml::textField('Eoiform[user_id]', $model->user_id, array('id' => 'filter-user_id')); ?>
    </div>
    <div class="col-md-4 mb-1 mt-1">
        <label>Project:</label>
        <?php echo CHtml::textField('Eoiform[building]', $model->building, array('id' => 'filter-building')); ?>
    </div>
</div>

</div>
</div>
</div>
<div id="loading-spinner" style="display:none;">
    Loading...
</div>
<div class="kt-portlet">
        <div class="kt-portlet__head">
            <div class="kt-portlet__head-label">
                <h3 class="kt-portlet__head-title">
                    EOIs
                </h3>
            </div>
				<div class="kt-portlet__head-toolbar">
					<div class="kt-widget__action mr-1">
						<button type="button" class="btn btn-bold btn-label-brand btn-sm"  onclick="ExportExcel1('xlsx')">Excel</button>
					</div>
				</div>
        </div>
        <div class="kt-portlet__body">
            <!-- Solid Form -->
            <div class="kt-portlet__body kt-portlet__body--fit">
<?php
Yii::log("DataProvider Item Count: " . $dataProvider->getTotalItemCount(), 'info');
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'eoi-grid',
    'dataProvider' => $dataProvider,
    'filter' => null,
    'ajaxUpdate' => true,
    'enableHistory' => true,
    'enablePagination' => true,
    'itemsCssClass' => 'responsive dataTable responsive dataTable table table-striped table-bordered table-condensed',
    'emptyText' => 'No matching EOIs found, please adjust your search criteria.',
    'summaryText' => 'Showing {start} to {end} of {count} entries',
    'pager' => [
        'class' => 'CLinkPager',
        'maxButtonCount' => 5,
        'nextPageLabel' => 'Next',
        'prevPageLabel' => 'Prev',
        'firstPageLabel' => 'First',
        'lastPageLabel' => 'Last',
    ],
    'columns' => array(
        'id',
        'date',
        'title',
        'tel',
        array(
            'name' => 'lead_id',
            'value' => '$data->leads->title', // Replace 'title' with the actual attribute in the Leads model
        ),
        array(
            'name' => 'user_id',
            'value' => '$data->user->username', // Replace 'username' with the actual attribute in the User model
        ),
        array(
            'name' => 'building',
            'value' => '$data->building->name', // Replace 'name' with the actual attribute in the Building model
        ),
    ),
));
?>

</div>
</div>
</div>