<?php
$today = date("Y-m-d");
$start = date('Y-m-01');  // Start of the month
$end = date('Y-m-t');    // End of the month
$currentUserId = Yii::app()->user->id;

// Fetch user information
$userInfo = Yii::app()->db->createCommand()
    ->select('*')
    ->from('user')
    ->where('id=:userId', array(':userId' => $currentUserId))
    ->queryRow();

$limitsCondition = '';
$params = array(':startDate' => $start, ':endDate' => $end);
if (!empty($userInfo['limitsformanager'])) {
    $limitsArray = is_string($userInfo['limitsformanager']) ? explode(',', $userInfo['limitsformanager']) : $userInfo['limitsformanager'];
    $limitsCondition = 'user_sales IN (' . implode(',', array_map('intval', $limitsArray)) . ') OR user_sales = :userId';
    $params[':userId'] = $currentUserId;
}

// Query to count leads for the whole month with additional condition
$sql = "SELECT COUNT(*) as id FROM leads WHERE `date` BETWEEN :startDate AND :endDate AND `user_sales` IS NOT NULL AND `coldcall` IS NULL";
if ($limitsCondition) {
   $sql .= " AND ($limitsCondition)";
}

$command = Yii::app()->db->createCommand($sql);
$command->bindValues($params);
$results = $command->queryAll();
$allleads = (int)$results[0]["id"];

// Query to count leads for today where `user_sales` is not NULL, `coldcall` is NULL, and `unseenauto` is NULL
$sqlToday = "SELECT COUNT(*) as id FROM leads WHERE `date` = :today AND `user_sales` IS NOT NULL AND `coldcall` IS NULL AND `unseenauto` IS NULL";
if ($limitsCondition) {
   $sqlToday .= " AND ($limitsCondition)";
}

$commandToday = Yii::app()->db->createCommand($sqlToday);
$paramsToday = array(':today' => $today);
if (!empty($userInfo['limitsformanager'])) {
    $paramsToday[':userId'] = $currentUserId;
}
$commandToday->bindValues($paramsToday);
$resultsToday = $commandToday->queryAll();
$allleadstoday = (int)$resultsToday[0]["id"];
?>

<?php if ($allleads !== false && $allleadstoday !== false) { ?>
    <a href="<?php echo Yii::app()->getBaseUrl(true) ?>/en/sales/searchsales?search=&fresh%5B%5D=&indirect=2&cold=2&fb_id=&adsetname=&adname=&internationalcode=&tel=&secondtel=&startdate=<?php echo $today; ?>&enddate=<?php echo $today; ?>&campaign%5B%5D=&usersales%5B%5D=&platform%5B%5D=&status=&substatus=&place%5B%5D=&callcenter%5B%5D=&branch%5B%5D=&yt0=Search" target="_blank" class="kt-widget17__item"><?php echo $allleadstoday; ?></a> /
    <a href="<?php echo Yii::app()->getBaseUrl(true) ?>/en/sales/searchsales?search=&fresh%5B%5D=&indirect=2&cold=2&fb_id=&adsetname=&adname=&internationalcode=&tel=&secondtel=&startdate=<?php echo $start; ?>&enddate=<?php echo $end; ?>&campaign%5B%5D=&usersales%5B%5D=&platform%5B%5D=&status=&substatus=&place%5B%5D=&callcenter%5B%5D=&branch%5B%5D=&yt0=Search" target="_blank" class="kt-widget17__item"><?php echo $allleads; ?></a>
<?php } else { ?>
    <!-- Error handling: Display an error message when there is an issue with the queries -->
    Error: Unable to fetch data
<?php } ?>
