<?php if(Yii::app()->user->hasFlash('success')): ?>
<div class="alert alert-success alert-dismissible fade show mt-3" role="alert">
    <?php echo Yii::app()->user->getFlash('success'); ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
<?php endif; ?>

<div class="container mt-4">
    <div class="card shadow-sm rounded-4">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0">Main Settings Configuration</h4>
        </div>
        <div class="card-body">
            <?php $form = $this->beginWidget('CActiveForm', array(
                'id'=>'mainsettings-form',
                'enableAjaxValidation'=>false,
                'htmlOptions' => array('class' => 'needs-validation', 'novalidate' => 'novalidate'),
            )); ?>

            <div class="row">
                <?php
                foreach ($model->attributes as $field => $value) {
                    // Skip file upload fields
                    if (in_array($field, ['headerphoto', 'footerphoto', 'logo', 'logo_colored'])) {
                        continue;
                    }

                    echo '<div class="col-md-6 mb-3">';
                    echo '<label class="form-label">' . CHtml::encode($model->getAttributeLabel($field)) . '</label>';

                    if (stripos($field, 'clause') !== false || $model->getTableSchema()->columns[$field]->dbType === 'text') {
                        echo CHtml::activeTextArea($model, $field, array('class' => 'form-control', 'rows'=>4));
                    } else {
                        echo CHtml::activeTextField($model, $field, array('class' => 'form-control'));
                    }

                    echo CHtml::error($model, $field, ['class' => 'text-danger small']);
                    echo '</div>';
                }
                ?>
            </div>

            <div class="text-center mt-4">
                <?php echo CHtml::submitButton('Save Settings', ['class' => 'btn btn-success px-5']); ?>
            </div>

            <?php $this->endWidget(); ?>
        </div>
    </div>
</div>

<!-- Optional JS enhancements -->
<script>
    (function () {
        'use strict'
        var forms = document.querySelectorAll('.needs-validation')
        Array.prototype.slice.call(forms)
            .forEach(function (form) {
                form.addEventListener('submit', function (event) {
                    if (!form.checkValidity()) {
                        event.preventDefault()
                        event.stopPropagation()
                    }
                    form.classList.add('was-validated')
                }, false)
            })
    })()
</script>