<?php
$criteriaex = new CDbCriteria();
$criteriaex->addSearchCondition('paymentmethod_id', $_REQUEST['payment'], false);
$allyears = Paymentmethodyears::model()->findAll($criteriaex); 
if (!empty($allyears)) { ?>
    <?php
    // Define data
    $payment = $_REQUEST['payment']; // Total unit cost
    $startDateString = $_REQUEST['startdate']; // Assuming sanitized before use
    $downpaymentDateString = $_REQUEST['downpaymentdate']; // Assuming sanitized before use
    $paymentdetails = Paymentmethod::model()->findByPk($payment);
    $totalUnitCost = $_REQUEST['unit']; // Total unit cost
    $totalclubhousecost = $_REQUEST['clubhouse']; // Total unit cost
    $totalparkingcost = $_REQUEST['parking']; // Total unit cost
    $totalmaintenancetcost = $_REQUEST['maintenance']; // Total unit cost
    $downPaymentPercentage = floatval($paymentdetails->downpayment) / 100; // تحويل إلى نسبة عشرية
    $discountPercentage = floatval($paymentdetails->discount) / 100; // تحويل إلى نسبة عشرية
    $installmentYears = $paymentdetails->noofyears; // Installment duration in years
    $startDateString = $_REQUEST['startdate']; // Start date
    $everymonth = $paymentdetails->installmenttype; // Installment frequency in months
    // Convert start date string to DateTime object
    $startDate = new DateTime($startDateString);
    // Calculate loan amount
    $loanAmount = $totalUnitCost - $downPayment;
    // Calculate discount
    $discount = $totalUnitCost * $discountPercentage;
    // Calculate discounted loan amount
    $discountedLoanAmount = $loanAmount - $discount;
    // Calculate down payment
    $downPayment = $discountedLoanAmount * $downPaymentPercentage;
    // PHP function for converting numbers to English words
    function convertNumberToWords($number)
    {
    $hyphen = '-';
    $conjunction = ' and ';
    $separator = ', ';
    $negative = 'negative ';
    $decimal = ' point ';
    $dictionary = array(
    0 => 'zero',
    1 => 'one',
    2 => 'two',
    3 => 'three',
    4 => 'four',
    5 => 'five',
    6 => 'six',
    7 => 'seven',
    8 => 'eight',
    9 => 'nine',
    10 => 'ten',
    11 => 'eleven',
    12 => 'twelve',
    13 => 'thirteen',
    14 => 'fourteen',
    15 => 'fifteen',
    16 => 'sixteen',
    17 => 'seventeen',
    18 => 'eighteen',
    19 => 'nineteen',
    20 => 'twenty',
    30 => 'thirty',
    40 => 'forty',
    50 => 'fifty',
    60 => 'sixty',
    70 => 'seventy',
    80 => 'eighty',
    90 => 'ninety',
    100 => 'hundred',
    1000 => 'thousand',
    1000000 => 'million',
    1000000000 => 'billion',
    1000000000000 => 'trillion',
    1000000000000000 => 'quadrillion',
    1000000000000000000 => 'quintillion'
    );
    if (!is_numeric($number)) {
    return false;
    }
    if ($number < 0) {
    return $negative . convertNumberToWords(abs($number));
    }
    $string = $fraction = null;
    if (strpos($number, '.') !== false) {
    list($number, $fraction) = explode('.', $number);
    }
    switch (true) {
    case $number < 21:
    $string = $dictionary[$number];
    break;
    case $number < 100:
    $tens = ((int) ($number / 10)) * 10;
    $units = $number % 10;
    $string = $dictionary[$tens];
    if ($units) {
    $string .= $hyphen . $dictionary[$units];
    }
    break;
    case $number < 1000:
    $hundreds = (int) ($number / 100);
    $remainder = $number % 100;
    $string = $dictionary[$hundreds] . ' ' . $dictionary[100];
    if ($remainder) {
    $string .= $conjunction . convertNumberToWords($remainder);
    }
    break;
    default:
    foreach (array_reverse($dictionary, true) as $value => $word) {
    if ($number >= $value) {
    $number = (int) ($number / $value);
    $remainder = $number % $value;
    $string = $word;
    if ($remainder) {
    $string .= $conjunction . convertNumberToWords($remainder);
    }
    break;
    }
    }
    }
    if ($fraction) {
    $string .= $decimal;
    foreach (str_split((string) $fraction) as $digit) {
    $string .= $dictionary[$digit] . ' ';
    }
    }
    return $string;
    }
    // PHP function for converting numbers to Arabic words
function convertNumberToArabicWords($number)
{
    $negative = 'سالب ';
    $decimal = ' و ';
    $ones = ['صفر', 'واحد', 'اثنان', 'ثلاثة', 'أربعة', 'خمسة', 'ستة', 'سبعة', 'ثمانية', 'تسعة'];
    $teens = ['عشرة', 'أحد عشر', 'اثنا عشر', 'ثلاثة عشر', 'أربعة عشر', 'خمسة عشر', 'ستة عشر', 'سبعة عشر', 'ثمانية عشر', 'تسعة عشر'];
    $tens = ['', '', 'عشرون', 'ثلاثون', 'أربعون', 'خمسون', 'ستون', 'سبعون', 'ثمانون', 'تسعون'];
    $hundreds = ['', 'مائة', 'مائتان', 'ثلاثمائة', 'أربعمائة', 'خمسمائة', 'ستمائة', 'سبعمائة', 'ثمانمائة', 'تسعمائة'];
    $thousands = ['ألف', 'ألفان', 'آلاف'];
    $millions = ['مليون', 'مليونان', 'ملايين'];

    if (!is_numeric($number)) {
        return false;
    }

    if ($number < 0) {
        return $negative . convertNumberToArabicWords(abs($number));
    }

    $integerPart = (int)$number;
    $fractionPart = null;

    // التعامل مع الجزء العشري
    if (strpos((string)$number, '.') !== false) {
        list($integerPart, $fraction) = explode('.', (string)$number);
        $fraction = str_pad($fraction, 2, '0'); // تأمين جزئين عشريين على الأقل
        $fractionPart = (int)$fraction;
    }

    $integerString = convertIntegerToArabicWords((int)$integerPart);

    // إضافة كلمة "جنيهاً" بعد الجزء الصحيح فقط
    $result = $integerString . ' جنيهاً';

    // تحويل الجزء العشري إذا كان موجودًا
    if ($fractionPart) {
        $fractionString = convertIntegerToArabicWords($fractionPart);
        $result .= $decimal . $fractionString . ' قرشاً';
    }

    return $result;
}

function convertIntegerToArabicWords($number)
{
    $ones = ['صفر', 'واحد', 'اثنان', 'ثلاثة', 'أربعة', 'خمسة', 'ستة', 'سبعة', 'ثمانية', 'تسعة'];
    $teens = ['عشرة', 'أحد عشر', 'اثنا عشر', 'ثلاثة عشر', 'أربعة عشر', 'خمسة عشر', 'ستة عشر', 'سبعة عشر', 'ثمانية عشر', 'تسعة عشر'];
    $tens = ['', '', 'عشرون', 'ثلاثون', 'أربعون', 'خمسون', 'ستون', 'سبعون', 'ثمانون', 'تسعون'];
    $hundreds = ['', 'مائة', 'مائتان', 'ثلاثمائة', 'أربعمائة', 'خمسمائة', 'ستمائة', 'سبعمائة', 'ثمانمائة', 'تسعمائة'];
    $thousands = ['ألف', 'ألفان', 'آلاف'];
    $millions = ['مليون', 'مليونان', 'ملايين'];

    if ($number < 10) {
        return $ones[$number];
    } elseif ($number < 20) {
        return $teens[$number - 10];
    } elseif ($number < 100) {
        $tens_index = (int)($number / 10);
        $units = $number % 10;
        return $units ? $ones[$units] . ' و ' . $tens[$tens_index] : $tens[$tens_index];
    } elseif ($number < 1000) {
        $hundreds_index = (int)($number / 100);
        $remainder = $number % 100;
        return $hundreds[$hundreds_index] . ($remainder ? ' و ' . convertIntegerToArabicWords($remainder) : '');
    } elseif ($number < 1000000) {
        $thousands_part = (int)($number / 1000);
        $remainder = $number % 1000;
        return convertIntegerToArabicWords($thousands_part) . ' ' . ($thousands_part == 1 ? $thousands[0] : ($thousands_part == 2 ? $thousands[1] : $thousands[2])) . ($remainder ? ' و ' . convertIntegerToArabicWords($remainder) : '');
    } elseif ($number < 1000000000) {
        $millions_part = (int)($number / 1000000);
        $remainder = $number % 1000000;
        return convertIntegerToArabicWords($millions_part) . ' ' . ($millions_part == 1 ? $millions[0] : ($millions_part == 2 ? $millions[1] : $millions[2])) . ($remainder ? ' و ' . convertIntegerToArabicWords($remainder) : '');
    }

    return '';
}


    ?>
    <style>
        .selectedpaymentplan table {
        border-collapse: collapse;
        width: 100%;
        }
        .selectedpaymentplan th, .selectedpaymentplan td {
        border: 1px solid #dddddd;
        text-align: left;
        padding: 8px;
        color: #333;
        }
        .selectedpaymentplan th {
        background-color: #f2f2f2;
        }
        .selectedpaymentplan p {
        border: 1px solid #efefef;
        padding: 10px;
        margin: 0;
        color: #333;
        font-weight: 600;
        }
        @media print {
        .print-hide {
        display: none;
        }
        }
    </style>
    <?php $rowNumber = 1; $main=Mainsettings::model()->findByPk(1); ?>
    <div class="selectedpaymentplan">
        <button type="button" class="print-hide btn btn-success print-hide" onclick="downloadExcel('arabic')" style="height: 25px;line-height: 9px;margin-left: 20px;float: right;">Download as Excel in Arabic</button>
        <button type="button" class="print-hide btn btn-primary print-hide" onclick="printArabic()" style="height: 25px;line-height: 9px;margin-left: 10px;float: right;">Print in Arabic</button>
        <label class="kt-font-dark col-md-12">Payment Plan</label>
        <table>
            <tr><td colspan='7'><b>Total Unit Cost:</b> <span class="solidmoney"><?php echo $totalUnitCost; ?></span></td></tr>
            <tr><td colspan='7'><b>Down Payment:</b> <span class="solidmoney" id="newdownpayment"><?php echo $downPayment; ?></span></td></tr>
            <tr><td colspan='7'><b>Amount before Discount:</b> <span class="solidmoney"><?php echo $loanAmount; ?></span></td></tr>
            <tr><td colspan='7'><b>Discount:</b> <span class="solidmoney"><?php echo $discount; ?></span></td></tr>
            <tr><td colspan='7'><b>Amount After Discount:</b> <span class="solidmoney" id="priceafterdiscount"><?php echo $discountedLoanAmount; ?></span></td></tr>
            <tr>
                <th>#</th>
                <th>Date</th>
                <th>Quarter</th>
                <th>Total</th>
                <th>Amount in Words</th>
                <th>Ratio</th>
    			<?php if ($main->hidechequeinfo==1) { ?>
                <th>Cheque Number</th>
                <th>Drawee Bank</th>
    			<?php } else { ?><?php } ?>
            </tr>
           <tbody>
    <tr>
        <td><?php echo $rowNumber++; ?></td>
        <td><?php echo $downpaymentDateString; ?></td>
        <td>DP</td>
        <td class="solidmoney"> <?php echo $downPayment; ?></td>
        <td><?php echo convertNumberToArabicWords(round($downPayment, 2)); ?></td>
        <td>
        <?php
        $ratio = $downPayment / $discountedLoanAmount;
        $percentage = $ratio * 100;
        echo round($percentage, 2);
        ?> %
        </td>
        <?php if ($main->hidechequeinfo==1) { ?>
        <td></td>
        <td></td>
        <?php } ?>
    </tr>
    <?php foreach ($allyears as $years) { ?>
    <?php
    $shareAmount = $discountedLoanAmount * $years->ratio;
    $adjustedAmount = $shareAmount / 100; ?>
    
    <?php
    if (!empty($years->countyear)) { ?>
    <?php $count = $years->countyear / $years->installmenttype;  ?>
    <?php }else{ ?>
    <?php $count = 12 / $years->installmenttype;  ?>
    <?php } ?>

   
    
    <?php 
    $amountinst = $adjustedAmount / $count;
    ?>
    <?php
    $startDate = new DateTime($startDateString);
    for ($i = 1; $i <= $count; $i++) {
        $sum = round($amountinst + $installmentAmountsplus[$i - 1], 2); // تقريب المجموع
    ?>
    <tr>
        <td><?php echo $rowNumber++; ?></td>
        <td><?php echo $startDate->format('Y-m-d'); ?></td>
        <td>Q</td>
        <td class="solidmoney"><?php echo $sum; ?></td>
        <td><?php echo convertNumberToArabicWords($sum); ?></td>
        <td>
        <?php
        $ratio = $sum / $discountedLoanAmount;
        $percentage = $ratio * 100;
        echo round($percentage, 2);
        ?>%
        </td>
        <?php if ($main->hidechequeinfo==1) { ?>
        <td></td>
        <td></td>
        <?php } ?>
    </tr>
    <?php
        $startDate->modify('+' . $everymonth . ' months');
    }
    $startDateString = $startDate->format('Y-m-d'); // Update start date string
    ?>
    <?php } ?>
</tbody>

        </table>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.1/xlsx.full.min.js"></script>
        <script>
            function printArabic() {
            var divToPrint = document.querySelector('.selectedpaymentplan').cloneNode(true);
            // Convert numbers in .solidmoney elements to Arabic numerals
            divToPrint.querySelectorAll('.solidmoney').forEach(function(element) {
            let numericValue = element.innerText.trim().replace(/[^0-9.]/g, ''); // Extract numeric value
            element.innerText = convertNumberToArabicNumerals(numericValue); // Convert to Arabic numerals
            });
            divToPrint.querySelectorAll('tr').forEach(function(row) {
            row.querySelectorAll('td, th').forEach(function(element) {
            let text = element.innerText.trim();
            element.innerText = translateTextToArabic(text);
            });
            });
            var newWin = window.open('', 'Print-Window');
            newWin.document.open();
            newWin.document.write(`
            <html style="direction:rtl;text-align:right">
            <head>
            <style>
            html {direction:rtl;text-align:right}
            th, td {border: 1px solid #dddddd;text-align: right!important;padding: 8px;}
            body {font-family: Arial, sans-serif; margin: 20px;direction:rtl;text-align:right}
            table {width: 100%; border-collapse: collapse; margin-bottom: 20px;}
            th, td {border: 1px solid #dddddd; text-align: left; padding: 8px;}
            th {background-color: #f2f2f2; font-weight: bold;}
            td {background-color: #ffffff; color: #333333;}
            tr:nth-child(even) td {background-color: #f9f9f9;}
            .header {text-align: center; font-size: 24px; font-weight: bold; margin-bottom: 20px;}
            @media print {.print-hide {display: none;}}
            </style>
            </head>
            <body style="direction:rtl;text-align:right">
            ${divToPrint.outerHTML}
            <script>
            window.onload = function() {
            window.print();
            };
            <\/script>
            </body>
            </html>
            `);
            newWin.document.close();
            }
            // JavaScript for converting numbers to Arabic words
            function convertNumberToArabicWords(number) {
            const ones = ['صفر', 'واحد', 'اثنان', 'ثلاثة', 'أربعة', 'خمسة', 'ستة', 'سبعة', 'ثمانية', 'تسعة'];
            const teens = ['عشرة', 'أحد عشر', 'اثنا عشر', 'ثلاثة عشر', 'أربعة عشر', 'خمسة عشر', 'ستة عشر', 'سبعة عشر', 'ثمانية عشر', 'تسعة عشر'];
            const tens = ['عشرون', 'ثلاثون', 'أربعون', 'خمسون', 'ستون', 'سبعون', 'ثمانون', 'تسعون'];
            const hundreds = ['مائة', 'مائتان', 'ثلاثمائة', 'أربعمائة', 'خمسمائة', 'ستمائة', 'سبعمائة', 'ثمانمائة', 'تسعمائة'];
            if (number % 1 !== 0) {
            let parts = number.toString().split('.');
            let integerPart = parseInt(parts[0], 10);
            let decimalPart = parts[1].split('').map(digit => ones[parseInt(digit, 10)]).join(' ');
            return convertNumberToArabicWords(integerPart) + ' فاصلة ' + decimalPart;
            }
            if (number < 10) return ones[number];
            if (number < 20) return teens[number - 10];
            if (number < 100) return tens[Math.floor(number / 10) - 2] + (number % 10 === 0 ? '' : ' و ' + ones[number % 10]);
            if (number < 1000) return (number === 100 ? 'مائة' : hundreds[Math.floor(number / 100) - 1]) + (number % 100 === 0 ? '' : ' و ' + convertNumberToArabicWords(number % 100));
            if (number < 1000000) return convertNumberToArabicWords(Math.floor(number / 1000)) + ' ألف' + (number % 1000 === 0 ? '' : ' و ' + convertNumberToArabicWords(number % 1000));
            if (number < 1000000000) return convertNumberToArabicWords(Math.floor(number / 1000000)) + ' مليون' + (number % 1000000 === 0 ? '' : ' و ' + convertNumberToArabicWords(number % 1000000));
            return number;
            }
            function convertNumberToArabicNumerals(number) {
            const arabicDigits = ['٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩'];
            return number.toString().replace(/\d/g, (digit) => arabicDigits[digit]);
            }
            function translateTextToArabic(text) {
            const translations = {
            "Total Unit Cost": "إجمالي تكلفة الوحدة",
            "Down Payment": "الدفعة المقدمة",
            "before": "قبل",
            "Amount": "المبلغ",
            "After": "بعد",
            "Discount": "الخصم",
            "EGP": "جنيه مصري",
            "thousand": "ألف",
            "million": "مليون",
            "Date": "التاريخ",
            "Quarter": "الربع",
            "Total": "الإجمالي",
            "in": "بـ",
            "Words": "تفقيط",
            "Ratio": "النسبة",
            "Cheque Number": "رقم الشيك",
            "Drawee Bank": "البنك المسحوب عليه",
            "DP": "الدفعة المقدمة",
            "Q": "الربع"
            };
            for (let key in translations) {
            let regex = new RegExp(`\\b${key}\\b`, 'gi');
            text = text.replace(regex, translations[key]);
            }
            return text;
            }
            function downloadExcel(language) {
            var tableClone = document.querySelector('.selectedpaymentplan table').cloneNode(true);
            tableClone.querySelectorAll('.solidmoney').forEach(function(element) {
            let numericValue = element.innerText.trim().replace(/[^0-9.]/g, ''); // Extract numeric value
            if (language === 'arabic') {
            element.innerText = convertNumberToArabicNumerals(numericValue); // Convert to Arabic numerals
            }
            });
            // Loop through each row of the cloned table
            tableClone.querySelectorAll('tr').forEach(function(row, rowIndex) {
            row.querySelectorAll('td, th').forEach(function(element, colIndex) {
            let originalText = element.innerText.trim();
            let numericValue = originalText.replace(/[^0-9.]/g, ''); 
            // Find the "Amount in Words" column and switch between English and Arabic words
            if (language === 'arabic' && rowIndex > 0) { // Exclude the header row
            let amountInWordsEn = element.querySelector('.amount-in-words-en');
            let amountInWordsAr = element.querySelector('.amount-in-words-ar');
            if (amountInWordsAr && amountInWordsEn) {
            amountInWordsEn.style.display = 'none'; // Hide English words
            amountInWordsAr.style.display = 'block'; // Show Arabic words
            }
            } else {
            let amountInWordsEn = element.querySelector('.amount-in-words-en');
            let amountInWordsAr = element.querySelector('.amount-in-words-ar');
            if (amountInWordsAr && amountInWordsEn) {
            amountInWordsEn.style.display = 'block'; // Show English words
            amountInWordsAr.style.display = 'none'; // Hide Arabic words
            }
            }
            // Translate text in the table to Arabic if needed
            if (language === 'arabic') {
            element.innerText = translateTextToArabic(element.innerText);
            }
            });
            });
            var ws = XLSX.utils.table_to_sheet(tableClone);
            var wb = XLSX.utils.book_new();
            XLSX.utils.book_append_sheet(wb, ws, 'Payment Plan');
            XLSX.writeFile(wb, 'Payment_Plan.xlsx');
            }
            function printDiv() {
            var divToPrint = document.querySelector('.selectedpaymentplan').innerHTML;
            var newWin = window.open('', 'Print-Window');
            newWin.document.open();
            newWin.document.write('<html style="dir:rtl;text-align:right"><head><title>Print</title><style>@media print { html,body{dir:rtl;text-align:right}.print-hide { display: none; } }</style></head><body style="dir:rtl;text-align:right" onload="window.print()">' + divToPrint + '</body></html>');
            newWin.document.close();
            setTimeout(function() { newWin.close(); }, 10);
            }
            document.addEventListener('DOMContentLoaded', function() {
            let downPayment = <?php echo json_encode($downPayment); ?>;
            let amountinst = <?php echo json_encode($amountinst); ?>;
            document.getElementById('downPaymentWordsEn').innerText = '<?php echo convertNumberToWords($downPayment); ?>';
            document.getElementById('amountInstWordsEn').innerText = '<?php echo convertNumberToWords($amountinst); ?>';
            document.getElementById('downPaymentWordsAr').innerText = convertNumberToArabicWords(downPayment);
            document.getElementById('amountInstWordsAr').innerText = convertNumberToArabicWords(amountinst);
            });
        </script>
    </div>
<?php }else{?>
<style>
    .selectedpaymentplan table {
    border-collapse: collapse;
    width: 100%;
    }
    .selectedpaymentplan th, .selectedpaymentplan td {
    border: 1px solid #dddddd;
    text-align: left;
    padding: 8px;
    color: #333;
    }
    .selectedpaymentplan th {
    background-color: #f2f2f2;
    }
    .selectedpaymentplan p {
    border: 1px solid #efefef;
    padding: 10px;
    margin: 0;
    color: #333;
    font-weight: 600;
    }
    @media print {
        .print-hide {
        display: none;
        }
    }
</style>
<div class="selectedpaymentplan">
    <label class="kt-font-dark col-md-12">Payment Plan</label>
    <?php
        // Define data
        $payment = $_REQUEST['payment']; // Total unit cost
        $paymentdetails = Paymentmethod::model()->findByPk($payment);
        $totalUnitCost = $_REQUEST['unit']; // Total unit cost
        $downPaymentPercentage ='0.'.$paymentdetails->downpayment; // Down payment percentage
        $discountPercentage = '0.'.$paymentdetails->discount; // Discount percentage
        $installmentYears = $paymentdetails->noofyears; // Installment duration in years
        $startDateString = $_REQUEST['startdate']; // Start date
        $everymonth = $paymentdetails->installmenttype; // Installment frequency in months
        $startDate = new DateTime($startDateString);
        $loanAmount = $totalUnitCost - $downPayment;
        // Calculate discount
        $discount = $totalUnitCost * $discountPercentage;
        // Calculate discounted loan amount
        $discountedLoanAmount = $loanAmount - $discount;
        // Calculate down payment
        $downPayment = $discountedLoanAmount * $downPaymentPercentage;
        // Function to generate installment schedule
        function generateInstallmentSchedule($totalUnitCost, $downPaymentPercentage, $discountedLoanAmount, $installmentYears, $startDateString, $monthsPerInstallment = 3){
        $quartersPerYear = 12 / $monthsPerInstallment;
        $startDate = new DateTime($startDateString);
        $downPayment = $totalUnitCost * $downPaymentPercentage;
        $loanAmount = $totalUnitCost - $downPayment;
        $totalPayments = $installmentYears * $quartersPerYear;
        $installmentAmount = $discountedLoanAmount / $totalPayments;
        $installmentSchedule = [];
        // Calculate total without decimal parts
        $totalInstallmentAmount = floor($installmentAmount) * $totalPayments;
        // Calculate the remaining amount
        $remainingAmount = $discountedLoanAmount - $totalInstallmentAmount;
        for($i = 0; $i < $totalPayments; $i++){
        $installmentDate = clone $startDate;
        $installmentDate->add(new DateInterval('P' . ($monthsPerInstallment * $i) . 'M'));
        // If it's the last installment, add the remaining amount
        if($i === $totalPayments - 1){
        $installmentAmount += $remainingAmount;
        }
        // Convert installment amount to integer
        $installmentAmount = (int) $installmentAmount;
        $installmentSchedule[] = [
        'date' => $installmentDate->format('Y-m-d'),
        'amount' => $installmentAmount
        ];
        }
        return $installmentSchedule;
        }
        // Display results
        echo "<table>";
        echo "<tr><td colspan='2'><b>Total Unit Cost:</b> <span class='solidmoney'> $totalUnitCost </span></td></tr>";
        echo "<tr><td colspan='2'><b>Down Payment:</b> <span class='solidmoney' id='newdownpayment'> $downPayment </span></td></tr>";
        echo "<tr><td colspan='2'><b>Amount before Discount:</b> <span class='solidmoney'> $loanAmount </span></td></tr>";
        echo "<tr><td colspan='2'><b>Discount:</b> <span class='solidmoney'> $discount </span></td></tr>";
        echo "<tr><td colspan='2'><b>Amount after Discount:</b> <span class='solidmoney' id='priceafterdiscount'> $discountedLoanAmount </span></td></tr>";
        echo "<tr><th>Date</th><th>Amount</th></tr>";
        echo "<tbody>";
        $monthlyInstallments = generateInstallmentSchedule($totalUnitCost, $downPaymentPercentage, $discountedLoanAmount, $installmentYears, $startDateString, $everymonth);
        foreach($monthlyInstallments as $installment){
        echo "<tr><td>{$installment['date']}</td><td class='solidmoney'>{$installment['amount']}</td></tr>";
        }
        echo "</tbody>";
        echo "</table>";
        echo "<p>Total Number of Installments: " . count($monthlyInstallments) . "</p>";
    ?>
    <button type="button" class="print-hide btn btn-primary mt-2 d-none" onclick="printDiv()">Print</button>
    <button type="button" class="print-hide btn btn-warning mt-2" onclick="downloadExcel()">Download as Excel</button>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.1/xlsx.full.min.js"></script>
<script>
    function printDiv() {
    var divToPrint = document.querySelector('.selectedpaymentplan').innerHTML;
    var newWin = window.open('', 'Print-Window');
    newWin.document.open();
    newWin.document.write('<html><head><title>Print</title><style>@media print { .print-hide { display: none; } }</style></head><body onload="window.print()">' + divToPrint + '</body></html>');
    newWin.document.close();
    setTimeout(function() { newWin.close(); }, 10);
    }
    function downloadExcel() {
    var table = document.querySelector('.selectedpaymentplan table');
    var ws = XLSX.utils.table_to_sheet(table);
    var wb = XLSX.utils.book_new();
    XLSX.utils.book_append_sheet(wb, ws, 'Payment Plan');
    XLSX.writeFile(wb, 'Payment_Plan.xlsx');
    }
</script>
<?php } ?>
<script>
    $(document).ready(function() {
    $('.solidmoney').each(function() {
    const textContent = $(this).text().trim();
    const number = parseFloat(textContent.replace(/[^0-9.]/g, ''));
    if (!isNaN(number)) {
    $(this).text('EGP ' + formatMoney(number));
    }
    });
    function formatMoney(number) {
    return number.toLocaleString(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 2 });
    }
    });
    $(document).ready(function() {
    $('.solidarea').each(function() {
    var text = $(this).text();
    $(this).text(text + ' m²');
    });
    });
    $(document).ready(function() {
    $('.solidpercentage').each(function() {
    var text = $(this).text();
    $(this).text(text + ' %');
    });
    });
</script>