<?php
use yii\grid\GridView;
use yii\helpers\Html;
use yii\widgets\Pjax;

Pjax::begin();
echo Html::textInput('search', Yii::$app->request->get('search'), [
    'id' => 'live-search',
    'placeholder' => 'Search...',
]);

echo GridView::widget([
    'dataProvider' => $dataProvider,
    'filterModel' => $searchModel,
    'columns' => [
        'level',
        'building',
        'code',
        'floor_title',
        'activity_title',
        'indoor_size',
        'indoor_price',
        'outdoor_size',
        'outdoor_price',
        'totalbefordisc',
        'total',
        'details',
        [
            'attribute' => 'booking',
            'value' => function($data) {
                return $data->booking == 1 ? 'Reserved' :
                       ($data->booking == 2 ? 'Sold' :
                       ($data->booking == 3 ? 'Block' :
                       ($data->booking == 4 ? 'Hold' :
                       ($data->booking == 5 ? 'OFF' :
                       ($data->booking == 6 ? 'DHL' :
                       ($data->booking == 7 ? 'Pending' : 'Available'))))));
            },
        ],
    ],
]);

Pjax::end();
?>