<?php
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);

try {
    $criteria = new CDbCriteria;
    $criteria->limit = 1000;
    $leads = Leads::model()->findAll($criteria);

    $data = array();
    foreach ($leads as $lead) {
        $data[] = array(
            'id' => $lead->id,
            'code' => $lead->code,
            'date' => $lead->date,
            'time' => $lead->time,
            'title' => $lead->title,
            'tel' => $lead->tel,
            'second_tel' => $lead->second_tel,
            'international_code' => $lead->international_code,
            'international_code2' => $lead->international_code2,
            'hiddentel' => $lead->employee ? $lead->employee->hiddentel : 0,
            'created_by' => $lead->employee ? $lead->employee->fullName() : '',
            'sales' => $lead->sales ? $lead->sales->fullName() : '',
            'leader' => Teamleader::getLeadersString($lead->user_sales),
            'adname' => $lead->adname,
            'unit_type' => $lead->unittype ? $lead->unittype->title : '',
            'property_type' => $lead->property_type ? $lead->property_type->title : '',
            'project' => $lead->project ? $lead->project->title : '',
            'campaign' => $lead->campaign ? $lead->campaign->title : '',
            'platform' => $lead->platform ? $lead->platform->title : '',
            'platform_child' => $lead->platformchild ? $lead->platformchild->title : '',
            'notes' => $lead->notes,
            'sales_report' => $lead->sales_report,
            'checkup_activity' => $lead->checkup_activity,
            'status_title' => $lead->statuesaction ? $lead->statuesaction->title : '',
            'status_color' => $lead->statuesaction ? $lead->statuesaction->color : 'secondary',
            'substatus_title' => $lead->substatusaction ? $lead->substatusaction->title : '',
            'follow_date' => $lead->follow_date,
            'follow_time' => $lead->follow_time,
            'action_time' => $lead->action_time,
            'transferdate' => $lead->transferdate,
            'transferuser_name' => User::model()->findByPk($lead->transferuser) ? User::model()->findByPk($lead->transferuser)->fullName() : '',
            'visit' => $lead->visit ? 'visit' : '',
            'client_status' => $lead->getClientStatus(),
        );
    }

    echo CJSON::encode($data);
} catch (Exception $e) {
    echo CJSON::encode(array('error' => $e->getMessage()));
}