<?php

/**
 * This is the model class for table "brokers".
 *
 * The followings are the available columns in table 'brokers':
 * @property integer $id
 * @property string $title
 * @property integer $user_id
 * @property string $date
 * @property string $time
 * @property integer $user_sales
 * @property string $commercial
 * @property string $taxcard
 * @property string $secert
 * @property string $address
 * @property string $details
 * @property string $tel
 * @property string $status
 * @property string $groupwhats
 */
class Brokers extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'brokers';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
	    
            //array('commercial, taxcard,tel','unique'),
            //array('title', 'unique'),
			array('user_id, date, time', 'required'),
			array('user_id, user_sales,active,close', 'numerical', 'integerOnly'=>true),
			array('title,code, commercial, taxcard,campaign_title,value_plus,percentage, secert, tel, status,othersales,thirdsales,incentive,no_group,commercialtitle', 'length', 'max'=>255),
			array('address, details, groupwhats', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, title, user_id, date, time, user_sales, commercial, taxcard, secert, address, details, tel, status, groupwhats,incentive,thirdsales,no_group,commercialtitle', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
	    
	    
	    
	    
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    
		    		'allothersales'    => array(self::BELONGS_TO, 'User',    'othersales'),
		    		'allthirdsales'    => array(self::BELONGS_TO, 'User',    'thirdsales'),
		    		'allusersales'    => array(self::BELONGS_TO, 'User',    'user_sales'),


		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'title' => 'Title',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'user_sales' => 'User Sales',
			'commercial' => 'Commercial',
			'taxcard' => 'Taxcard',
			'secert' => 'Secert',
			'address' => 'Address',
			'details' => 'Details',
			'tel' => 'Tel',
			'status' => 'Status',
			'groupwhats' => 'Groupwhats',
			'commercialtitle' => 'Commercial Title',
			
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
	$criteria=new CDbCriteria;
$criteria->order = 'id DESC';
$criteria->addCondition('active IS NOT NULL');   

$criteria->compare('id', $this->id);
$criteria->compare('title', $this->title, true);
$criteria->compare('user_id', $this->user_id);
$criteria->compare('user_sales', $this->user_sales);
$criteria->compare('othersales', $this->othersales, true);
$criteria->compare('thirdsales', $this->thirdsales, true);
$criteria->compare('commercial', $this->commercial, true);
$criteria->compare('taxcard', $this->taxcard, true);
$criteria->compare('secert', $this->secert, true);
$criteria->compare('address', $this->address, true);
$criteria->compare('details', $this->details, true);
$criteria->compare('tel', $this->tel, true);
$criteria->compare('status', $this->status, true);
$criteria->compare('groupwhats', $this->groupwhats, true);
$criteria->compare('date', $this->date, true);
$criteria->compare('time', $this->time, true);

$sort = new CSort();
$sort->defaultOrder = 'id DESC';
$sort->attributes = array(
    'id' => array(
        'asc' => 'id ASC',
        'desc' => 'id DESC',
    ),
    'title' => array(
        'asc' => 'title ASC',
        'desc' => 'title DESC',
    ),
    'user_id' => array(
        'asc' => 'user_id ASC',
        'desc' => 'user_id DESC',
    ),
    'user_sales' => array(
        'asc' => 'user_sales ASC',
        'desc' => 'user_sales DESC',
    ),
    'othersales' => array(
        'asc' => 'othersales ASC',
        'desc' => 'othersales DESC',
    ),
    'thirdsales' => array(
        'asc' => 'thirdsales ASC',
        'desc' => 'thirdsales DESC',
    ),
    'date' => array(
        'asc' => 'date ASC',
        'desc' => 'date DESC',
    ),
    'time' => array(
        'asc' => 'time ASC',
        'desc' => 'time DESC',
    ),
    'commercial' => array(
        'asc' => 'commercial ASC',
        'desc' => 'commercial DESC',
    ),
    'taxcard' => array(
        'asc' => 'taxcard ASC',
        'desc' => 'taxcard DESC',
    ),
    'address' => array(
        'asc' => 'address ASC',
        'desc' => 'address DESC',
    ),
    'tel' => array(
        'asc' => 'tel ASC',
        'desc' => 'tel DESC',
    ),
    'status' => array(
        'asc' => 'status ASC',
        'desc' => 'status DESC',
    ),
    'groupwhats' => array(
        'asc' => 'groupwhats ASC',
        'desc' => 'groupwhats DESC',
    ),
);

return new CActiveDataProvider($this, array(
    'pagination' => array(
        'pageSize' => Yii::app()->user->getState('pageSize', Yii::app()->params['defaultPageSize']),
    ),
    'criteria' => $criteria,
    'sort' => $sort,
));
	}
	
	
	
	
		public function block()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;
        $criteria->order = 'id DESC';


		$criteria->addCondition('active IS NULL');

		$criteria->compare('id',$this->id);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('user_sales',$this->user_sales);
		$criteria->compare('commercial',$this->commercial,true);
		$criteria->compare('taxcard',$this->taxcard,true);
		$criteria->compare('secert',$this->secert,true);
		$criteria->compare('address',$this->address,true);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('tel',$this->tel,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('groupwhats',$this->groupwhats,true);

	  
		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	
	
	
	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Brokers the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
