<?php

/**
 * This is the model class for table "data".
 *
 * The followings are the available columns in table 'data':
 * @property integer $id
 * @property integer $type_id
 * @property integer $resource_id
 * @property string $name
 * @property string $phone
 * @property integer $area
 * @property integer $region_id
 * @property integer $location
 * @property integer $user_id
 * @property integer $old_user
 * @property string $date
 * @property integer $add_user
 * @property string $delivary_date
 * @property string $status
 */
class Data extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'data';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('type_id, resource_id, name, phone, user_id, date, add_user, delivary_date, status', 'required'),
			array('type_id, resource_id, area, region_id, location, user_id, old_user, add_user', 'numerical', 'integerOnly'=>true),
			array('name', 'length', 'max'=>128),
			array('phone', 'length', 'max'=>245),
			array('status', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, type_id, resource_id, name, phone, area, region_id, location, user_id, old_user, date, add_user, delivary_date, status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'type_id' => 'Type',
			'resource_id' => 'Resource',
			'name' => 'Name',
			'phone' => 'Phone',
			'area' => 'Area',
			'region_id' => 'Region',
			'location' => 'Location',
			'user_id' => 'User',
			'old_user' => 'Old User',
			'date' => 'Date',
			'add_user' => 'Add User',
			'delivary_date' => 'Delivary Date',
			'status' => 'Status',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('type_id',$this->type_id);
		$criteria->compare('resource_id',$this->resource_id);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('phone',$this->phone,true);
		$criteria->compare('area',$this->area);
		$criteria->compare('region_id',$this->region_id);
		$criteria->compare('location',$this->location);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('old_user',$this->old_user);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('add_user',$this->add_user);
		$criteria->compare('delivary_date',$this->delivary_date,true);
		$criteria->compare('status',$this->status,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Data the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
