<?php

/**
 * This is the model class for table "fi_credit_balance".
 *
 * The followings are the available columns in table 'fi_credit_balance':
 * @property integer $id
 * @property integer $user_id
 * @property string $date
 * @property string $time
 * @property integer $tree_id
 * @property double $credit_balance
 * @property integer $fi_generalledger_id
 * @property integer $fi_generalledgergroup_id
 */
class FiCreditBalance extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'fi_credit_balance';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, date, time, tree_id, credit_balance', 'required'),
			array('user_id, tree_id, fi_generalledger_id, fi_generalledgergroup_id', 'numerical', 'integerOnly'=>true),
			array('credit_balance', 'numerical'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, date, time, tree_id, credit_balance, fi_generalledger_id, fi_generalledgergroup_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'tree_id' => 'Tree',
			'credit_balance' => 'Credit Balance',
			'fi_generalledger_id' => 'Fi Generalledger',
			'fi_generalledgergroup_id' => 'Fi Generalledgergroup',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('tree_id',$this->tree_id);
		$criteria->compare('credit_balance',$this->credit_balance);
		$criteria->compare('fi_generalledger_id',$this->fi_generalledger_id);
		$criteria->compare('fi_generalledgergroup_id',$this->fi_generalledgergroup_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FiCreditBalance the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
