<?php

/**
 * This is the model class for table "hr_employee".
 *
 * The followings are the available columns in table 'hr_employee':
 * @property integer $id
 * @property string $date
 * @property string $time
 * @property integer $user_id
 * @property string $user_system
 * @property string $name
 * @property string $name_en
 * @property string $job
 * @property string $email
 * @property string $mobile_number
 * @property integer $salary
 * @property string $role
 * @property string $reported_to
 * @property integer $deparment_id
 * @property string $assign_date
 * @property string $leave_date
 * @property string $work_now
 * @property string $source
 * @property string $cv
 * @property string $finger_id
 * @property string $gender
 * @property string $graduation_certificate
 * @property integer $branch_id
 * @property integer $nationality_id
 * @property string $work_permit
 * @property string $work_permit_date
 * @property integer $type_of_contract_id
 * @property string $contract_date
 * @property string $contract_end_date
 * @property string $release_date
 * @property string $national_id
 * @property string $birth_date
 * @property integer $age
 * @property integer $duration_of_insurance_service
 * @property integer $vacations_balance
 * @property string $insurance_status
 * @property integer $insurance_number
 * @property string $insurance_office
 * @property string $birth_certificate
 * @property string $image
 * @property string $military_service_certificate
 * @property string $criminal_newspaper
 * @property string $certificate_of_qualification
 * @property string $id_card
 * @property string $acknowledgment_of_receipt_of_work
 * @property string $acknowledgment_of_his_receipt
 * @property string $application
 * @property string $labor_office_registration_certificate
 * @property string $business_office_portfolio
 * @property string $medical_examination_form
 * @property string $the_treatment_card
 * @property string $practicing_the_profession
 * @property string $carnet_practicing_the_profession
 * @property string $driving_license
 * @property string $car
 * @property integer $paper_completion_percentage
 * @property integer $status
 * @property string $type
 * @property string $religion
 * @property string $marital_status
 * @property string $phone_work1
 * @property string $phone_work2
 * @property string $phone
 * @property string $email2
 * @property string $address
 * @property string $address_card
 * @property string $qualification
 * @property string $graduation_date
 * @property string $subscription
 * @property string $comprehensive
 * @property string $basic
 * @property string $details
 * @property string $supply_date
 */
class HrEmployee extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'hr_employee';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
		//	array('date, time, user_id, name, mobile_number, gender,  address', 'required'),
			array('user_id, salary, deparment_id, branch_id, type_of_contract_id, age, duration_of_insurance_service,  insurance_number, cv_check, birth_certificate_check, image_check, military_service_certificate_check,criminal_newspaper_check,certificate_of_qualification_check,id_card_check, application_check,labor_office_registration_certificate_check,business_office_portfolio_check,acknowledgment_of_receipt_of_work_check ,medical_examination_form_check,the_treatment_card_check, practicing_the_profession_check, carnet_practicing_the_profession_check,driving_license_check, paper_completion_percentage, status, section_id', 'numerical', 'integerOnly'=>true),
			array('user_system, name, name_en, job, email, mobile_number,  nationality_id, reported_to, assign_date, leave_date, work_now, source, cv, finger_id, gender, graduation_certificate, work_permit, work_permit_date, contract_date, contract_end_date, release_date, national_id, birth_date, insurance_status, insurance_office, birth_certificate, image, military_service_certificate, criminal_newspaper, certificate_of_qualification, id_card, acknowledgment_of_receipt_of_work, acknowledgment_of_his_receipt, application, labor_office_registration_certificate, business_office_portfolio, medical_examination_form, the_treatment_card, practicing_the_profession, carnet_practicing_the_profession, driving_license, car, type, religion, marital_status, phone_work1, phone_work2, phone, email2, address, address_card, qualification, graduation_date, subscription, comprehensive, basic,cv_note,birth_certificate_note,image_note,military_service_certificate_note,criminal_newspaper_note,certificate_of_qualification_note,id_card_note,acknowledgment_of_receipt_of_work_note,application_note,labor_office_registration_certificate_note,business_office_portfolio_note,medical_examination_form_notes,the_treatment_card_notes,practicing_the_profession_note,carnet_practicing_the_profession_note,driving_license_note, supply_date,shiftstart,shiftend,vacations_balance', 'length', 'max'=>255),
			array('role', 'length', 'max'=>11),
			array('details', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, date, time, user_id, user_system, name, name_en, job, email, mobile_number, salary, role, reported_to, deparment_id, assign_date, leave_date, work_now, source, cv, finger_id, gender, graduation_certificate, branch_id, nationality_id, work_permit, work_permit_date, type_of_contract_id, contract_date, contract_end_date, release_date, national_id, birth_date, age, duration_of_insurance_service, vacations_balance, insurance_status, insurance_number, insurance_office, birth_certificate, image, military_service_certificate, criminal_newspaper, certificate_of_qualification, id_card, acknowledgment_of_receipt_of_work, acknowledgment_of_his_receipt, application, labor_office_registration_certificate, business_office_portfolio, medical_examination_form, the_treatment_card, practicing_the_profession, carnet_practicing_the_profession, driving_license, car, paper_completion_percentage, status, type, religion, marital_status, phone_work1, phone_work2, phone, email2, address, address_card, qualification, graduation_date, subscription, comprehensive, basic, details, supply_date, section_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'date' => 'Date',
			'time' => 'Time',
			'user_id' => 'User',
			'user_system' => 'User System',
			'name' => 'Name',
			'name_en' => 'Name En',
			'job' => 'Job',
			'email' => 'Email',
			'mobile_number' => 'Mobile Number',
			'salary' => 'Salary',
			'role' => 'Role',
			'reported_to' => 'Reported To',
			'deparment_id' => 'Deparment',
			'assign_date' => 'Assign Date',
			'leave_date' => 'Leave Date',
			'work_now' => 'Work Now',
			'source' => 'Source',
			'cv' => 'Cv',
			'cv_check' => 'Cv check',
			'cv_note' => 'Cv Note',
			'finger_id' => 'Finger',
			'gender' => 'Gender',
			'graduation_certificate' => 'Graduation Certificate',
			'branch_id' => 'Branch',
			'nationality_id' => 'Nationality',
			'work_permit' => 'Work Permit',
			'work_permit_date' => 'Work Permit Date',
			'type_of_contract_id' => 'Type Of Contract',
			'contract_date' => 'Contract Date',
			'contract_end_date' => 'Contract End Date',
			'release_date' => 'Release Date',
			'national_id' => 'National',
			'birth_date' => 'Birth Date',
			'age' => 'Age',
			'duration_of_insurance_service' => 'Duration Of Insurance Service',
			'vacations_balance' => 'Vacations Balance',
			'insurance_status' => 'Insurance Status',
			'insurance_number' => 'Insurance Number',
			'insurance_office' => 'Insurance Office',
			'birth_certificate' => 'Birth Certificate',
			'image' => 'Image',
			'military_service_certificate' => 'Military Service Certificate',
			'criminal_newspaper' => 'Criminal Newspaper',
			'certificate_of_qualification' => 'Certificate Of Qualification',
			'id_card' => 'Id Card',
			'acknowledgment_of_receipt_of_work' => 'Acknowledgment Of Receipt Of Work',
			'acknowledgment_of_his_receipt' => 'Acknowledgment Of His Receipt',
			'application' => 'Application',
			'labor_office_registration_certificate' => 'Labor Office Registration Certificate',
			'business_office_portfolio' => 'Business Office Portfolio',
			'medical_examination_form' => 'Medical Examination Form',
			'the_treatment_card' => 'The Treatment Card',
			'practicing_the_profession' => 'Practicing The Profession',
			'carnet_practicing_the_profession' => 'Carnet Practicing The Profession',
			'driving_license' => 'Driving License',
			'car' => 'Car',
			'paper_completion_percentage' => 'Paper Completion Percentage',
			'status' => 'Status',
			'type' => 'Type',
			'religion' => 'Religion',
			'marital_status' => 'Marital Status',
			'phone_work1' => 'Phone Work1',
			'phone_work2' => 'Phone Work2',
			'phone' => 'Phone',
			'email2' => 'Email2',
			'address' => 'Address',
			'address_card' => 'Address Card',
			'qualification' => 'Qualification',
			'graduation_date' => 'Graduation Date',
			'subscription' => 'Subscription',
			'comprehensive' => 'Comprehensive',
			'basic' => 'Basic',
			'details' => 'Details',
			'supply_date' => 'Supply Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('user_system',$this->user_system,true);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('name_en',$this->name_en,true);
		$criteria->compare('job',$this->job,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('mobile_number',$this->mobile_number,true);
		$criteria->compare('salary',$this->salary);
		$criteria->compare('role',$this->role,true);
		$criteria->compare('reported_to',$this->reported_to,true);
		$criteria->compare('deparment_id',$this->deparment_id);
		$criteria->compare('assign_date',$this->assign_date,true);
		$criteria->compare('leave_date',$this->leave_date,true);
		$criteria->compare('work_now',$this->work_now,true);
		$criteria->compare('source',$this->source,true);
		$criteria->compare('cv',$this->cv,true);
		$criteria->compare('finger_id',$this->finger_id,true);
		$criteria->compare('gender',$this->gender,true);
		$criteria->compare('graduation_certificate',$this->graduation_certificate,true);
		$criteria->compare('branch_id',$this->branch_id);
		$criteria->compare('nationality_id',$this->nationality_id);
		$criteria->compare('work_permit',$this->work_permit,true);
		$criteria->compare('work_permit_date',$this->work_permit_date,true);
		$criteria->compare('type_of_contract_id',$this->type_of_contract_id);
		$criteria->compare('contract_date',$this->contract_date,true);
		$criteria->compare('contract_end_date',$this->contract_end_date,true);
		$criteria->compare('release_date',$this->release_date,true);
		$criteria->compare('national_id',$this->national_id,true);
		$criteria->compare('birth_date',$this->birth_date,true);
		$criteria->compare('age',$this->age);
		$criteria->compare('duration_of_insurance_service',$this->duration_of_insurance_service);
		$criteria->compare('vacations_balance',$this->vacations_balance);
		$criteria->compare('insurance_status',$this->insurance_status,true);
		$criteria->compare('insurance_number',$this->insurance_number);
		$criteria->compare('insurance_office',$this->insurance_office,true);
		$criteria->compare('birth_certificate',$this->birth_certificate,true);
		$criteria->compare('image',$this->image,true);
		$criteria->compare('military_service_certificate',$this->military_service_certificate,true);
		$criteria->compare('criminal_newspaper',$this->criminal_newspaper,true);
		$criteria->compare('certificate_of_qualification',$this->certificate_of_qualification,true);
		$criteria->compare('id_card',$this->id_card,true);
		$criteria->compare('acknowledgment_of_receipt_of_work',$this->acknowledgment_of_receipt_of_work,true);
		$criteria->compare('acknowledgment_of_his_receipt',$this->acknowledgment_of_his_receipt,true);
		$criteria->compare('application',$this->application,true);
		$criteria->compare('labor_office_registration_certificate',$this->labor_office_registration_certificate,true);
		$criteria->compare('business_office_portfolio',$this->business_office_portfolio,true);
		$criteria->compare('medical_examination_form',$this->medical_examination_form,true);
		$criteria->compare('the_treatment_card',$this->the_treatment_card,true);
		$criteria->compare('practicing_the_profession',$this->practicing_the_profession,true);
		$criteria->compare('carnet_practicing_the_profession',$this->carnet_practicing_the_profession,true);
		$criteria->compare('driving_license',$this->driving_license,true);
		$criteria->compare('car',$this->car,true);
		$criteria->compare('paper_completion_percentage',$this->paper_completion_percentage);
		$criteria->compare('status',$this->status);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('religion',$this->religion,true);
		$criteria->compare('marital_status',$this->marital_status,true);
		$criteria->compare('phone_work1',$this->phone_work1,true);
		$criteria->compare('phone_work2',$this->phone_work2,true);
		$criteria->compare('phone',$this->phone,true);
		$criteria->compare('email2',$this->email2,true);
		$criteria->compare('address',$this->address,true);
		$criteria->compare('address_card',$this->address_card,true);
		$criteria->compare('qualification',$this->qualification,true);
		$criteria->compare('graduation_date',$this->graduation_date,true);
		$criteria->compare('subscription',$this->subscription,true);
		$criteria->compare('comprehensive',$this->comprehensive,true);
		$criteria->compare('basic',$this->basic,true);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('supply_date',$this->supply_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrEmployee the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
