<?php

/**
 * This is the model class for table "officeboyorders".
 *
 * The followings are the available columns in table 'officeboyorders':
 * @property integer $id
 * @property string $date
 * @property string $time
 * @property integer $title_id
 * @property string $sugar
 * @property string $extra
 * @property integer $close
 * @property integer $user_id
 * @property integer $quantity
 */
class Officeboyorders extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'officeboyorders';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('date, time, title_id, user_id, quantity', 'required'),
			array('title_id, close, user_id, quantity', 'numerical', 'integerOnly'=>true),
			array('sugar', 'length', 'max'=>11),
			array('extra', 'length', 'max'=>255),
			
			array( 'extra', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),

			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, date, time, title_id, sugar, extra, close, user_id, quantity', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		'drink'    => array(self::BELONGS_TO, 'Officeboystock',    'title_id'),
		'employee'    => array(self::BELONGS_TO, 'User',    'user_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'date' => 'Date',
			'time' => 'Time',
			'title_id' => 'Title',
			'sugar' => 'Sugar',
			'extra' => 'Extra',
			'close' => 'Close',
			'user_id' => 'User',
			'quantity' => 'Quantity',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('title_id',$this->title_id);
		$criteria->compare('sugar',$this->sugar,true);
		$criteria->compare('extra',$this->extra,true);
		$criteria->compare('close',$this->close);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('quantity',$this->quantity);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Officeboyorders the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
