<?php

/**
 * This is the model class for table "payment_system".
 *
 * The followings are the available columns in table 'payment_system':
 * @property integer $id
 * @property integer $user_id
 * @property string $date
 * @property string $time
 * @property string $title
 * @property integer $contract
 * @property integer $contract_value
 * @property integer $installment2
 * @property string $installment_date
 * @property string $installment_value
 * @property integer $installment1
 * @property integer $installment_months_value
 * @property string $installment_from
 * @property string $installment_to
 * @property integer $discount
 * @property integer $discount_value
 */
class PaymentSystem extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'payment_system';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('user_id, date, time, title, contract, contract_value, installment2, installment_date, installment_value, //installment_months_value, installment_from, installment_to, discount, discount_value', 'required'),
			array('user_id, contract, contract_value, installment2, installment1, discount, discount_value', 'numerical', 'integerOnly'=>true),
			array('title ,upload', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, date, time, title, contract, contract_value, installment2, installment_date , installment_value, installment_from, installment_to ,installment_months_value, installment_value, installment1,  installment_from, installment_to, installment_date, discount, discount_value ,upload', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'title' => 'Title',
			'contract' => 'Contract',
			'contract_value' => 'Contract Value',
			'installment2' => 'Installment2',
			'installment_date' => 'Installment Date',
			'installment_value' => 'Installment Value',
			'installment1' => 'Installment1',
			'installment_months_value' => 'Installment Months Value',
			'installment_from' => 'Installment From',
			'installment_to' => 'Installment To',
			'discount' => 'Discount',
			'discount_value' => 'Discount Value',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('contract',$this->contract);
		$criteria->compare('contract_value',$this->contract_value);
		$criteria->compare('installment2',$this->installment2);
		$criteria->compare('installment_date',$this->installment_date,true);
		$criteria->compare('installment_value',$this->installment_value,true);
		$criteria->compare('installment1',$this->installment1);
		$criteria->compare('installment_months_value',$this->installment_months_value);
		$criteria->compare('installment_from',$this->installment_from,true);
		$criteria->compare('installment_to',$this->installment_to,true);
		$criteria->compare('discount',$this->discount);
		$criteria->compare('discount_value',$this->discount_value);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return PaymentSystem the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
