<?php

/**
 * This is the model class for table "reservation".
 *
 * The followings are the available columns in table 'reservation':
 * @property integer $id
 * @property string $date
 * @property string $time
 * @property integer $unit_id
 * @property string $name
 * @property integer $tree_id
 * @property integer $lead_id
 * @property string $phone
 * @property integer $user_id
 * @property string $delivery_date
 * @property integer $unit_price
 * @property string $unit_price_tef
 * @property integer $price_per_m
 * @property string $details
 * @property string $address
 * @property string $id_card
 * @property string $amount_paid
 * @property string $payment_method
 * @property string $file
 * @property integer $confirm
 * @property integer $quotation
 * @property string $sourcetitle
 * @property string $commercialno
 * @property string $dateofwarning
 * @property string $dateofend
 * @property integer $timing_id
 * @property string $cashflow
 * @property integer $close
 * @property string $resv_date
 * @property string $contract_date
 * @property string $cancel_date
 * @property integer $request_reservation
 * @property string $name2
 * @property string $phone2
 * @property string $id_card2
 * @property string $address2
 * @property string $name3
 * @property string $phone3
 * @property string $id_card3
 * @property string $address3
 * @property string $name4
 * @property string $phone4
 * @property string $id_card4
 * @property string $address4
 * @property string $name5
 * @property string $phone5
 * @property string $id_card5
 * @property string $address5
 * @property string $name6
 * @property string $phone6
 * @property string $id_card6
 * @property string $address6
 * @property integer $mandatoryrent
 * @property string $address_email
 * @property string $inst_number
 * @property string $nationality
 * @property string $nationality2
 * @property integer $nationality3
 * @property integer $nationality4
 * @property integer $nationality5
 * @property integer $nationality6
 * @property string $job
 * @property string $job2
 * @property string $job3
 * @property string $job4
 * @property string $job5
 * @property string $job6
 * @property string $otheradress2
 * @property string $otheradress3
 * @property string $otheradress4
 * @property string $otheradress5
 * @property string $otheradress6
 * @property integer $sales1
 * @property integer $sales2
 * @property integer $sales3
 * @property integer $sales4
 * @property integer $sales5
 * @property integer $sales6
 * @property integer $teamleader1
 * @property integer $teamleader2
 * @property integer $teamleader3
 * @property integer $teamleader4
 * @property integer $teamleader5
 * @property integer $teamleader6
 * @property integer $manager1
 * @property integer $manager2
 * @property integer $manager3
 * @property integer $manager4
 * @property integer $manager5
 * @property integer $manager6
 * @property string $salesbroker
 * @property string $teamleaderbroker
 * @property integer $cancel
 * @property string $id_date
 * @property string $id_date2
 * @property string $id2_date
 * @property string $id3_date
 * @property string $id4_date
 * @property string $id5_date
 * @property string $enddate
 */
class Reservation extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'reservation';
	}



	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(

			array('date, time', 'required'),
			array('unit_id, tree_id, lead_id, user_id, unit_price, price_per_m, confirm, quotation, timing_id, close, request_reservation, mandatoryrent, nationality4, nationality5, nationality6, sales1, sales2, sales3, sales4, sales5, sales6, teamleader1, teamleader2, teamleader3, teamleader4, teamleader5, teamleader6, manager1, manager2, manager3, manager4, manager5, manager6, cancel, financialapproval,unit_priceen', 'numerical', 'integerOnly'=>true),
			array('name, phone, details, address, id_card, amount_paid, payment_method, file, sourcetitle, commercialno, cashflow, resv_date, name2, phone2, id_card2,  address2, name3, phone3, id_card3, address3, name4, phone4, id_card4, address4, name5, phone5, id_card5, address5, name6, phone6, id_card6, address6, address_email, inst_number, nationality, job, job2, job3, job4, job5, job6, otheradress2, otheradress3, otheradress4, otheradress5, otheradress6, nationality3, salesbroker, teamleaderbroker, id_date, id_date2, id2_date, id3_date, id4_date, id5_date, enddate, sales1ra, sales2ra, sales3ra, sales4ra, sales5ra, sales6ra, teamleader1ra, teamleader2ra, teamleader3ra, teamleader4ra, teamleader5ra, teamleader6ra, manager1ra, manager2ra, manager3ra, manager4ra, manager5ra, manager6ra,firstres_delivery_date,late_payment_ratio,res_mantan_amount,late_payment_every,nameen,phoneen,id_carden,addressen,nationalityen,joben,address_emailen,salesbrokeren,teamleaderbrokeren,downpaymenten,amount_paiden,delivery_dateen,resv_dateen,res_delivery_dateen,res_mantan_amounten,cashflowen,commercialnoen,inst_numberen,sales1raen,teamleader1raen,manager1raen,sourcetitleen,detailsen,receipt,maintenance,con_date,email,local,collect_status_done,collect_status,project,building', 'length', 'max'=>255),
			array('nationality2', 'length', 'max'=>355),
			array('delivery_date, unit_price_tef, dateofwarning, dateofend, contract_date, cancel_date', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, date, time, unit_id, name, tree_id, lead_id, phone, user_id, delivery_date, unit_price, unit_price_tef, price_per_m, details, address, id_card, amount_paid, payment_method, file, confirm, quotation, sourcetitle, commercialno, dateofwarning, dateofend, timing_id, cashflow, close, resv_date, contract_date, cancel_date, request_reservation, name2, phone2, id_card2, address2, name3, phone3, id_card3, unit_priceen,address3, name4, phone4, id_card4, address4, name5, phone5, id_card5, address5, name6, phone6, id_card6, address6, mandatoryrent, address_email, inst_number, nationality, nationality2, nationality3, nationality4, nationality5, nationality6, job, job2, job3, job4, job5, job6, otheradress2, otheradress3, otheradress4, otheradress5, otheradress6, sales1, sales2, sales3, sales4, sales5, sales6, teamleader1, teamleader2, teamleader3, teamleader4, teamleader5, teamleader6, manager1, manager2, manager3, manager4, manager5, manager6, salesbroker, teamleaderbroker, cancel, id_date, id_date2, id2_date, id3_date, id4_date, id5_date, enddate,financialapproval, res_delivery_date,res_mantan_amount,firstres_delivery_date,nameen,phoneen,id_carden,addressen,nationalityen,joben,address_emailen,salesbrokeren,teamleaderbrokeren,downpaymenten,amount_paiden,delivery_dateen,resv_dateen,res_delivery_dateen,res_mantan_amounten,cashflowen,commercialnoen,inst_numberen,sales1raen,teamleader1raen,manager1raen,sourcetitleen.detailsen,email,local,collect_status_done,collect_status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    
		    
		    
		    	'lead'    => array(self::BELONGS_TO, 'Leads',    'lead_id'),
		'request'    => array(self::BELONGS_TO, 'RequestReservation',    'request_reservation'),	
		

		'unit'    => array(self::BELONGS_TO, 'Units',    'unit_id'),	
		'system'    => array(self::BELONGS_TO, 'PaymentSystem',    'payment_method'),
		'tree'    => array(self::BELONGS_TO, 'Treeaccount',    'tree_id'),
		'timing'    => array(self::BELONGS_TO, 'Timing',    'timing_id'),
		    
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'date' => 'Date',
			'time' => 'Time',
			'unit_id' => 'Unit',
			'name' => 'Name',
			'tree_id' => 'Tree',
			'lead_id' => 'Lead',
			'phone' => 'Phone',
			'user_id' => 'User',
			'delivery_date' => 'Delivery Date',
			'unit_price' => 'Unit Price',
			'unit_price_tef' => 'Unit Price Tef',
			'price_per_m' => 'Price Per M',
			'details' => 'Details',
			'address' => 'Address',
			'id_card' => 'Id Card',
			'amount_paid' => 'Amount Paid',
			'payment_method' => 'Payment Method',
			'file' => 'File',
			'confirm' => 'Confirm',
			'quotation' => 'Quotation',
			'sourcetitle' => 'Sourcetitle',
			'commercialno' => 'Commercialno',
			'dateofwarning' => 'Dateofwarning',
			'dateofend' => 'Dateofend',
			'timing_id' => 'Timing',
			'cashflow' => 'Cashflow',
			'close' => 'Close',
			'resv_date' => 'Resv Date',
			'contract_date' => 'Contract Date',
			'cancel_date' => 'Cancel Date',
			'request_reservation' => 'Request Reservation',
			'name2' => 'Name2',
			'phone2' => 'Phone2',
			'id_card2' => 'Id Card2',
			'address2' => 'Address2',
			'name3' => 'Name3',
			'phone3' => 'Phone3',
			'id_card3' => 'Id Card3',
			'address3' => 'Address3',
			'name4' => 'Name4',
			'phone4' => 'Phone4',
			'id_card4' => 'Id Card4',
			'address4' => 'Address4',
			'name5' => 'Name5',
			'phone5' => 'Phone5',
			'id_card5' => 'Id Card5',
			'address5' => 'Address5',
			'name6' => 'Name6',
			'phone6' => 'Phone6',
			'id_card6' => 'Id Card6',
			'address6' => 'Address6',
			'mandatoryrent' => 'Mandatoryrent',
			'address_email' => 'Address Email',
			'inst_number' => 'Inst Number',
			'nationality' => 'Nationality',
			'nationality2' => 'Nationality2',
			'nationality3' => 'Nationality3',
			'nationality4' => 'Nationality4',
			'nationality5' => 'Nationality5',
			'nationality6' => 'Nationality6',
			'job' => 'Job',
			'job2' => 'Job2',
			'job3' => 'Job3',
			'job4' => 'Job4',
			'job5' => 'Job5',
			'job6' => 'Job6',
			'otheradress2' => 'Otheradress2',
			'otheradress3' => 'Otheradress3',
			'otheradress4' => 'Otheradress4',
			'otheradress5' => 'Otheradress5',
			'otheradress6' => 'Otheradress6',
			'sales1' => 'Sales1',
			'sales2' => 'Sales2',
			'sales3' => 'Sales3',
			'sales4' => 'Sales4',
			'sales5' => 'Sales5',
			'sales6' => 'Sales6',
			'teamleader1' => 'Teamleader1',
			'teamleader2' => 'Teamleader2',
			'teamleader3' => 'Teamleader3',
			'teamleader4' => 'Teamleader4',
			'teamleader5' => 'Teamleader5',
			'teamleader6' => 'Teamleader6',
			'manager1' => 'Manager1',
			'manager2' => 'Manager2',
			'manager3' => 'Manager3',
			'manager4' => 'Manager4',
			'manager5' => 'Manager5',
			'manager6' => 'Manager6',
			'salesbroker' => 'Salesbroker',
			'teamleaderbroker' => 'Teamleaderbroker',
			'cancel' => 'Cancel',
			'id_date' => 'Id Date',
			'id_date2' => 'Id Date2',
			'id2_date' => 'Id2 Date',
			'id3_date' => 'Id3 Date',
			'id4_date' => 'Id4 Date',
			'id5_date' => 'Id5 Date',
			'enddate' => 'Enddate',
			'financialapproval' => 'Financialapproval',
			'con_date' => 'con_date',
			
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('unit_id',$this->unit_id);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('lead_id',$this->lead_id);
		$criteria->compare('phone',$this->phone,true);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('tree_id',$this->tree_id);
		$criteria->compare('delivery_date',$this->delivery_date,true);
		$criteria->compare('unit_price',$this->unit_price);
		$criteria->compare('price_per_m',$this->price_per_m);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('address',$this->address,true);
		$criteria->compare('id_card',$this->id_card,true);
		$criteria->compare('amount_paid',$this->amount_paid,true);
		$criteria->compare('payment_method',$this->payment_method,true);
		$criteria->compare('confirm',$this->confirm,true);
		$criteria->compare('file',$this->file,true);
		$criteria->compare('close',$this->close,true);		
		$criteria->compare('con_date',$this->con_date,true);		

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	
	
	
	
	
	
	
	
		public function searchcon()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
        
        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);

        
        $criteria = new CDbCriteria();
        $criteria->order = 'id DESC';
            $criteria->addSearchCondition('unit_price', $_REQUEST['amount'],false, "AND");
            $criteria->addSearchCondition('downpayment', $_REQUEST['downpayment'],false, "AND");
            $criteria->addSearchCondition('lead_id', $_REQUEST['lead'],false, "AND");
            $criteria->addSearchCondition('unit_id', $_REQUEST['unit'],false, "AND");
            if(isset($_REQUEST['building'])) {
            $build = Building::model()->findByPk($_REQUEST['building']);
            if($build !== null) {
            $criteriabu = new CDbCriteria();
            $criteriabu->compare('building_id', $build->id);
            $units = Units::model()->findAll($criteriabu);
            // Now you have all units related to the building
            $arr=array();
            foreach($units as $unit) {
            $arr[]=$unit->id;
            }
            
            $criteria->addInCondition('unit_id', $arr);
            
            } 
            }
            
            
            
            
        
        
        if (sizeof($_REQUEST['user']) > 1) {
        $conditions = [];
        foreach (range(1, 6) as $i) {
        $conditions[] = "sales{$i} IN ('" . implode("','", $_REQUEST['user']) . "')";
        }
        $criteria->addCondition('(' . implode(' OR ', $conditions) . ')', 'AND');
        }






if (sizeof($_REQUEST['teamleader']) > 1) {
    $conditions = [];
    foreach (range(1, 6) as $i) {
        $conditions[] = "teamleader{$i} IN ('" . implode("','", $_REQUEST['teamleader']) . "')";
    }
    $criteria->addCondition('(' . implode(' OR ', $conditions) . ')', 'AND');
}


	
	            $criteria->addBetweenCondition("con_date",$_REQUEST['startdate4'],$_REQUEST['enddate4'],'AND');

	
		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,'defaultOrder'=>'id ASC', 
		));
	}
	
	
	
	
	
	
	
	
	
	
	
		public function readycancelres()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
      
        
        
        
        $criteria = new CDbCriteria();
        //$criteria->order = 'id DESC';
        //$criteria->condition = "quotation IS NULL ";
        $criteria->condition = "quotation IS NULL AND confirm IS NULL AND cancel IS NULL";


$start = '2019-01-01';
$end = date('Y-m-d', strtotime("-1 days"));
$criteria->addBetweenCondition("delivery_date",$start,$end,'AND');
        
        
        //$criteria->condition .= "file IS NOT NULL";

			
      

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,'defaultOrder'=>'id ASC', 
		));
	}
	
	
	
	
	
	
	
	
	
		public function resleader()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
      
       
        
        
        $criteria = new CDbCriteria();
        $criteria->order = 'id DESC';
        //$criteria->condition = "quotation IS NULL ";
        $criteria->condition = "quotation IS NULL AND confirm IS NULL AND cancel IS NULL";
        
         $allemployee = Teamleader::model()->findAll(array( 'condition' => 'leader_id=' . $userid ,'order'=>'id DESC'  ));
            $arr=array();
            foreach($allemployee as $leader){
            $arr[]=$leader->sales_id;
            } 

			$criteria->addInCondition('sales1', $arr  , "AND");
			
				$criteria->compare('id',$this->id);
		$criteria->compare('date',$this->date);
		$criteria->compare('time',$this->time);
		$criteria->compare('unit_id',$this->unit_id);
		$criteria->compare('name',$this->name);
		$criteria->compare('lead_id',$this->lead_id);
		$criteria->compare('phone',$this->phone);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('tree_id',$this->tree_id);
		$criteria->compare('delivery_date',$this->delivery_date);
		$criteria->compare('unit_price',$this->unit_price);
		$criteria->compare('price_per_m',$this->price_per_m);
		$criteria->compare('details',$this->details);
		$criteria->compare('address',$this->address);
		$criteria->compare('id_card',$this->id_card);
		$criteria->compare('amount_paid',$this->amount_paid);
		$criteria->compare('payment_method',$this->payment_method);
		$criteria->compare('file',$this->file);
		$criteria->compare('close',$this->close);	
        		$criteria->compare('con_date',$this->con_date,true);		

        
	
        
        //$criteria->condition .= "file IS NOT NULL";

			
      

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,'defaultOrder'=>'id ASC', 
		));
	}
	
	
	
	
		public function res()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
      
        
        
        
        $criteria = new CDbCriteria();
        $criteria->order = 'id DESC';
        //$criteria->condition = "quotation IS NULL ";
        $criteria->condition = "quotation IS NULL AND confirm IS NULL AND cancel IS NULL";
        
        
		$criteria->compare('id',$this->id);
		$criteria->compare('date',$this->date);
		$criteria->compare('time',$this->time);
		$criteria->compare('unit_id',$this->unit_id);
		$criteria->compare('name',$this->name);
		$criteria->compare('lead_id',$this->lead_id);
		$criteria->compare('phone',$this->phone);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('tree_id',$this->tree_id);
		$criteria->compare('delivery_date',$this->delivery_date);
		$criteria->compare('unit_price',$this->unit_price);
		$criteria->compare('price_per_m',$this->price_per_m);
		$criteria->compare('details',$this->details);
		$criteria->compare('address',$this->address);
		$criteria->compare('id_card',$this->id_card);
		$criteria->compare('amount_paid',$this->amount_paid);
		$criteria->compare('payment_method',$this->payment_method);
		$criteria->compare('file',$this->file);
		$criteria->compare('close',$this->close);	
        		$criteria->compare('con_date',$this->con_date,true);		

        
        //$criteria->condition .= "file IS NOT NULL";

			
      

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,'defaultOrder'=>'id ASC', 
		));
	}
	
	
	
	
	
	
	
		public function client($clientx)
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
      
        
        
        
        $criteria = new CDbCriteria();
        $criteria->order = 'id DESC';
       
        
        //$criteria->condition .= "file IS NOT NULL";
            $criteria->addSearchCondition('lead_id', $clientx,False, "AND");

			
      

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,'defaultOrder'=>'id ASC', 
		));
	}
	
	
	
	
	
	
	
	
	
	
	
		public function conleader()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
      
        
        
        
        $criteria = new CDbCriteria();
        //$criteria->order = 'id DESC';
        //$criteria->condition = "quotation IS NULL ";
        $criteria->condition = "quotation IS NULL AND confirm IS NOT NULL AND cancel IS NULL";
        
        
        
        $allemployee = Teamleader::model()->findAll(array( 'condition' => 'leader_id=' . $userid ,'order'=>'id DESC'  ));
            $arr=array();
            foreach($allemployee as $leader){
            $arr[]=$leader->sales_id;
            } 
			$criteria->addInCondition('sales1', $arr  , "AND");
			
        
        
		$criteria->compare('id',$this->id,true);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('unit_id',$this->unit_id);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('lead_id',$this->lead_id,true);
		$criteria->compare('phone',$this->phone,true);
		$criteria->compare('tree_id',$this->tree_id,true);
		$criteria->compare('delivery_date',$this->delivery_date,true);
		$criteria->compare('unit_price',$this->unit_price,true);
		$criteria->compare('price_per_m',$this->price_per_m,true);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('address',$this->address,true);
		$criteria->compare('id_card',$this->id_card,true);
		$criteria->compare('amount_paid',$this->amount_paid,true);
		$criteria->compare('payment_method',$this->payment_method,true);
		$criteria->compare('file',$this->file,true);
		$criteria->compare('close',$this->close,true);
		$criteria->compare('sales1',$this->sales1,true);
        $criteria->compare('request_reservation', $this->request_reservation, true);
		
				$criteria->compare('con_date',$this->con_date,true);		



    // Add filtering based on campaign_id in request_reservation
        //$criteria->condition .= "file IS NOT NULL";

			
      	
        $sort = new CSort();
        $criteria->order = Yii::app()->request->getParam('sort'); 
        $sort->attributes = array(
            'id'=>array(
                'asc'=>'id ASC',
                'desc'=>'id DESC',
            ),
            'unit_id'=>array(
                'asc'=>'unit_id ASC',
                'desc'=>'unit_id DESC',
            ),
            'name'=>array(
                'asc'=>'name ASC',
                'desc'=>'name DESC',
            ),
            'phone'=>array(
                'asc'=>'phone ASC',
                'desc'=>'phone DESC',
            ),
            'user_id'=>array(
                'asc'=>'user_id ASC',
                'desc'=>'user_id DESC',
            ),
            'sales1'=>array(
                'asc'=>'sales1 ASC',
                'desc'=>'sales1 DESC',
            ),
            '*', 
        );

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		     'sort' => $sort,
		));
	}
	
	
	
	
	
		public function con()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
      
        
        
        
        $criteria = new CDbCriteria();
        //$criteria->order = 'id DESC';
        //$criteria->condition = "quotation IS NULL ";
        $criteria->condition = "quotation IS NULL AND confirm IS NOT NULL AND cancel IS NULL";
        
        
		$criteria->compare('id',$this->id,true);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('unit_id',$this->unit_id);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('lead_id',$this->lead_id,true);
		$criteria->compare('phone',$this->phone,true);
		$criteria->compare('user_id',$this->user_id,true);
		$criteria->compare('tree_id',$this->tree_id,true);
		$criteria->compare('delivery_date',$this->delivery_date,true);
		$criteria->compare('unit_price',$this->unit_price,true);
		$criteria->compare('price_per_m',$this->price_per_m,true);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('address',$this->address,true);
		$criteria->compare('id_card',$this->id_card,true);
		$criteria->compare('amount_paid',$this->amount_paid,true);
		$criteria->compare('payment_method',$this->payment_method,true);
		$criteria->compare('file',$this->file,true);
		$criteria->compare('close',$this->close,true);
		$criteria->compare('sales1',$this->sales1,true);
        $criteria->compare('request_reservation', $this->request_reservation, true);
		
				$criteria->compare('con_date',$this->con_date,true);		



    // Add filtering based on campaign_id in request_reservation
        //$criteria->condition .= "file IS NOT NULL";

			
      	
        $sort = new CSort();
        $criteria->order = Yii::app()->request->getParam('sort'); 
        $sort->attributes = array(
            'id'=>array(
                'asc'=>'id ASC',
                'desc'=>'id DESC',
            ),
            'unit_id'=>array(
                'asc'=>'unit_id ASC',
                'desc'=>'unit_id DESC',
            ),
            'name'=>array(
                'asc'=>'name ASC',
                'desc'=>'name DESC',
            ),
            'phone'=>array(
                'asc'=>'phone ASC',
                'desc'=>'phone DESC',
            ),
            'user_id'=>array(
                'asc'=>'user_id ASC',
                'desc'=>'user_id DESC',
            ),
            'sales1'=>array(
                'asc'=>'sales1 ASC',
                'desc'=>'sales1 DESC',
            ),
            '*', 
        );

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		     'sort' => $sort,
		));
	}
	
	
	
	
	

public function unit($unit)
{
// @todo Please modify the following code to remove attributes that should not be searched.
//var_dump($unit);exit;
$criteria=new CDbCriteria;
//$unit=12;
$criteria->addSearchCondition('unit_id', $unit,False, "AND");






return new CActiveDataProvider(get_class($this), array(
'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
'criteria'=>$criteria,
));

return new CActiveDataProvider($this, array(
'criteria'=>$criteria,
));
}
	
	
	
	
	
	
	
	
	
	
	
	

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Reservation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
