<?php

/**
 * This is the model class for table "service_payment".
 *
 * The followings are the available columns in table 'service_payment':
 * @property integer $id
 * @property integer $user_id
 * @property integer $secret
 * @property string $title
 * @property integer $company_id
 * @property string $date
 * @property string $time
 * @property string $details
 * @property integer $price
 * @property integer $payment_method
 * @property integer $approve
 */
class ServicePayment extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'service_payment';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, secret, title, company_id, date, time, details, price', 'required'),
			array('user_id, secret, company_id, price, payment_method, approve', 'numerical', 'integerOnly'=>true),
			array('title', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, secret, title, company_id, date, time, details, price, payment_method, approve', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'secret' => 'Secret',
			'title' => 'Title',
			'company_id' => 'Company',
			'date' => 'Date',
			'time' => 'Time',
			'details' => 'Details',
			'price' => 'Price',
			'payment_method' => 'Payment Method',
			'approve' => 'Approve',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('secret',$this->secret);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('company_id',$this->company_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('price',$this->price);
		$criteria->compare('payment_method',$this->payment_method);
		$criteria->compare('approve',$this->approve);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ServicePayment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
