<?php

/**
 * This is the model class for table "strategy".
 *
 * The followings are the available columns in table 'strategy':
 * @property integer $id
 * @property integer $user_id
 * @property string $date
 * @property string $time
 * @property integer $expected_cost
 * @property integer $paid
 * @property integer $expected_leads
 * @property integer $leads
 * @property string $details
 * @property string $start_date
 * @property string $end_date
 * @property integer $status
 * @property integer $approval
 * @property integer $user_approval
 * @property string $date_approval
 * @property string $time_approval
 * @property integer $hidden
 * @property integer $secert
 */
class Strategy extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'strategy';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, date, time, details, start_date, end_date, status, hidden, secert', 'required'),
			array('user_id, expected_cost, paid, expected_leads, leads, status,status_report,platform_report,city_report,monthly_report,daily_report,company_id, approval, user_approval, hidden, secert,strategy_id,expected_contract,expected_cost_per_lead,visit_percentage,contract_percentage,av_of_unit_price', 'numerical', 'integerOnly'=>true),
			array('date_approval, time_approval', 'safe'),
			
			array( 'details', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'expected_leads', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'expected_cost', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'paid', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),

			
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, date, time, expected_cost, paid, expected_leads,status_report,platform_report,city_report,monthly_report,daily_report,company_id,company_email, leads, details, start_date, end_date, status, approval, user_approval, date_approval, time_approval, hidden, secert, strategy_id ,expected_contract ,expected_cost_per_lead ,visit_percentage ,contract_percentage ,av_of_unit_price', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
				'employee'    => array(self::BELONGS_TO, 'User',    'user_id'),
				'company'    => array(self::BELONGS_TO, 'Company',    'company_id'),

		
		
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'expected_cost' => 'Expected Cost',
			'paid' => 'Paid',
			'expected_leads' => 'Expected Leads',
			'leads' => 'Leads',
			'details' => 'Details',
			'start_date' => 'Start Date',
			'end_date' => 'End Date',
			'status' => 'Status',
			'approval' => 'Approval',
			'user_approval' => 'User Approval',
			'date_approval' => 'Date Approval',
			'time_approval' => 'Time Approval',
			'hidden' => 'Hidden',
			'status_report' => 'Status report',
			'platform_report' => 'Platform report',
			'company_id' => 'Company id',
			'company_email' => 'company email',
			'monthly_report' => 'monthly report',
			'city_report' => 'city report',
			'daily_report' => 'daily report',
			'secert' => 'Secert',
			'strategy_id' => 'Strategy Id',
			'expected_cost_per_lead' => 'Expected Cost Per Lead',
			'visit_percentage' => 'Visit Percentage',
			'contract_percentage' => 'Contract Percentage',
			'av_of_unit_price' => 'Average of Unit Price',
			
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;
$visible=1;
		$criteria->compare('id',$this->id);
		$criteria->addSearchCondition('hidden', $visible, false);

		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('expected_cost',$this->expected_cost);
		$criteria->compare('paid',$this->paid);
		$criteria->compare('expected_leads',$this->expected_leads);
		$criteria->compare('leads',$this->leads);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('company_email',$this->company_email,true);
		$criteria->compare('start_date',$this->start_date,true);
		$criteria->compare('status_report',$this->status_report,true);
		$criteria->compare('platform_report',$this->platform_report,true);
		$criteria->compare('company_id',$this->company_id,true);
		$criteria->compare('end_date',$this->end_date,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('approval',$this->approval);
		$criteria->compare('user_approval',$this->user_approval);
		$criteria->compare('date_approval',$this->date_approval,true);
		$criteria->compare('time_approval',$this->time_approval,true);
		$criteria->compare('hidden',$this->hidden);
		$criteria->compare('city_report',$this->city_report);
		$criteria->compare('monthly_report',$this->monthly_report);
		$criteria->compare('daily_report',$this->daily_report);
		$criteria->compare('secert',$this->secert);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}


			
	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Strategy the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
