<?php

/**
 * This is the model class for table "type_buliding".
 *
 * The followings are the available columns in table 'type_buliding':
 * @property integer $id
 * @property string $title
 * @property integer $user_id
 * @property string $date
 * @property string $time
 * @property string $secert
 * @property integer $hidden
 */
class TypeBuliding extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'type_buliding';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('title, user_id, date, time, secert, hidden', 'required'),
			array('user_id, hidden, typeforeng,parent_id', 'numerical', 'integerOnly'=>true),
			array('title,symbol', 'length', 'max'=>255),
			array('secert', 'length', 'max'=>11),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, title, user_id, date, time, secert, hidden, typeforeng,parent_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		
		'employee'    => array(self::BELONGS_TO, 'User',    'user_id'),
		
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'title' => 'Title',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'secert' => 'Secert',
			'hidden' => 'Hidden',
			'typeforeng' => 'Typeforeng',
			'parent_id' => 'Parent',

		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('secert',$this->secert,true);
		$criteria->compare('hidden',$this->hidden);
		$criteria->compare('typeforeng',$this->typeforeng);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return TypeBuliding the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
