<?php

class Units extends CActiveRecord
{

	public function tableName()
	{
		return 'units';
	}
	
    public $min_price;
    public $max_price;
    public $min_size_indoor;
    public $max_size_indoor;
    public $min_size_outdoor;
    public $max_size_outdoor;



	public function rules()
	{
		return array(
            array('code','unique'),
            array('user_id, date, time,  status, secert, hidden', 'required'),
            array('user_id, building_id, projects_id, floor_id, type_unit, number_rooms, number_baths, number_terace, number_kitchen, roof, garden, parking, number_receptions, master_rooms, studio, closet, neighboring_area, area_area, activity, status, hidden, stage_id, duplex, duplex_id, booking, lead_id, sort, type, owners_id, area, typeofunit, Finishing, paying, compound, evaluation, fromplatform, toilets, internet, conditioning, firealarm, securitycameras, securityguards, additionalpositions, restaurants, bankingservices, extinguishingnetwork, owning_type, place_status, insurance, land_type, place_num, governorate, city, region, indoor, outdoor, sales, teamleader, x, sales2, teamleader2, x2, soldprice, indirect, eoicode,unit_id_resale', 'numerical', 'integerOnly'=>true),
            array('size_unit_cross, percentage_unit, size_unit_net, roof_size, percentage_roof, roof_size_net, garden_size, percentage_garden, garden_size_net, parking_slots, percentage_parking, parking_slots_net, percentage_studio, studio_size, studio_size_net, closet_size, percentage_closet, closet_size_net, number_area, price, area_sold, studio_sold, parking_sold, store_sold, roof_sold, garden_sold, commission, indoor_size, indoor_price, indoor_total_price, outdoor_size, outdoor_price, outdoor_total_price, furniture_price, maintenance_deposit, phase_discount, size_unit_cross_outdoor, percentage_unit_outdoor, size_unit_net_outdoor, area_sold_outdoor,mandatoryrent', 'numerical'),
            array('code, title, roof_id, garden_id, parking_id, studio_id, closet_id, secert, receipt, place, nplace, commission_months, rent_reason, view, activity_type, gbalon, factory_num, payed_perc, money_left, offer, deposit, image, floor_plan, owner_name, tel, interface, plot_type, payment, installments, total, client, idcard, resdate, holddate, solddate, donedate, downpayment, downpaymenttype, instyears, insttype, contractstage, source, brokername, brokersales, clienttel, clientjob, clientemail, clientaddress, correspondence, birthdate, maintenanceafterdisc, localorglobal, unittype, buildingype, maintenance ,clubhouse_size,clubhouse_price,totalbefordisc,level,plot_area,bua_area,ground_area,first_area,roof_area,pen_house_area', 'length', 'max'=>255),
            array('delivery_date, details, address, dateofcontract, checkdate, resv_date, contract_date, cancel_date', 'safe'),
            array('id, code, title, user_id, date, time, building_id, projects_id, floor_id, type_unit, size_unit_cross, percentage_unit, size_unit_net, delivery_date, number_rooms, number_baths, number_terace, number_kitchen, roof, roof_size, percentage_roof, roof_size_net, roof_id, garden, garden_size, percentage_garden, garden_size_net, garden_id, parking, parking_slots, percentage_parking, parking_slots_net, parking_id, number_receptions, master_rooms, studio, percentage_studio, studio_size, studio_size_net, studio_id, closet, closet_size, closet_id, percentage_closet, closet_size_net, number_area, neighboring_area, area_area, details, activity, status, secert, hidden, price, stage_id, area_sold, studio_sold, parking_sold, store_sold, roof_sold, garden_sold, duplex, duplex_id, booking, lead_id, sort, type, owners_id, area, address, typeofunit, receipt, Finishing, paying, compound, commission, evaluation, fromplatform, toilets, internet, conditioning, firealarm, securitycameras, securityguards, additionalpositions, restaurants, bankingservices, extinguishingnetwork, indoor_size, indoor_price, indoor_total_price, outdoor_size, outdoor_price, outdoor_total_price, furniture_price, dateofcontract, place, nplace, checkdate, owning_type, place_status, commission_months, insurance, rent_reason, view, activity_type, land_type, gbalon, factory_num, place_num, payed_perc, money_left, offer, deposit, image, floor_plan, owner_name, tel, interface, plot_type, governorate, city, region, payment, installments, total, maintenance_deposit, phase_discount, size_unit_cross_outdoor, percentage_unit_outdoor, size_unit_net_outdoor, area_sold_outdoor, indoor, outdoor, client, sales, teamleader, x, sales2, teamleader2, x2, idcard, resdate, holddate, solddate, donedate, soldprice, downpayment, downpaymenttype, instyears, insttype, contractstage, source, indirect, brokername, brokersales, eoicode, clienttel, clientjob, clientemail, clientaddress, correspondence, birthdate, maintenanceafterdisc, resv_date, contract_date, cancel_date, localorglobal,mandatoryrent, unittype, buildingype, maintenance ,clubhouse_size,clubhouse_price,unit_id_resale,level', 'safe', 'on'=>'search'),
            array('code, booking, min_price, max_price, min_size_indoor, max_size_indoor, min_size_outdoor, max_size_outdoor', 'safe', 'on' => 'searchdataanalysisunit'),
		);
	}

	public function relations()
	{
		return array(     
            'project'    => array(self::BELONGS_TO, 'Projects',    'projects_id'),
            'building'    => array(self::BELONGS_TO, 'Building',    'building_id'),
            'duplexdata'    => array(self::BELONGS_TO, 'Units',    'duplex_id'),
            'floor'    => array(self::BELONGS_TO, 'Floor',    'floor_id'),
            'employee'    => array(self::BELONGS_TO, 'User',    'user_id'),
            'buildingtype'    => array(self::BELONGS_TO, 'TypeBuliding',    'type_buliding'),
            'xactivity'    => array(self::BELONGS_TO, 'TypeBuliding',    'activity'),
		);
	}

	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'code' => 'Code',
			'title' => 'Title',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'building_id' => 'Building',
			'projects_id' => 'Projects',
			'floor_id' => 'Floor',
			'type_unit' => 'Type Unit',
			'size_unit_cross' => 'Size Unit Cross',
			'percentage_unit' => 'Percentage Unit',
			'size_unit_net' => 'Size Unit Net',
			'delivery_date' => 'Delivery Date',
			'number_rooms' => 'Number Rooms',
			'number_baths' => 'Number Baths',
			'number_terace' => 'Number Terace',
			'number_kitchen' => 'Number Kitchen',
			'roof' => 'Roof',
			'roof_size' => 'Roof Size',
			'percentage_roof' => 'Percentage Roof',
			'roof_size_net' => 'Roof Size Net',
			'roof_id' => 'Roof',
			'garden' => 'Garden',
			'garden_size' => 'Garden Size',
			'percentage_garden' => 'Percentage Garden',
			'garden_size_net' => 'Garden Size Net',
			'garden_id' => 'Garden',
			'parking' => 'Parking',
			'parking_slots' => 'Parking Slots',
			'percentage_parking' => 'Percentage Parking',
			'parking_slots_net' => 'Parking Slots Net',
			'parking_id' => 'Parking',
			'number_receptions' => 'Number Receptions',
			'master_rooms' => 'Master Rooms',
			'studio' => 'Studio',
			'percentage_studio' => 'Percentage Studio',
			'studio_size' => 'Studio Size',
			'studio_size_net' => 'Studio Size Net',
			'studio_id' => 'Studio',
			'closet' => 'Closet',
			'closet_size' => 'Closet Size',
			'closet_id' => 'Closet',
			'percentage_closet' => 'Percentage Closet',
			'closet_size_net' => 'Closet Size Net',
			'number_area' => 'Number Area',
			'neighboring_area' => 'Neighboring Area',
			'area_area' => 'Area Area',
			'details' => 'Details',
			'activity' => 'Activity',
			'status' => 'Status',
			'secert' => 'Secert',
			'hidden' => 'Hidden',
			'price' => 'Price',
			'stage_id' => 'Stage',
			'area_sold' => 'Area Sold',
			'studio_sold' => 'Studio Sold',
			'parking_sold' => 'Parking Sold',
			'store_sold' => 'Store Sold',
			'roof_sold' => 'Roof Sold',
			'garden_sold' => 'Garden Sold',
			'duplex' => 'Duplex',
			'duplex_id' => 'Duplex',
			'booking' => 'Booking',
			'lead_id' => 'Lead',
			'sort' => 'Sort',
			'type' => 'Type',
			'owners_id' => 'Owners',
			'area' => 'Area',
			'address' => 'Address',
			'typeofunit' => 'Typeofunit',
			'receipt' => 'Receipt',
			'Finishing' => 'Finishing',
			'paying' => 'Paying',
			'compound' => 'Compound',
			'commission' => 'Commission',
			'evaluation' => 'Evaluation',
			'fromplatform' => 'Fromplatform',
			'toilets' => 'Toilets',
			'internet' => 'Internet',
			'conditioning' => 'Conditioning',
			'firealarm' => 'Firealarm',
			'securitycameras' => 'Securitycameras',
			'securityguards' => 'Securityguards',
			'additionalpositions' => 'Additionalpositions',
			'restaurants' => 'Restaurants',
			'bankingservices' => 'Bankingservices',
			'extinguishingnetwork' => 'Extinguishingnetwork',
			'indoor_size' => 'Indoor Size',
			'indoor_price' => 'Indoor Price',
			'indoor_total_price' => 'Indoor Total Price',
			'outdoor_size' => 'Outdoor Size',
			'outdoor_price' => 'Outdoor Price',
			'outdoor_total_price' => 'Outdoor Total Price',
			'furniture_price' => 'Furniture Price',
			'dateofcontract' => 'Dateofcontract',
			'place' => 'Place',
			'nplace' => 'Nplace',
			'checkdate' => 'Checkdate',
			'owning_type' => 'Owning Type',
			'place_status' => 'Place Status',
			'commission_months' => 'Commission Months',
			'insurance' => 'Insurance',
			'rent_reason' => 'Rent Reason',
			'view' => 'View',
			'activity_type' => 'Activity Type',
			'land_type' => 'Land Type',
			'gbalon' => 'Gbalon',
			'factory_num' => 'Factory Num',
			'place_num' => 'Place Num',
			'payed_perc' => 'Payed Perc',
			'money_left' => 'Money Left',
			'offer' => 'Offer',
			'deposit' => 'Deposit',
			'image' => 'Image',
			'floor_plan' => 'Floor Plan',
			'owner_name' => 'Owner Name',
			'tel' => 'Tel',
			'interface' => 'Interface',
			'plot_type' => 'Plot Type',
			'governorate' => 'Governorate',
			'city' => 'City',
			'region' => 'Region',
			'payment' => 'Payment',
			'installments' => 'Installments',
			'total' => 'Total',
			'maintenance_deposit' => 'Maintenance Deposit',
			'phase_discount' => 'Phase Discount',
			'size_unit_cross_outdoor' => 'Size Unit Cross Outdoor',
			'percentage_unit_outdoor' => 'Percentage Unit Outdoor',
			'size_unit_net_outdoor' => 'Size Unit Net Outdoor',
			'area_sold_outdoor' => 'Area Sold Outdoor',
			'indoor' => 'Indoor',
			'outdoor' => 'Outdoor',
			'client' => 'Client',
			'sales' => 'Sales',
			'teamleader' => 'Teamleader',
			'x' => 'X',
			'sales2' => 'Sales2',
			'teamleader2' => 'Teamleader2',
			'x2' => 'X2',
			'idcard' => 'Idcard',
			'resdate' => 'Resdate',
			'holddate' => 'Holddate',
			'solddate' => 'Solddate',
			'donedate' => 'Donedate',
			'soldprice' => 'Soldprice',
			'downpayment' => 'Downpayment',
			'downpaymenttype' => 'Downpaymenttype',
			'instyears' => 'Instyears',
			'insttype' => 'Insttype',
			'contractstage' => 'Contractstage',
			'source' => 'Source',
			'indirect' => 'Indirect',
			'brokername' => 'Brokername',
			'brokersales' => 'Brokersales',
			'eoicode' => 'Eoicode',
			'clienttel' => 'Clienttel',
			'clientjob' => 'Clientjob',
			'clientemail' => 'Clientemail',
			'clientaddress' => 'Clientaddress',
			'correspondence' => 'Correspondence',
			'birthdate' => 'Birthdate',
			'maintenanceafterdisc' => 'Maintenanceafterdisc',
			'localorglobal' => 'localorglobal',
			'mandatoryrent' => 'Mandatoryrent',
		);
	}
	 
    public function searchdataanalysisunit() {
        $criteria = new CDbCriteria;
    
        if (!empty($this->code)) {
            Yii::log("Filtering by code: " . $this->code, 'info');
            $criteria->compare('code', $this->code, true);
        }
        if (!empty($this->booking)) {
            Yii::log("Filtering by booking: " . $this->booking, 'info');
            $criteria->compare('booking', $this->booking);
        }
        
        if (!empty($this->min_price)) {
            Yii::log("Filtering by min_price: " . $this->min_price, 'info');
            $criteria->addCondition('total >= :minPrice');
            $criteria->params[':minPrice'] = (int)$this->min_price;
        }
        if (!empty($this->max_price)) {
            Yii::log("Filtering by max_price: " . $this->max_price, 'info');
            $criteria->addCondition('total <= :maxPrice');
            $criteria->params[':maxPrice'] = (int)$this->max_price;
        }
        
        if (!empty($this->min_size_indoor)) {
            Yii::log("Filtering by min_size_indoor: " . $this->min_size_indoor, 'info');
            $criteria->addCondition('indoor_size >= :minSizeIndoor');
            $criteria->params[':minSizeIndoor'] = (int)$this->min_size_indoor;
        }
        if (!empty($this->max_size_indoor)) {
            Yii::log("Filtering by max_size_indoor: " . $this->max_size_indoor, 'info');
            $criteria->addCondition('indoor_size <= :maxSizeIndoor');
            $criteria->params[':maxSizeIndoor'] = (int)$this->max_size_indoor;
        }
        
        if (!empty($this->min_size_outdoor)) {
            Yii::log("Filtering by min_size_outdoor: " . $this->min_size_outdoor, 'info');
            $criteria->addCondition('outdoor_size >= :minSizeOutdoor');
            $criteria->params[':minSizeOutdoor'] = (int)$this->min_size_outdoor;
        }
        if (!empty($this->max_size_outdoor)) {
            Yii::log("Filtering by max_size_outdoor: " . $this->max_size_outdoor, 'info');
            $criteria->addCondition('outdoor_size <= :maxSizeOutdoor');
            $criteria->params[':maxSizeOutdoor'] = (int)$this->max_size_outdoor;
        }
    
        Yii::log("Model Criteria Params: " . print_r($criteria->params, true), 'info');
        $dataProvider = new CActiveDataProvider($this, array(
            'criteria' => $criteria,
    		'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
        ));
    
        Yii::log("Filtered Item Count: " . $dataProvider->getTotalItemCount(), 'info');
        return $dataProvider;
    }

	public function search()
	{
		$criteria=new CDbCriteria;
        if(!empty($_REQUEST['building']) ){
                $criteria->addSearchCondition('building_id', $_REQUEST['building'],False, "AND");
        }
		$criteria->compare('code',$this->code);
		$criteria->compare('date',$this->date);
		$criteria->compare('time',$this->time);
		$criteria->compare('building_id',$this->building_id);
		$criteria->compare('activity',$this->activity);
		$criteria->compare('floor_id',$this->floor_id);
		$criteria->compare('booking',$this->booking);
		$criteria->compare('indoor_size',$this->indoor_size);
		$criteria->compare('outdoor_size',$this->outdoor_size);
		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	public function searchunits()
	{
        $userid=Yii::app()->user->id;
		if(isset($_REQUEST['search'])){
			$criteria = new CDbCriteria();
			$criteria->order = 'code ASC';
			$userid=Yii::app()->user->id;
    	    $user=User::model()->findByPk($userid);
    	    if($user->salesmanger == 1 OR $user->customerservice == 1){}else{
                $criteria->condition = "booking IS NULL ";
    	    }
			$criteria->addSearchCondition('hidden', 1,false, "AND");
			if(!empty($_REQUEST['date']))
			$criteria->addSearchCondition('date', $_REQUEST['date'],false, "AND");
			if(!empty($_REQUEST['ddate']))
			$criteria->addSearchCondition('delivery_date', $_REQUEST['ddate'],false, "AND");
			if(!empty($_REQUEST['cdate']))
			$criteria->addSearchCondition('dateofcontract', $_REQUEST['cdate'],false, "AND");
            if (!empty($_REQUEST['indoor_from']) || !empty($_REQUEST['indoor_to'])) {
                    $indoorFrom = !empty($_REQUEST['indoor_from']) ? (int)$_REQUEST['indoor_from'] : null;
                    $indoorTo = !empty($_REQUEST['indoor_to']) ? (int)$_REQUEST['indoor_to'] : null;
                if ($indoorFrom !== null && $indoorTo !== null) {
                    $criteria->addBetweenCondition('indoor_size', $indoorFrom, $indoorTo, "AND");
                } elseif ($indoorFrom !== null) {
                    $criteria->addCondition('indoor_size >= :indoorFrom', "AND");
                    $criteria->params[':indoorFrom'] = $indoorFrom;
                } elseif ($indoorTo !== null) {
                    $criteria->addCondition('indoor_size <= :indoorTo', "AND");
                    $criteria->params[':indoorTo'] = $indoorTo;
                }
            }
            if (!empty($_REQUEST['outdoor_from']) || !empty($_REQUEST['outdoor_to'])) {
                $outdoorFrom = !empty($_REQUEST['outdoor_from']) ? (int)$_REQUEST['outdoor_from'] : null;
                $outdoorTo = !empty($_REQUEST['outdoor_to']) ? (int)$_REQUEST['outdoor_to'] : null;
                if ($outdoorFrom !== null && $outdoorTo !== null) {
                    $criteria->addBetweenCondition('outdoor_size', $outdoorFrom, $outdoorTo, "AND");
                } elseif ($outdoorFrom !== null) {
                    $criteria->addCondition('outdoor_size >= :outdoorFrom', "AND");
                    $criteria->params[':outdoorFrom'] = $outdoorFrom;
                } elseif ($outdoorTo !== null) {
                    $criteria->addCondition('outdoor_size <= :outdoorTo', "AND");
                    $criteria->params[':outdoorTo'] = $outdoorTo;
                }
            }
            if (!empty($_REQUEST['price_from']) || !empty($_REQUEST['price_to'])) {
                $priceFrom = !empty($_REQUEST['price_from']) ? (int)$_REQUEST['price_from'] : null;
                $priceTo = !empty($_REQUEST['price_to']) ? (int)$_REQUEST['price_to'] : null;
                if ($priceFrom !== null && $priceTo !== null) {
                    $criteria->addBetweenCondition('total', $priceFrom, $priceTo, "AND");
                } elseif ($priceFrom !== null) {
                    $criteria->addCondition('total >= :priceFrom', "AND");
                    $criteria->params[':priceFrom'] = $priceFrom;
                } elseif ($priceTo !== null) {
                    $criteria->addCondition('total <= :priceTo', "AND");
                    $criteria->params[':priceTo'] = $priceTo;
                }
            }
            if($_REQUEST['booking']==404){}
            elseif(!empty($_REQUEST['booking'])AND $_REQUEST['booking']!=0 ){
                $criteria->addSearchCondition('booking', $_REQUEST['booking'],false, "AND");
            }elseif( $_REQUEST['booking']==0){
                $criteria->AddCondition ( "booking IS NULL ");
            }
            if(!empty($_REQUEST['floor_id']))
                $criteria->addSearchCondition('floor_id', $_REQUEST['floor_id'],false, "AND");
            if(!empty($_REQUEST['code']))
                $criteria->addSearchCondition('code', $_REQUEST['code'],true, "AND");
            if(!empty($_REQUEST['activity']))
                $criteria->addSearchCondition('activity', $_REQUEST['activity'],false, "AND");
            if(sizeOf((array)$_REQUEST['projects'])>1){
                $intArray1 = array_map(
                    function($value1){ return (int)$value1; },
                    $_REQUEST['projects']
                );
                $criteria->addInCondition('projects_id', $intArray1  , "AND");
            }
            if(sizeOf((array)$_REQUEST['building'])>1){
                $intArray3 = array_map(
                    function($value3){ return (int)$value3; },
                    $_REQUEST['building']
                );
                $criteria->addInCondition('building_id', $intArray3  , "AND");
            }
            if(!empty($_REQUEST['Finishing']))
            $criteria->addSearchCondition('Finishing', $_REQUEST['Finishing'],false, "AND");  
            $criteria->select = "id,user_id,booking,title,indoor_price,outdoor_price,total,code,type_unit,floor_id,building_id,activity,indoor_size,outdoor_size,lead_id,client,sales,teamleader,details,resv_date,contract_date
            ,cancel_date,soldprice,downpayment,installments,instyears,totalbefordisc,level";
            $visible = 1;
            $alltypebuliding = TypeBuliding::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
            $allfloor = Floor::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
            $allunits = Units::model()->findAll($criteria);
            $total = Count($allunits);
            $userid=Yii::app()->user->id;
        }
        
        $sort = new CSort();
        $criteria->order = Yii::app()->request->getParam('sort', 'id DESC');
    $sort->attributes = array(
        'id' => array(
            'asc' => 'id ASC',
            'desc' => 'id DESC',
        ),
        'code' => array(
            'asc' => 'code ASC',
            'desc' => 'code DESC',
        ),
        'floor_id' => array(
            'asc' => 'floor_id ASC',
            'desc' => 'floor_id DESC',
        ),
        'indoor_size' => array(
            'asc' => 'indoor_size ASC',
            'desc' => 'indoor_size DESC',
        ),
        'indoor_price' => array(
            'asc' => 'indoor_price ASC',
            'desc' => 'indoor_price DESC',
        ),
        'outdoor_size' => array(
            'asc' => 'outdoor_size ASC',
            'desc' => 'outdoor_size DESC',
        ),
        'outdoor_price' => array(
            'asc' => 'outdoor_price ASC',
            'desc' => 'outdoor_price DESC',
        ),
        'total' => array(
            'asc' => 'total ASC',
            'desc' => 'total DESC',
        ),
        'totalbefordisc' => array(
            'asc' => 'totalbefordisc ASC',
            'desc' => 'totalbefordisc DESC',
        ),
    );
		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));
		

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		     'sort' => $sort,
		));
	}	
	
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}



