<?php

/**
 * This is the model class for table "vacationsbalance".
 *
 * The followings are the available columns in table 'vacationsbalance':
 * @property integer $id
 * @property string $date
 * @property string $time
 * @property string $title
 * @property integer $type
 * @property integer $noofdays
 * @property integer $gender
 * @property integer $accepted
 * @property integer $rejected
 * @property integer $user_id
 * @property integer $confirm_id
 * @property integer $manager_id
 * @property integer $employee_id
 */
class Vacationsbalance extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vacationsbalance';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('date, time, title, type, noofdays, gender, user_id, employee_id', 'required'),
			array('type, noofdays, gender, accepted, rejected, user_id, confirm_id, manager_id, employee_id', 'numerical', 'integerOnly'=>true),
			array('title,vac_date', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, date, time, title, type, noofdays, gender, accepted, rejected, user_id, confirm_id, manager_id, employee_id,vac_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'date' => 'Date',
			'time' => 'Time',
			'title' => 'Reason',
			'type' => 'Type',
			'noofdays' => 'Noofdays',
			'gender' => 'Gender',
			'accepted' => 'Accepted',
			'rejected' => 'Rejected',
			'user_id' => 'User',
			'confirm_id' => 'Confirm',
			'manager_id' => 'Manager',
			'employee_id' => 'Employee',
			'vac_date' => 'Vac date',

			
			
			
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('type',$this->type);
		$criteria->compare('noofdays',$this->noofdays);
		$criteria->compare('gender',$this->gender);
		$criteria->compare('accepted',$this->accepted);
		$criteria->compare('rejected',$this->rejected);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('confirm_id',$this->confirm_id);
		$criteria->compare('manager_id',$this->manager_id);
		$criteria->compare('employee_id',$this->employee_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Vacationsbalance the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
