<?php

/**
 * This is the model class for table "vtiger_modcomments".
 *
 * The followings are the available columns in table 'vtiger_modcomments':
 * @property integer $modcommentsid
 * @property string $commentcontent
 * @property integer $related_to
 * @property integer $parent_comments
 * @property integer $customer
 * @property integer $userid
 * @property string $reasontoedit
 * @property integer $is_private
 * @property string $filename
 * @property integer $related_email_id
 */
class VtigerModcomments extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vtiger_modcomments';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('modcommentsid, related_to, parent_comments, customer, userid, is_private, related_email_id', 'numerical', 'integerOnly'=>true),
			array('reasontoedit', 'length', 'max'=>100),
			array('filename', 'length', 'max'=>255),
			array('commentcontent', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('modcommentsid, commentcontent, related_to, parent_comments, customer, userid, reasontoedit, is_private, filename, related_email_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'modcommentsid' => 'Modcommentsid',
			'commentcontent' => 'Commentcontent',
			'related_to' => 'Related To',
			'parent_comments' => 'Parent Comments',
			'customer' => 'Customer',
			'userid' => 'Userid',
			'reasontoedit' => 'Reasontoedit',
			'is_private' => 'Is Private',
			'filename' => 'Filename',
			'related_email_id' => 'Related Email',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('modcommentsid',$this->modcommentsid);
		$criteria->compare('commentcontent',$this->commentcontent,true);
		$criteria->compare('related_to',$this->related_to);
		$criteria->compare('parent_comments',$this->parent_comments);
		$criteria->compare('customer',$this->customer);
		$criteria->compare('userid',$this->userid);
		$criteria->compare('reasontoedit',$this->reasontoedit,true);
		$criteria->compare('is_private',$this->is_private);
		$criteria->compare('filename',$this->filename,true);
		$criteria->compare('related_email_id',$this->related_email_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return VtigerModcomments the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
