<?php

/**
 * This is the model class for table "units".
 *
 * The followings are the available columns in table 'units':
 * @property integer $id
 * @property string $code
 * @property string $title
 * @property integer $user_id
 * @property string $date
 * @property string $time
 * @property integer $building_id
 * @property integer $projects_id
 * @property integer $floor_id
 * @property integer $type_unit
 * @property double $size_unit_cross
 * @property double $percentage_unit
 * @property double $size_unit_net
 * @property string $delivery_date
 * @property integer $number_rooms
 * @property integer $number_baths
 * @property integer $number_terace
 * @property integer $number_kitchen
 * @property integer $roof
 * @property double $roof_size
 * @property double $percentage_roof
 * @property double $roof_size_net
 * @property string $roof_id
 * @property integer $garden
 * @property double $garden_size
 * @property double $percentage_garden
 * @property double $garden_size_net
 * @property string $garden_id
 * @property integer $parking
 * @property double $parking_slots
 * @property double $percentage_parking
 * @property double $parking_slots_net
 * @property string $parking_id
 * @property integer $number_receptions
 * @property integer $master_rooms
 * @property integer $studio
 * @property double $percentage_studio
 * @property double $studio_size
 * @property double $studio_size_net
 * @property string $studio_id
 * @property integer $closet
 * @property double $closet_size
 * @property string $closet_id
 * @property double $percentage_closet
 * @property double $closet_size_net
 * @property double $number_area
 * @property integer $neighboring_area
 * @property integer $area_area
 * @property string $details
 * @property integer $activity
 * @property integer $status
 * @property string $secert
 * @property integer $hidden
 * @property double $price
 * @property integer $stage_id
 * @property double $area_sold
 * @property double $studio_sold
 * @property double $parking_sold
 * @property double $store_sold
 * @property double $roof_sold
 * @property double $garden_sold
 * @property integer $duplex
 * @property integer $duplex_id
 * @property integer $booking
 * @property integer $sort
 * @property integer $type
 * @property integer $owners_id
 * @property integer $area
 * @property string $address
 */
class Units extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'units';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, date, time, building_id, projects_id, delivery_date, status, secert, hidden', 'required'),
			array('user_id, building_id, projects_id, floor_id, type_unit, number_rooms, number_baths, number_terace, number_kitchen, roof, garden, parking, number_receptions, master_rooms, studio, closet, neighboring_area, area_area, activity, status, hidden, stage_id, duplex, duplex_id, booking, sort, type, owners_id, area', 'numerical', 'integerOnly'=>true),
			array('size_unit_cross, percentage_unit, size_unit_net, roof_size, percentage_roof, roof_size_net, garden_size, percentage_garden, garden_size_net, parking_slots, percentage_parking, parking_slots_net, percentage_studio, studio_size, studio_size_net, closet_size, percentage_closet, closet_size_net, number_area, price, area_sold, studio_sold, parking_sold, store_sold, roof_sold, garden_sold', 'numerical'),
			array('code, title, roof_id, garden_id, parking_id, studio_id, closet_id, secert', 'length', 'max'=>255),
			array('details, address', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, code, title, user_id, date, time, building_id, projects_id, floor_id, type_unit, size_unit_cross, percentage_unit, size_unit_net, delivery_date, number_rooms, number_baths, number_terace, number_kitchen, roof, roof_size, percentage_roof, roof_size_net, roof_id, garden, garden_size, percentage_garden, garden_size_net, garden_id, parking, parking_slots, percentage_parking, parking_slots_net, parking_id, number_receptions, master_rooms, studio, percentage_studio, studio_size, studio_size_net, studio_id, closet, closet_size, closet_id, percentage_closet, closet_size_net, number_area, neighboring_area, area_area, details, activity, status, secert, hidden, price, stage_id, area_sold, studio_sold, parking_sold, store_sold, roof_sold, garden_sold, duplex, duplex_id, booking, sort, type, owners_id, area, address', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    
		    
		    	'project'    => array(self::BELONGS_TO, 'Projects',    'projects_id'),
	'building'    => array(self::BELONGS_TO, 'Building',    'building_id'),
	'duplexdata'    => array(self::BELONGS_TO, 'Units',    'duplex_id'),

	'floor'    => array(self::BELONGS_TO, 'Floor',    'floor_id'),

	'employee'    => array(self::BELONGS_TO, 'User',    'user_id'),

        'buildingtype'    => array(self::BELONGS_TO, 'TypeBuliding',    'type_buliding'),
		                'xactivity'    => array(self::BELONGS_TO, 'TypeBuliding',    'activity'),		
		    
		    
		    
		    
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'code' => 'Code',
			'title' => 'Title',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'building_id' => 'Building',
			'projects_id' => 'Projects',
			'floor_id' => 'Floor',
			'type_unit' => 'Type Unit',
			'size_unit_cross' => 'Size Unit Cross',
			'percentage_unit' => 'Percentage Unit',
			'size_unit_net' => 'Size Unit Net',
			'delivery_date' => 'Delivery Date',
			'number_rooms' => 'Number Rooms',
			'number_baths' => 'Number Baths',
			'number_terace' => 'Number Terace',
			'number_kitchen' => 'Number Kitchen',
			'roof' => 'Roof',
			'roof_size' => 'Roof Size',
			'percentage_roof' => 'Percentage Roof',
			'roof_size_net' => 'Roof Size Net',
			'roof_id' => 'Roof',
			'garden' => 'Garden',
			'garden_size' => 'Garden Size',
			'percentage_garden' => 'Percentage Garden',
			'garden_size_net' => 'Garden Size Net',
			'garden_id' => 'Garden',
			'parking' => 'Parking',
			'parking_slots' => 'Parking Slots',
			'percentage_parking' => 'Percentage Parking',
			'parking_slots_net' => 'Parking Slots Net',
			'parking_id' => 'Parking',
			'number_receptions' => 'Number Receptions',
			'master_rooms' => 'Master Rooms',
			'studio' => 'Studio',
			'percentage_studio' => 'Percentage Studio',
			'studio_size' => 'Studio Size',
			'studio_size_net' => 'Studio Size Net',
			'studio_id' => 'Studio',
			'closet' => 'Closet',
			'closet_size' => 'Closet Size',
			'closet_id' => 'Closet',
			'percentage_closet' => 'Percentage Closet',
			'closet_size_net' => 'Closet Size Net',
			'number_area' => 'Number Area',
			'neighboring_area' => 'Neighboring Area',
			'area_area' => 'Area Area',
			'details' => 'Details',
			'activity' => 'Activity',
			'status' => 'Status',
			'secert' => 'Secert',
			'hidden' => 'Hidden',
			'price' => 'Price',
			'stage_id' => 'Stage',
			'area_sold' => 'Area Sold',
			'studio_sold' => 'Studio Sold',
			'parking_sold' => 'Parking Sold',
			'store_sold' => 'Store Sold',
			'roof_sold' => 'Roof Sold',
			'garden_sold' => 'Garden Sold',
			'duplex' => 'Duplex',
			'duplex_id' => 'Duplex',
			'booking' => 'Booking',
			'sort' => 'Sort',
			'type' => 'Type',
			'owners_id' => 'Owners',
			'area' => 'Area',
			'address' => 'Address',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('code',$this->code,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('building_id',$this->building_id);
		$criteria->compare('projects_id',$this->projects_id);
		$criteria->compare('floor_id',$this->floor_id);
		$criteria->compare('type_unit',$this->type_unit);
		$criteria->compare('size_unit_cross',$this->size_unit_cross);
		$criteria->compare('percentage_unit',$this->percentage_unit);
		$criteria->compare('size_unit_net',$this->size_unit_net);
		$criteria->compare('delivery_date',$this->delivery_date,true);
		$criteria->compare('number_rooms',$this->number_rooms);
		$criteria->compare('number_baths',$this->number_baths);
		$criteria->compare('number_terace',$this->number_terace);
		$criteria->compare('number_kitchen',$this->number_kitchen);
		$criteria->compare('roof',$this->roof);
		$criteria->compare('roof_size',$this->roof_size);
		$criteria->compare('percentage_roof',$this->percentage_roof);
		$criteria->compare('roof_size_net',$this->roof_size_net);
		$criteria->compare('roof_id',$this->roof_id,true);
		$criteria->compare('garden',$this->garden);
		$criteria->compare('garden_size',$this->garden_size);
		$criteria->compare('percentage_garden',$this->percentage_garden);
		$criteria->compare('garden_size_net',$this->garden_size_net);
		$criteria->compare('garden_id',$this->garden_id,true);
		$criteria->compare('parking',$this->parking);
		$criteria->compare('parking_slots',$this->parking_slots);
		$criteria->compare('percentage_parking',$this->percentage_parking);
		$criteria->compare('parking_slots_net',$this->parking_slots_net);
		$criteria->compare('parking_id',$this->parking_id,true);
		$criteria->compare('number_receptions',$this->number_receptions);
		$criteria->compare('master_rooms',$this->master_rooms);
		$criteria->compare('studio',$this->studio);
		$criteria->compare('percentage_studio',$this->percentage_studio);
		$criteria->compare('studio_size',$this->studio_size);
		$criteria->compare('studio_size_net',$this->studio_size_net);
		$criteria->compare('studio_id',$this->studio_id,true);
		$criteria->compare('closet',$this->closet);
		$criteria->compare('closet_size',$this->closet_size);
		$criteria->compare('closet_id',$this->closet_id,true);
		$criteria->compare('percentage_closet',$this->percentage_closet);
		$criteria->compare('closet_size_net',$this->closet_size_net);
		$criteria->compare('number_area',$this->number_area);
		$criteria->compare('neighboring_area',$this->neighboring_area);
		$criteria->compare('area_area',$this->area_area);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('activity',$this->activity);
		$criteria->compare('status',$this->status);
		$criteria->compare('secert',$this->secert,true);
		$criteria->compare('hidden',$this->hidden);
		$criteria->compare('price',$this->price);
		$criteria->compare('stage_id',$this->stage_id);
		$criteria->compare('area_sold',$this->area_sold);
		$criteria->compare('studio_sold',$this->studio_sold);
		$criteria->compare('parking_sold',$this->parking_sold);
		$criteria->compare('store_sold',$this->store_sold);
		$criteria->compare('roof_sold',$this->roof_sold);
		$criteria->compare('garden_sold',$this->garden_sold);
		$criteria->compare('duplex',$this->duplex);
		$criteria->compare('duplex_id',$this->duplex_id);
		$criteria->compare('booking',$this->booking);
		$criteria->compare('sort',$this->sort);
		$criteria->compare('type',$this->type);
		$criteria->compare('owners_id',$this->owners_id);
		$criteria->compare('area',$this->area);
		$criteria->compare('address',$this->address,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}



	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Units the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	public function findAllExport($criteria)
	{
		$alldata = $this->findAll($criteria);
foreach($alldata as $data){
$data->user_id = $data->employee->fname." ".$data->employee->fname;
$data->building_id = $data->building->title;
$data->projects_id = $data->project->title;
$data->floor_id = $data->floor->title;
$data->activity = $data->xactivity->title;
$data->duplex = ($data->duplex == 1)? 'يوجد' : 'لا يوجد';
}
return $alldata;
	}
public $arabiclabels = array(

 'الكود',
 'اسم المستخدم',
'التاريخ',
'الوقت',
'المبني',
'المشروع',
'الدور',
'نوع الوحدة',
'مساحة الوحدة',
'نسبة الوحدة',
'صافى مساحة الوحدة',
'وقت التسليم',
'عدد الغرف',
'عدد الحمامات',
'عدد الشرف',
'عدد المطابخ',
'السطح',
'مساحة السطح',
'نسبه السطح',
'صافى مساحة السطح',
'الحديقة',
'ساحة الحديقة',
'نسبه الحديقة',
'صافى مساحة الحديقة',
'الجراج',
'عدد الجراجات',
'نسبه الجراج',
'صافى مساحة الجراج',
'عدد الريسبشن',
'الغرف الرئيسيه',
'الاستوديو',
'نسبه الاستوديو',
'مساحة الاستوديو',
'صافى مساحة الاستوديو',
'الخزانة',
'مساحة الخزانة',
'نسبة الخزانة',
'صافى مساحة الخزانة',
'رقم المساحة',
'Neighborhood',
'Zone',
'التفاصيل',
'activity',
'السعر',
'المساحة البيعية للمساحة',
'المساحة البيعية للاستوديو',
'المساحة البيعية للجراج',
'المساحة البيعية للسطح',
'المساحة البيعية للحديقة',
'دوبلكس',
'كود الدوبلكس');
}
