<?php
session_start();
header('Content-Type: text/html; charset=utf-8');
// Turn on error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Include TCPDF library
require_once('tcpdf/tcpdf.php');

// Extend the TCPDF class to create a custom Header and Footer
class MYPDF extends TCPDF {
    // Page header
    public function Header() {
        $headerImage = 'images/header.jpg';
        $this->Image($headerImage, 10, 10, 190, '', '', '', 'T', false, 300, '', false, false, 0, false, false, false);
        $this->SetY(30);
    }

    // Page footer
    public function Footer() {
        $this->SetY(15);
        $footerImage = 'images/footer.jpg';
        $this->Image($footerImage, 10, $this->GetY(), 190, '', '', '', 'T', false, 300, '', false, false, 0, false, false, false);
        $this->SetY(-55); 

        $this->SetFont('dejavusans', '', 12);
        $this->Cell(95, 10, 'الطرف الاول', 0, 0, 'C');
        $this->Cell(95, 10, 'الطرف الثاني', 0, 1, 'C');
    }
}

// Create new PDF document
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// Set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Solid');
$pdf->SetTitle('Contract');
$pdf->SetSubject('Solid');
$pdf->SetKeywords('Solid, Contract, Solid CRM');

// Set default header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// Set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// Set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// Set auto page breaks
$pdf->SetAutoPageBreak(TRUE, 40);

// Set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// Add a page
$pdf->AddPage();

// Define font file paths
$fontFilePath = 'fonts/IBMPlexSansArabic-Regular.ttf'; // Arabic + English font

// Add font to TCPDF
$fontname = TCPDF_FONTS::addTTFfont($fontFilePath, 'TrueTypeUnicode', '', 96);

// Assign content from model
$content = $model->contract;

// Remove font-family styles
$content = preg_replace('/style="font-family:[^"]*"/i', '', $content);

// Convert content to UTF-8
$content = mb_convert_encoding($content, 'UTF-8', mb_detect_encoding($content));


$content = preg_replace(
    '/([a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,})/',
    '<span style="direction: ltr; unicode-bidi: embed; ">$1</span>',
    $content
);

$content = preg_replace_callback(
    '/>([^<]+)</u', // Match only text inside HTML tags
    function ($matches) {
        // Reverse only English phrases inside Arabic text, while keeping numbers and special characters untouched
        return '>' . preg_replace_callback(
            '/\(\s*([a-zA-Z]+(?:\s[a-zA-Z]+)*)\s*\)/u', // Match English words inside parentheses ()
            function ($wordMatches) {
                // Reverse words inside parentheses while keeping ( ) in the correct order
                $words = explode(' ', trim($wordMatches[1]));
                $reversed = implode(' ', array_reverse($words));

                // Wrap correctly for LTR inside Arabic text
                return '(<span style="direction: ltr; unicode-bidi: embed;">' . $reversed . '</span>)';
            },
            htmlspecialchars_decode($matches[1], ENT_NOQUOTES) // Decode special characters before processing
        ) . '<';
    },
    $content
);



// Set Arabic-supporting font
$pdf->SetFont($fontname, '', 12);

// Enable RTL for Arabic text
$pdf->setRTL(true);


// Print content while keeping alignments correct
$pdf->writeHTML($content, true, false, true, false, '');

// Close PDF object
$pdf->lastPage();

// Output the PDF directly to the browser for inline display
$pdf->Output('Solid Contract.pdf', 'I');

// Clean up
$pdf->close();
?>

