<?php
$user = User::model()->findByPK($userid);
if($user->engineering == 1){
	?>
	<div class="kt-portlet">
		<div class="kt-portlet__head">
			<div class="kt-portlet__head-label">
				<h3 class="kt-portlet__head-title">
					Edit Project
				</h3>
			</div>
		</div>
		<div class="kt-portlet__body">
			<!--Solid Form-->
			<div class="kt-portlet__body kt-portlet__body--fit">
				<!--begin: Form -->
				<?php $form=$this->beginWidget('CActiveForm', array(
						'id'=>'projects-projects-form',
						'htmlOptions'=>array(
							'onsubmit' => 'return confirm("Are YOU SURE")',
							'class'=>'solid-form',
						),'clientOptions'=>array(
							'validateOnSubmit'=>true,
						),
						'enableAjaxValidation'=>false,
					)); ?>
				<div class="row">
					<div class="col-md-3 mb-2">
                        <label class="kt-font-dark">Sort</label>
						<input name="Projects[sort]" class="form-control" type="number" step="any" placeholder="Sort" value="<?php echo $model->sort?>">
					</div>
					<div class="col-md-3 mb-2">
                        <label class="kt-font-dark">Title</label>
						<?php echo $form->textField($model,'title',array('required'=>'required','placeholder'=>'Title','class'=>'form-control')); ?>
						<?php echo $form->error($model,'title'); ?>
					</div>
					<div class="col-md-3 mb-2">
                        <label class="kt-font-dark">Building Type</label>
						<select class="browser-default kt_select2_class" name="Projects[activity]" id="Projects_activity">
							<?php
							if(!empty($alltypebuliding)){
								foreach($alltypebuliding as  $typebuliding){ 
									?>
									<option <?php if($typebuliding->id == $model->activity){ ?> selected <?php } ?>   value="<?php echo $typebuliding->id ?>"><?php echo $typebuliding->title ?></option>
									<?php }	}?>
						</select>
					</div>
					<div class="col-md-3 mb-2">
                        <label class="kt-font-dark">Governorate</label>
						<select class="browser-default kt_select2_class" name="Projects[governorate]" id="Projects_governorate">
							<option style="display:none;" selected="" value="">Governorate</option>
							<?php
							if(!empty($allgovernorate)){
								foreach($allgovernorate as  $governorate){ 
									?>
									<option <?php if($governorate->id == $model->governorate){ ?> selected <?php } ?>  value="<?php echo $governorate->id ?>"><?php echo $governorate->title ?></option>
									<?php }	}?>
						</select>
					</div>
					<div class="col-md-3 mb-2">
                        <label class="kt-font-dark">City</label>
						<select class="browser-default kt_select2_class" name="Projects[city]" id="Projects_city" >
							<option style="display:none;" selected="" value="">City</option>
							<?php
							if(!empty($allcity)){
								foreach($allcity as  $city){ 
									?>
									<option <?php if($city->id == $model->city){ ?> selected <?php } ?>  rel="<?php echo $governorate->id ?>" value="<?php echo $city->id ?>"><?php echo $city->title ?></option>
									<?php }	}?>
						</select>
					</div>
					<div class="col-md-3 mb-2">
                        <label class="kt-font-dark">Region</label>
						<select class="browser-default kt_select2_class" name="Projects[region]" id="Projects_region" >
							<option style="display:none;" selected="" value="">Region</option>
							<?php
							if(!empty($allregion)){
								foreach($allregion as  $region){ 
									?>
									<option <?php if($region->id == $model->region){ ?> selected <?php } ?>  rel="<?php echo $region->parent_id ?>" value="<?php echo $region->id ?>"><?php echo $region->title ?></option>
									<?php }	}?>
						</select>
					</div>
					<div class="col-md-3 mb-2">
                        <label class="kt-font-dark">Area</label>
						<input name="Projects[size_land]" onkeyup="keyupFunction()" class="form-control" id="CalculateNet" type="number" step="any" placeholder="Area" value="<?php echo $model->size_land ?>">
					</div>
					<div class="col-md-3 mb-2">
                        <label class="kt-font-dark">Cnst. %</label>
						<input name="Projects[percentage_construction]" class="form-control" onkeyup="keyupFunction()" id="CalculatePercentage" type="number" step="any" placeholder="Cnst. %" value="<?php echo $model->percentage_construction ?>">
					</div>
					<div class="col-md-3 mb-2">
                        <label class="kt-font-dark">Net Area</label>
						<input name="Projects[size_land_net]" id="CalculatedData" class="form-control" type="number" step="any" placeholder="Net Area" Disabled value="<?php echo $model->size_land_net ?>">
					</div>
					<div class="col-md-3 mb-2">
                        <label class="kt-font-dark">Delivery Date</label>
						<input type="text" class="form-control" name="Projects[delivery_date]" id="kt_datepicker_4" placeholder="Delivery Date" value="<?php echo $model->delivery_date ?>">
					</div>
					<div class="col-md-12 mb-2">
                        <label class="kt-font-dark">Details</label>
						<textarea class="materialize-textarea form-control" name="Projects[details]" id="Projects_details" placeholder="Other Details"><?php echo $model->details ?></textarea>
					</div>
					<!-- Submit-btn -->
					<div class="col-md-12 kt-portlet__foot pl-3 mt-5 pb-0">
						<div class="kt-form__actions ">
							<input type="submit" value="Save" class="btn btn-success btn-md btn-tall btn-wide kt-font-bold kt-font-transform-u">
						</div>
					</div>
					<!-- /Submit-btn -->
				</div>
				<?php $this->endWidget(); ?>
				<!--end: Form -->
			</div>
			<!--/Solid Form-->
		</div>
	</div>
	<?php }else{ ?>
	<!-- Permission Message -->
	<div class="row">
		<div class="col-12">
			<div class="solid-box">
				<div class="solid-box-header">
					<div class="solid-box-title">
						Error 400
					</div>
					<div class="solid-box-content">
						<div class="row">
							<p>You don't have permission to access this Page</p>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- /Permission Message -->
	<?php } ?>