
				<?php
                if (Yii::app()->request->isAjaxRequest) {
                    
                $startdate = Yii::app()->request->getPost('startdate');
                $enddate = Yii::app()->request->getPost('enddate');
                $coldtype = Yii::app()->request->getPost('coldtype');
                    
				function build_table($array)
				{
					// Initialize column sums
					$sums = [];

					// start table
					$html = '<table class="sqltable table table-bordered table-striped table-fixed-header" id="exportable_table13">';

					// header row
					$html .= '<thead style="background: #48465b;position: sticky;top: 80px;color: white;font-weight: 900;height: 140px"><tr>';
					foreach ($array[0] as $key => $value) {
						if (!in_array($key, ['Agents ID', 'startdate', 'enddate', 'coldtype', 'Actual Leads ID Group'])) {
							$class = '';
							switch ($key) {
								case 'Actual Leads':
									$class = 'fresh-leads-title';
									break;
								case 'Qualified':
									$class = 'qualified-title';
									break;
								case 'Not Comm.':
								case 'Non Qualified':
								case 'Mixed':
									$class = 'non-qualified-title';
									break;
							}
							$html .= '<th>' . htmlspecialchars($key) . '</th>';
							$sums[$key] = 0; // Initialize the sums array
						}
					}
					$html .= '</tr></thead>';

					// data rows
					foreach ($array as $key => $value) {
						$html .= '<tr>';
						foreach ($value as $key2 => $value2) {
							if (!in_array($key2, ['Agents ID', 'startdate', 'enddate', 'coldtype', 'Actual Leads ID Group'])) {
								// Check if the current column is 'Agents'
								if ($key2 === 'Agents') {
									$html .= '<td height="70" style="vertical-align: middle;">' . htmlspecialchars($value2) . '</td>';
								} else {
									// Generate a dynamic link based on the cell value
									$href = generate_dynamic_link($key2, $value2, $value['startdate'], $value['enddate'], $value['Agents ID'], $value['coldtype'], $value['Actual Leads ID Group'], false);
									$class = '';
									switch ($key2) {
										case 'Actual Leads':
											$class = 'actual-leads-title';
											break;
										case 'Qualified':
											$class = 'qualified-title';
											break;
										case 'Not Comm.':
										case 'Non Qualified':
										case 'Mixed':
											$class = 'non-qualified-title';
											break;
									}
									$html .= '<td height="70" style="vertical-align: middle;" class="' . $class . '"><a href="' . $href . '">' . htmlspecialchars($value2) . '</a></td>';

									// Accumulate sums for numeric columns
									if (is_numeric($value2)) {
										$sums[$key2] += $value2;
									}
								}
							}
						}
						$html .= '</tr>';
					}

					// footer row for sums
					$html .= '<tfoot style="background: #d7d7d7;"><tr>';
					foreach ($array[0] as $key => $value) {
						if (!in_array($key, ['Agents ID', 'startdate', 'enddate', 'coldtype', 'Actual Leads ID Group'])) {
							if (strtolower($key) === 'agents') {
								// Set "Total" for the Agents column
								$html .= '<th>Total</th>';
							} elseif (isset($sums[$key])) {
								// Generate the sum link for numeric columns
								$href = generate_dynamic_link($key, $sums[$key], $array[0]['startdate'], $array[0]['enddate'], $array[0]['Agents ID'], $array[0]['coldtype'], $array[0]['Actual Leads ID Group'], true); // Pass true for sum row
								$html .= '<th><a target="_blank" style="color:black !important" href="' . $href . '">' . $sums[$key] . '</a></th>';
							} else {
								// For non-numeric columns, show a dash
								$html .= '<th>-</th>';
							}
						}
					}
					$html .= '</tr></tfoot>';

					// finish table and return it
					$html .= '</table><script>
					
					
function exportTables() {
    var table1 = document.getElementById("exportable_table12");
    var table2 = document.getElementById("exportable_table13");

    if (!table1 || !table2) {
        console.error("One or both tables not found.");
        return;
    }

    // Convert each table to a worksheet
    var sheet1 = XLSX.utils.table_to_sheet(table1);
    var sheet2 = XLSX.utils.table_to_sheet(table2);

    // Create a new worksheet to combine both tables
    var combinedSheet = {};

    // Copy data from sheet1 to combinedSheet (starting from A1)
    for (var cell in sheet1) {
        if (sheet1.hasOwnProperty(cell) && !cell.startsWith("!")) {
            combinedSheet[cell] = sheet1[cell];
        }
    }

    // Find the width of sheet1 to offset sheet2
    var offset = XLSX.utils.decode_range(sheet1["!ref"]).e.c + 1; // Number of columns in sheet1 + 1 for spacing

    // Copy data from sheet2 to combinedSheet with column offset
    for (var cell in sheet2) {
        if (sheet2.hasOwnProperty(cell) && !cell.startsWith("!")) {
            var cellRef = XLSX.utils.decode_cell(cell);
            var newCell = XLSX.utils.encode_cell({ r: cellRef.r, c: cellRef.c + offset });
            combinedSheet[newCell] = sheet2[cell];
        }
    }

    // Define the new range for the combined sheet
    var lastRow = Math.max(XLSX.utils.decode_range(sheet1["!ref"]).e.r, XLSX.utils.decode_range(sheet2["!ref"]).e.r);
    var lastCol = offset + XLSX.utils.decode_range(sheet2["!ref"]).e.c;
    combinedSheet["!ref"] = XLSX.utils.encode_range({ r: 0, c: 0 }, { r: lastRow, c: lastCol });

    // Create a new workbook and append the combined sheet
    var workbook = XLSX.utils.book_new();
    XLSX.utils.book_append_sheet(workbook, combinedSheet, "Combined Table");

    // Export the workbook to Excel
    XLSX.writeFile(workbook, "combined_tables.xlsx");
}
					
					</script>';
					return $html;
				}
				$extraConditionLink = array(); // Initialize as an array
				if ($cold == 1) {
					$extraConditionLink[] = '1';
				} elseif ($cold == 2) {
					// You can add a default condition for cold == 2 if needed
					$extraConditionLink[] = '2';
				} elseif ($cold == 3) {
					$extraConditionLink[] = '3';
				}
				// Function to generate dynamic links based on cell values
				function generate_dynamic_link($column, $cellValue, $startdate, $enddate, $agentsID, $coldtype, $leadIdsQueryParamActual, $isSum = false)
				{
					// Check if the row is a sum row
					if ($isSum) {
						// Generate links for sum row based on the column name
						switch ($column) {
							case 'Transfer Fresh (To)':
								return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&transferx=1&yt0=Search';
							case 'Actual Leads':
								return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&yt0=Search';
							case 'Answer':
								return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&answer=1&yt0=Search';
							case 'No Answer':
								return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&answer=2&yt0=Search';
							case 'Not Comm.':
								return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&communication=2&yt0=Search';
							case 'Qualified':
								return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&leadstate=1';
							case 'Non Qualified':
								return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&leadstate=2';
							case 'Not Clear':
								return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&leadstate=3';
							case 'Mixed':
								return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&leadstate=4';
							case 'Mix. Q > NQ':
								return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&leadstate=5';
							case 'Mix. NQ > Q':
								return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&leadstate=6';
						}
					}

					// Original logic for individual cell links
		
					if ($column === 'Transfer Fresh (To)') {
						$leadIdsActual = explode(',', $leadIdsQueryParamActual);
						$leadIdsQueryStringActual = implode('&ids%5B%5D=', $leadIdsActual);
						return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&ids%5B%5D=' . $leadIdsQueryStringActual . '&usersales%5B%5D=&usersales%5B%5D=' . $agentsID . '&startdate=' . $startdate . '&enddate=' . $enddate . '&transferx=1&yt0=Search';
					}
					if ($column === 'Actual Leads') {
						return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&usersales%5B%5D=&usersales%5B%5D=' . $agentsID . '&startdate=' . $startdate . '&enddate=' . $enddate . '&yt0=Search';
					}
					if ($column === 'Answer') {
						return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&usersales%5B%5D=&usersales%5B%5D=' . $agentsID . '&startdate=' . $startdate . '&enddate=' . $enddate . '&answer=1&yt0=Search';
					}
					if ($column === 'No Answer') {
						return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&usersales%5B%5D=&usersales%5B%5D=' . $agentsID . '&startdate=' . $startdate . '&enddate=' . $enddate . '&answer=2&yt0=Search';
					}
					if ($column === 'Not Comm.') {
						return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&usersales%5B%5D=&usersales%5B%5D=' . $agentsID . '&startdate=' . $startdate . '&enddate=' . $enddate . '&communication=2&yt0=Search';
					}
					if ($column === 'Qualified') {
						return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&usersales%5B%5D=&usersales%5B%5D=' . $agentsID . '&leadstate=1';
					}
					if ($column === 'Non Qualified') {
						return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&usersales%5B%5D=&usersales%5B%5D=' . $agentsID . '&leadstate=2';
					}
					if ($column === 'Not Clear') {
						return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&usersales%5B%5D=&usersales%5B%5D=' . $agentsID . '&leadstate=3';
					}
					if ($column === 'Mixed') {
						return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&usersales%5B%5D=&usersales%5B%5D=' . $agentsID . '&leadstate=4';
					}
					if ($column === 'Mix. Q > NQ') {
						return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&usersales%5B%5D=&usersales%5B%5D=' . $agentsID . '&leadstate=5';
					}
					if ($column === 'Mix. NQ > Q') {
						return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&usersales%5B%5D=&usersales%5B%5D=' . $agentsID . '&leadstate=6';
					}
					return '#';
				}
			
				if ($cold == 1)
					$extraConditionActual = ' and actuallead.coldcall is not null';
				elseif ($cold == 2)
					$extraConditionActual = ' and actuallead.coldcall is null';
				elseif ($cold == 3)
					$extraConditionActual = ' and actuallead.coldcall = 3';
				$sql = "SELECT
CONCAT(user.id ) as 'Agents ID',
COUNT(DISTINCT CASE WHEN actuallead.transfer IS NOT NULL THEN actuallead.id END) AS 'Transfer Fresh (To)',
COUNT(DISTINCT CASE WHEN actuallead.id $extraConditionActual THEN actuallead.id END) AS 'Actual Leads',
COUNT(activities.id ) as 'Activities',
GROUP_CONCAT(DISTINCT actuallead.id) AS 'Actual Leads ID Group',
COUNT(DISTINCT CASE WHEN actuallead.answer = 1 and actuallead.communication IS NOT NULL THEN actuallead.id END) AS 'Answer',
COUNT(DISTINCT CASE WHEN actuallead.answer = 2 and actuallead.communication IS NOT NULL THEN actuallead.id END) AS 'No Answer',
COUNT(DISTINCT CASE WHEN actuallead.communication IS NULL THEN actuallead.id END) AS 'Not Comm.',
COUNT(DISTINCT CASE WHEN actuallead.qualified = 1 AND actuallead.nonqualified IS NULL THEN actuallead.id END) AS Qualified,
COUNT(DISTINCT CASE WHEN actuallead.qualified IS NULL AND actuallead.nonqualified = 1 THEN actuallead.id END) AS 'Non Qualified',
COUNT(DISTINCT CASE WHEN actuallead.qualified IS NULL AND actuallead.nonqualified IS NULL THEN actuallead.id END) AS 'Not Clear',
COUNT(DISTINCT CASE WHEN actuallead.qualified = 1 AND actuallead.nonqualified = 1 THEN actuallead.id END) AS 'Mixed',
COUNT(DISTINCT CASE WHEN actuallead.qualified = 1 AND actuallead.nonqualified = 1 AND actuallead.first_classification = 1 THEN actuallead.id END) AS 'Mix. Q > NQ',
COUNT(DISTINCT CASE WHEN actuallead.qualified = 1 AND actuallead.nonqualified = 1 AND actuallead.first_classification = 2 THEN actuallead.id END) AS 'Mix. NQ > Q',
:startdate AS startdate,
:enddate AS enddate,
:coldtype AS coldtype
FROM
    user
LEFT JOIN
    leads AS actuallead ON user.id = actuallead.user_sales AND actuallead.date BETWEEN :startdate AND :enddate $extraConditionActual
LEFT JOIN
    activities ON actuallead.id = activities.leads_id AND activities.user_id = user.id

WHERE
    user.level <> 5
    AND (user.sales = 1 OR (user.telesales IS NOT NULL AND user.telesales != 0)) $extraCondition
GROUP BY
CONCAT(user.fname, ' ', user.lname), user.id";
				$command = Yii::app()->db->createCommand($sql);
				$command->bindParam(":startdate", $startdate);
				$command->bindParam(":enddate", $enddate);
				$command->bindParam(":coldtype", $extraConditionLink[0]);
				$list = $command->queryAll();
				$leadIdsQueryParamActual = isset($list[0]['Actual Leads ID Group']) ? '&ids%5B%5D=' . $list[0]['Actual Leads ID Group'] : '';
                    // Output the table
                    echo build_table($list);
                    Yii::app()->end();
                }
                ?>