<?php


	ini_set('max_execution_time', 300);
	ini_set('memory_limit', '-1');



	?>
	<div class="kt-portlet kt-portlet--height-fluid col-xl-12 col-md-12 col-lg-12" id="reportHolder">
		<div class="kt-portlet__head">
			<div class="kt-portlet__head-label">
				<h3 class="kt-portlet__head-title">
                    Net Sales/صافي المبيعات
				</h3>
			</div>
			<div class="kt-portlet__head-toolbar">
				<div class="kt-widget__action mr-1">
					<button type="button" class="btn btn-bold btn-label-brand btn-sm"  onclick="ExportExcel1('xlsx')">Excel</button>
				</div>
				<div class="kt-widget__action">
					<button type="button" class="btn btn-bold btn-label-brand btn-sm" id="pngReportButton">PNG</button>
				</div>
			</div>
		</div>
				<div class="kt-portlet__body">
					<!--Solid Form-->
					<div class="kt-portlet__body kt-portlet__body--fit"  >
<?php
// Run the MySQL query in Yii
$sql = "
    SELECT 
        parent.id AS 'Parent ID',
        parent.title AS 'Parent Title',
        parent.code AS 'Parent Code',
        parent.credit_balance_till AS 'Parent Credit Balance',
        child.id AS 'Child ID',
        child.title AS 'Child Title',
        child.code AS 'Child Code',
        child.credit_balance_till AS 'Child Credit Balance'
    FROM 
        fi_tree parent
    LEFT JOIN 
        fi_tree child ON child.tree_id = parent.id
    JOIN 
        fi_main_tree fmt ON parent.main_tree_id = fmt.id
    WHERE 
        fmt.id = 4 -- 4 corresponds to 'Revenues' in fi_main_tree
    ORDER BY 
        parent.code ASC, child.code ASC;
";

$command = Yii::app()->db->createCommand($sql);
$salesData = $command->queryAll();
?>

<!-- HTML Table to display the detailed results -->
<table border="1" class="table thead-light striped bordered condensed responsive dataTable">
    <thead>
        <tr>
            <th>Parent ID</th>
            <th>Parent Title</th>
            <th>Parent Code</th>
            <th>Parent Credit Balance</th>
            <th>Child ID</th>
            <th>Child Title</th>
            <th>Child Code</th>
            <th>Child Credit Balance</th>
        </tr>
    </thead>
    <tbody>
        <?php if (!empty($salesData)): ?>
            <?php foreach ($salesData as $row): ?>
                <tr>
                    <td><?php echo CHtml::encode($row['Parent ID']); ?></td>
                    <td><?php echo CHtml::encode($row['Parent Title']); ?></td>
                    <td><?php echo CHtml::encode($row['Parent Code']); ?></td>
                    <td><?php echo CHtml::encode($row['Parent Credit Balance']); ?></td>
                    <td><?php echo CHtml::encode($row['Child ID']); ?></td>
                    <td><?php echo CHtml::encode($row['Child Title']); ?></td>
                    <td><?php echo CHtml::encode($row['Child Code']); ?></td>
                    <td><?php echo CHtml::encode($row['Child Credit Balance']); ?></td>
                </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr>
                <td colspan="8" style="text-align: center;">No data found.</td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>


				</div>
			</div>
		</div>