<?php 
// Fetch static words by primary key
$allwords25 = Staticwords::model()->findByPk(25); 
$allwords30 = Staticwords::model()->findByPk(30); 

// Get current start, end, and today dates
$start = date('Y-m-01');  // First day of the current month
$end = date('Y-m-t');     // Last day of the current month
$today = date("M");       // Current month name

// Set close status
$close = 1; 

// Get the current user ID
$userid = Yii::app()->user->id;

// Fetch all employees under the current leader
$allemployee = Teamleader::model()->findAll(array(
    'condition' => 'leader_id=' . (int)$userid,  // Ensure safe casting to integer
    'order' => 'id DESC'
));

// Create an array of sales IDs for the employees under the leader
$arr = array();
foreach ($allemployee as $leader) {
    $arr[] = $leader->sales_id;
}

// Prepare criteria for querying leads
$criteria = new CDbCriteria(); 
$criteria->addBetweenCondition("date", $start, $end);  // Filter by date range
$criteria->addSearchCondition('close', $close, false); // Filter by close status
$criteria->addInCondition('user_sales', $arr);         // Filter by user sales IDs

// Find all matching leads
$allleads = Leads::model()->findAll($criteria);

if (!empty($allleads)) { 
?>
    <a class="kt-widget4__title" href="<?php echo Yii::app()->getBaseUrl(true) ?>/en/sales/searchsalesofleader?search=&startdate=<?php echo $start; ?>&enddate=<?php echo $end; ?>&usersales%5B%5D=<?php echo implode('&usersales%5B%5D=', $arr); ?>&close=1&yt0=Search" target="_blank">
        <?php echo count($allleads); ?>
    </a>
<?php 
} else { 
?>
    0
<?php 
} 
?>
