<section class="cd-position-relative cd-z-index-1">


  <figure class="bg-decoration cd-z-index-1" aria-hidden="true">
    <svg class="bg-decoration__svg" viewBox="0 0 1920 450" fill="none">
      <rect opacity="0.5" x="610.131" y="-440" width="128" height="836.003" transform="rotate(46.8712 610.131 -440)"
        fill="url(#bg-decoration-v1-fx-5-linear-1)" />
      <rect opacity="0.5" x="1899.13" y="-262" width="128" height="836.003" transform="rotate(46.8712 1899.13 -262)"
        fill="url(#bg-decoration-v1-fx-5-linear-2)" />
      <rect opacity="0.5" x="2076.13" y="-321" width="128" height="836.003" transform="rotate(46.8712 2076.13 -321)"
        fill="url(#bg-decoration-v1-fx-5-linear-3)" />
      <rect opacity="0.5" x="1294.5" y="40.3308" width="128" height="836.003"
        transform="rotate(-132.518 1294.5 40.3308)" fill="url(#bg-decoration-v1-fx-5-linear-4)" />
      <rect opacity="0.5" x="1866.13" y="-453" width="128" height="836.003" transform="rotate(46.8712 1866.13 -453)"
        fill="url(#bg-decoration-v1-fx-5-linear-5)" />
      <rect opacity="0.5" x="800.131" y="-418" width="128" height="836.003" transform="rotate(46.8712 800.131 -418)"
        fill="url(#bg-decoration-v1-fx-5-linear-5)" />
      <rect opacity="0.5" x="436.448" y="-251" width="76.1734" height="340.424" transform="rotate(46.8712 436.448 -251)"
        fill="url(#bg-decoration-v1-fx-5-linear-7)" />
      <defs>
        <linearGradient id="bg-decoration-v1-fx-5-linear-1" x1="674.131" y1="-440" x2="674.131" y2="396.003"
          gradientUnits="userSpaceOnUse">
          <stop stop-color="var(--bg-decoration-color-2)" />
          <stop offset="1" stop-color="var(--bg-decoration-color-2)" stop-opacity="0" />
        </linearGradient>
        <linearGradient id="bg-decoration-v1-fx-5-linear-2" x1="1963.13" y1="-262" x2="1963.13" y2="574.003"
          gradientUnits="userSpaceOnUse">
          <stop stop-color="var(--bg-decoration-color-2)" />
          <stop offset="1" stop-color="var(--bg-decoration-color-2)" stop-opacity="0" />
        </linearGradient>
        <linearGradient id="bg-decoration-v1-fx-5-linear-3" x1="2140.13" y1="-321" x2="2140.13" y2="515.003"
          gradientUnits="userSpaceOnUse">
          <stop stop-color="var(--bg-decoration-color-2)" />
          <stop offset="1" stop-color="var(--bg-decoration-color-2)" stop-opacity="0" />
        </linearGradient>
        <linearGradient id="bg-decoration-v1-fx-5-linear-4" x1="1358.5" y1="40.3308" x2="1358.5" y2="876.334"
          gradientUnits="userSpaceOnUse">
          <stop stop-color="var(--bg-decoration-color-2)" />
          <stop offset="1" stop-color="var(--bg-decoration-color-2)" stop-opacity="0" />
        </linearGradient>
        <linearGradient id="bg-decoration-v1-fx-5-linear-5" x1="1930.13" y1="-453" x2="1930.13" y2="383.003"
          gradientUnits="userSpaceOnUse">
          <stop stop-color="var(--bg-decoration-color-2)" />
          <stop offset="1" stop-color="var(--bg-decoration-color-2)" stop-opacity="0" />
        </linearGradient>
        <linearGradient id="bg-decoration-v1-fx-5-linear-5" x1="864.131" y1="-418" x2="864.131" y2="418.003"
          gradientUnits="userSpaceOnUse">
          <stop stop-color="var(--bg-decoration-color-2)" />
          <stop offset="1" stop-color="var(--bg-decoration-color-2)" stop-opacity="0" />
        </linearGradient>
        <linearGradient id="bg-decoration-v1-fx-5-linear-7" x1="474.534" y1="-251" x2="474.534" y2="89.4236"
          gradientUnits="userSpaceOnUse">
          <stop stop-color="var(--bg-decoration-color-2)" stop-opacity="0" />
          <stop offset="1" stop-color="var(--bg-decoration-color-2)" />
        </linearGradient>
      </defs>
    </svg>
  </figure>
<div class="row">
	<div class="col-xl-12">
		<!--begin::Portlet-->
		<div class="kt-portlet">
			<div class="kt-portlet__head">
				<div class="kt-portlet__head-label">
					<h3 class="kt-portlet__head-title">
						Advanced Search
					</h3>
				</div>
				<div class="kt-portlet__head-toolbar">
				    <div class="nav-item mb-2 mr-2" id="kt_demo_panel_toggle" data-toggle="tooltip" title="" data-placement="left" data-original-title="Transfer">
                		<a class="btn btn-md btn-icon btn-success btn-icon-success btn-hover-success kt-font-light" style="width:160px">
                			Transfer <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="ml-2">
                                <title>Stockholm-icons / Media / Repeat</title>
                                <desc>Created with Sketch.</desc>
                                <defs/>
                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                    <rect x="0" y="0" width="24" height="24"/>
                                    <path d="M12,8 L8,8 C5.790861,8 4,9.790861 4,12 L4,13 C4,14.6568542 5.34314575,16 7,16 L7,18 C4.23857625,18 2,15.7614237 2,13 L2,12 C2,8.6862915 4.6862915,6 8,6 L12,6 L12,4.72799742 C12,4.62015048 12.0348702,4.51519416 12.0994077,4.42878885 C12.264656,4.2075478 12.5779675,4.16215674 12.7992086,4.32740507 L15.656242,6.46136716 C15.6951359,6.49041758 15.7295917,6.52497737 15.7585249,6.56395854 C15.9231063,6.78569617 15.876772,7.09886961 15.6550344,7.263451 L12.798001,9.3840407 C12.7118152,9.44801079 12.607332,9.48254921 12.5,9.48254921 C12.2238576,9.48254921 12,9.25869158 12,8.98254921 L12,8 Z" fill="#000000"/>
                                    <path d="M12.0583175,16 L16,16 C18.209139,16 20,14.209139 20,12 L20,11 C20,9.34314575 18.6568542,8 17,8 L17,6 C19.7614237,6 22,8.23857625 22,11 L22,12 C22,15.3137085 19.3137085,18 16,18 L12.0583175,18 L12.0583175,18.9825492 C12.0583175,19.2586916 11.8344599,19.4825492 11.5583175,19.4825492 C11.4509855,19.4825492 11.3465023,19.4480108 11.2603165,19.3840407 L8.40328311,17.263451 C8.18154548,17.0988696 8.13521119,16.7856962 8.29979258,16.5639585 C8.32872576,16.5249774 8.36318164,16.4904176 8.40207551,16.4613672 L11.2591089,14.3274051 C11.48035,14.1621567 11.7936615,14.2075478 11.9589099,14.4287888 C12.0234473,14.5151942 12.0583175,14.6201505 12.0583175,14.7279974 L12.0583175,16 Z" fill="#000000" opacity="0.3"/>
                                </g>
                            </svg>
                		</a>
                	</div>
                	 
                <div class="dropdown dropdown-inline" data-toggle-="kt-tooltip" title="Quick actions" data-placement="left">
                    <a href="#" class="btn btn-icon"data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="margin-top:-5px">
                         <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                            <title>Stockholm-icons / General / Thunder-move</title>
                            <desc>Created with Sketch.</desc>
                            <defs/>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <rect x="0" y="0" width="24" height="24"/>
                                <path d="M16.3740377,19.9389434 L22.2226499,11.1660251 C22.4524142,10.8213786 22.3592838,10.3557266 22.0146373,10.1259623 C21.8914367,10.0438285 21.7466809,10 21.5986122,10 L17,10 L17,4.47708173 C17,4.06286817 16.6642136,3.72708173 16.25,3.72708173 C15.9992351,3.72708173 15.7650616,3.85240758 15.6259623,4.06105658 L9.7773501,12.8339749 C9.54758575,13.1786214 9.64071616,13.6442734 9.98536267,13.8740377 C10.1085633,13.9561715 10.2533191,14 10.4013878,14 L15,14 L15,19.5229183 C15,19.9371318 15.3357864,20.2729183 15.75,20.2729183 C16.0007649,20.2729183 16.2349384,20.1475924 16.3740377,19.9389434 Z" fill="#000000"/>
                                <path d="M4.5,5 L9.5,5 C10.3284271,5 11,5.67157288 11,6.5 C11,7.32842712 10.3284271,8 9.5,8 L4.5,8 C3.67157288,8 3,7.32842712 3,6.5 C3,5.67157288 3.67157288,5 4.5,5 Z M4.5,17 L9.5,17 C10.3284271,17 11,17.6715729 11,18.5 C11,19.3284271 10.3284271,20 9.5,20 L4.5,20 C3.67157288,20 3,19.3284271 3,18.5 C3,17.6715729 3.67157288,17 4.5,17 Z M2.5,11 L6.5,11 C7.32842712,11 8,11.6715729 8,12.5 C8,13.3284271 7.32842712,14 6.5,14 L2.5,14 C1.67157288,14 1,13.3284271 1,12.5 C1,11.6715729 1.67157288,11 2.5,11 Z" fill="#000000" opacity="0.3"/>
                            </g>
                        </svg>
                        <!--<i class="flaticon2-plus"></i>-->
                    </a>
                    <div class="dropdown-menu dropdown-menu-fit dropdown-menu-md dropdown-menu-right">
                        <!--begin::Nav-->
                        <ul class="kt-nav">
                            <li class="kt-nav__head">
                                Add any filter:                                   
                                <i class="flaticon2-information" data-toggle="kt-tooltip" data-placement="right" title="Click to learn more..."></i>
                            </li>
                            <li class="kt-nav__separator"></li>
                            <li class="kt-nav__item">
                                <a href="#" class="kt-nav__link">
                                    <label class="mx-1"><input type="checkbox" class="toggle-div" data-index="0"> ID</label>
                                </a>
                            </li>
                            <li class="kt-nav__item">
                                <a href="#" class="kt-nav__link">
                                    <label class="mx-1"><input type="checkbox" class="toggle-div" data-index="1"> Added By</label>
                                </a>
                            </li>
                            <li class="kt-nav__item">
                                <a href="#" class="kt-nav__link">
                                    <label class="mx-1"><input type="checkbox" class="toggle-div" data-index="2"> Agents</label>
                                </a>
                            </li>
                            <li class="kt-nav__item">
                                <a href="#" class="kt-nav__link">
                                    <label class="mx-1"><input type="checkbox" class="toggle-div" data-index="3"> Dates</label>
                                </a>
                            </li>
                            <li class="kt-nav__item">
                                <a href="#" class="kt-nav__link">
                                    <label class="mx-1"><input type="checkbox" class="toggle-div" data-index="4"> Campaign</label>
                                </a>
                            </li>
                            <li class="kt-nav__item">
                                <a href="#" class="kt-nav__link">
                                    <label class="mx-1"><input type="checkbox" class="toggle-div" data-index="5"> Platform</label>
                                </a>
                            </li>
                            <li class="kt-nav__item">
                                <a href="#" class="kt-nav__link">
                                    <label class="mx-1"><input type="checkbox" class="toggle-div" data-index="6"> Status</label>
                                </a>
                            </li>
                            <li class="kt-nav__item">
                                <a href="#" class="kt-nav__link">
                                    <label class="mx-1"><input type="checkbox" class="toggle-div" data-index="7"> Substatus</label>
                                </a>
                            </li>
                            <li class="kt-nav__item">
                                <a href="#" class="kt-nav__link">
                                    <label class="mx-1"><input type="checkbox" class="toggle-div" data-index="8"> Unit Type</label>
                                </a>
                            </li>
                            <li class="kt-nav__item">
                                <a href="#" class="kt-nav__link">
                                    <label class="mx-1"><input type="checkbox" class="toggle-div" data-index="9"> Property Type</label>
                                </a>
                            </li>
                            <li class="kt-nav__item">
                                <a href="#" class="kt-nav__link">
                                    <label class="mx-1"><input type="checkbox" class="toggle-div" data-index="10"> Client Type</label>
                                </a>
                            </li>
                        </ul>
                        <!--end::Nav-->
                    </div>
                </div>
				</div>
			</div>
			<div class="kt-portlet__body">
                <?php
                // Register necessary scripts and meta tags
                Yii::app()->clientScript->registerMetaTag(Yii::app()->request->csrfToken, 'csrf-token');
                
                // Initialize Date Range Picker for all fields
                Yii::app()->clientScript->registerScript('daterangepicker-init', "
                    var \$j = jQuery.noConflict();
                    \$j(function() {
                        function initDateRangePicker(id, startField, endField) {
                            \$j(id).daterangepicker({
                                locale: {
                                    format: 'YYYY-MM-DD',
                                    separator: ' to ',
                                    cancelLabel: 'Clear'
                                },
                                opens: 'right',
                                autoUpdateInput: false // Prevent default value from being set
                            }, function(start, end) {
                                // Set the selected date range in the visible input field
                                \$j(id).val(start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
                                // Update hidden fields
                                \$j(startField).val(start.format('YYYY-MM-DD'));
                                \$j(endField).val(end.format('YYYY-MM-DD'));
                                // Trigger a change event for the filters
                                \$j(startField).trigger('change');
                                \$j(endField).trigger('change');
                            });
                
                            // Handle the clear button
                            \$j(id).on('cancel.daterangepicker', function(ev, picker) {
                                // Clear the input and hidden fields
                                \$j(this).val('');
                                \$j(startField).val('');
                                \$j(endField).val('');
                                // Trigger a change event for the filters
                                \$j(startField).trigger('change');
                                \$j(endField).trigger('change');
                            });
                        }
                
                        // Initialize the date pickers for all relevant fields
                        initDateRangePicker('#filter-date-range', '#filter-start-date', '#filter-end-date');
                        initDateRangePicker('#filter-follow-date-range', '#filter-start-follow-date', '#filter-end-follow-date');
                        initDateRangePicker('#filter-upload-date-range', '#filter-start-upload-date', '#filter-end-upload-date');
                        initDateRangePicker('#filter-transfer-date-range', '#filter-start-transfer-date', '#filter-end-transfer-date');
                    });
                ");
                
                // AJAX search functionality
                Yii::app()->clientScript->registerScript('search', "
                    var \$j = jQuery.noConflict();
                
                    function debounce(fn, delay) {
                        let timer = null;
                        return function () {
                            const context = this, args = arguments;
                            clearTimeout(timer);
                            timer = setTimeout(() => fn.apply(context, args), delay);
                        };
                    }
                
                    \$j(function () {
                        const triggerElements = '#filter-id, #filter-user-id, #filter-user-sales, #filter-fresh-sales, #filter-start-date, #filter-end-date, #filter-start-follow-date, #filter-end-follow-date, #filter-start-upload-date, #filter-end-upload-date, #filter-start-transfer-date, #filter-end-transfer-date, #user-sales-filter-type, #user-sales-not-value, #employee-selector, #filter-campaign-id, #filter-platform-id, #filter-status-id, #filter-substatus-id, #filter-unit_type-id, #filter-client_type-id, #filter-property_type-id';                
                        \$j(triggerElements).on('change keyup', debounce(function () {
                
                            let userSales = \$j('#filter-user-sales').val() || [];
                            userSales = userSales.filter(val => val !== '');
                            
                            let freshSales = \$j('#filter-fresh-sales').val() || [];
                            freshSales = freshSales.filter(val => val !== '');
                            let userSalesFilterType = \$j('#user-sales-filter-type').val();
                            let userSalesNotValue = \$j('#user-sales-not-value').val();
                
                            let postData = {
                                'YII_CSRF_TOKEN': \$j('meta[name=csrf-token]').attr('content'),
                                'Leads[id]': \$j('#filter-id').val(),
                                'Leads[user_id]': \$j('#filter-user-id').val(),
                                'Leads[start_date]': \$j('#filter-start-date').val(),
                                'Leads[end_date]': \$j('#filter-end-date').val(),
                                'Leads[start_follow_date]': \$j('#filter-start-follow-date').val(),
                                'Leads[end_follow_date]': \$j('#filter-end-follow-date').val(),
                                'Leads[start_upload_date]': \$j('#filter-start-upload-date').val(),
                                'Leads[end_upload_date]': \$j('#filter-end-upload-date').val(),
                                'Leads[start_transfer_date]': \$j('#filter-start-transfer-date').val(),
                                'Leads[end_transfer_date]': \$j('#filter-end-transfer-date').val(),
                                'Leads[campaign_id]' : \$j('#filter-campaign-id').val(),
                                'Leads[platform_id]' : \$j('#filter-platform-id').val(),
                                'Leads[status]' : \$j('#filter-status-id').val(),
                                'Leads[substatus]' : \$j('#filter-substatus-id').val(),
                                'Leads[unit_type]' : \$j('#filter-unit_type-id').val(),
                                'Leads[property_type]' : \$j('#filter-property_type-id').val(),
                                'Leads[client_type]' : \$j('#filter-client_type-id').val()
                            };
                
                            // ðŸŸ¢ Add user_sales only if it's not one of the special filters
                            if (userSalesFilterType === 'isEmpty' || userSalesFilterType === 'isNotEmpty') {
                                postData['Leads[user_sales_filter_type]'] = userSalesFilterType;
                            } else if (userSalesFilterType === 'isNot') {
                                postData['Leads[user_sales_filter_type]'] = userSalesFilterType;
                                postData['Leads[user_sales_not_value]'] = userSalesNotValue;
                            } else {
                                postData['Leads[user_sales]'] = userSales;
                            }
                
                            postData['Leads[fresh_sales]'] = freshSales;
                            
                            
                            \$j.fn.yiiGridView.update('Leads-grid', {
                                type: 'POST',
                                data: postData
                            });
                
                        }, 300));
                    });
                ");?>
                <?php
                $campaigns = CHtml::listData(Campaign::model()->findAll(), 'id', 'title');
                $platforms = CHtml::listData(Platform::model()->findAll(), 'id', 'title');
                $status = CHtml::listData(Statues::model()->findAll(), 'id', 'title');
                $substatus = CHtml::listData(Substatus::model()->findAll(), 'id', 'title');
                
                $visible = 1;
$allTypeBuliding = TypeBuliding::model()->findAll(array('condition' => 'hidden=' . $visible, 'order' => 'id DESC'));
$unit_type = [];
$property_type = [];
$typesData = [];

if (!empty($allTypeBuliding)) {
    foreach ($allTypeBuliding as $type) {
        $typesData[] = [
            'id' => $type->id,
            'title' => $type->title,
            'parent_id' => $type->parent_id
        ];
        // Parents only for Unit Type
        if ($type->parent_id == null) {
            $unit_type[$type->id] = $type->title;
        } else {
            $property_type[$type->id] = $type->title;
        }
    }
}

// Static Client Types
$client_type = [
    'Seller' => 'Seller',
    'Tenant' => 'Tenant',
    'Lessor' => 'Lessor',
    'Investor' => 'Investor',
    'Broker' => 'Broker',
    'Buyer' => 'Buyer',
];
                ?>
                <script>
var allTypes = <?php echo json_encode($typesData); ?>;
</script>
                <!-- Filters and Fields -->
                <div class="filters row">
                    <div class="col-md-3 mb-1 mt-1 toggle-target">
                        <label>ID:</label>
                        <?php echo CHtml::textField('Leads[id]', $model->id, array('id' => 'filter-id')); ?>
                    </div>
                    <div class="col-md-3 mb-1 mt-1 toggle-target">
                        <label>Added By:</label>
                        <?php
                        $users = CHtml::listData(User::model()->findAll(), 'id', function ($user) {
                            return $user->fname . ' ' . $user->lname;
                        });
                        echo CHtml::dropDownList('Leads[user_id]', $model->user_id, $users, array('id' => 'filter-user-id','class' => 'kt_select2_class', 'prompt' => 'Select User'));
                        ?>
                    </div>
                    
                    <!-- Employee Selector -->
                    <div class="col-md-3 mb-1 mt-1 toggle-target">
                        <label>Employee:</label>
                        <select id="employee-selector" class="form-control">
                            <option value="">-- Select --</option>
                            <option value="actual">Is Actual Agent</option>
                            <option value="fresh">Is Fresh Agent</option>
                            <option value="isEmpty">Is Empty</option>
                            <option value="isNotEmpty">Is Not Empty</option>
                            <option value="isNot">Is Not</option>
                        </select>
                    </div>
                    <!-- Actual Agent -->
                    <div id="filter-actual" class="col-md-3 mb-1 mt-1 d-none">
                        <label>Actual Agent:
                            <button type="button" class="close btn btn-sm btn-outline-danger py-0 px-2 ml-2 remove-employee" data-target="actual">&times;</button>
                        </label>
                        <?php
                        echo CHtml::dropDownList(
                            'Leads[user_sales]',
                            $model->user_sales,
                            $users,
                            array(
                                'id' => 'filter-user-sales',
                                'prompt' => 'Select Agent',
                                'class' => 'form-control kt_select2_class',
                                'multiple' => 'multiple'
                            )
                        );
                        ?>
                    </div>
                    <!-- Hidden Fields for Custom Filters -->
                    <?php echo CHtml::hiddenField('Leads[user_sales_filter_type]', '', ['id' => 'user-sales-filter-type']); ?>
                    <?php echo CHtml::hiddenField('Leads[user_sales_not_value]', '', ['id' => 'user-sales-not-value']); ?>
                    <!-- Fresh Agent -->
                    <div id="filter-fresh" class="col-md-3 mb-1 mt-1 d-none">
                        <label>Fresh Agent:
                            <button type="button" class="close btn btn-sm btn-outline-danger py-0 px-2 ml-2 remove-employee" data-target="fresh">&times;</button>
                        </label>
                        <?php
                        echo CHtml::dropDownList(
                            'Leads[fresh_sales]',
                            $model->fresh_sales,
                            $users,
                            array(
                                'id' => 'filter-fresh-sales',
                                'prompt' => 'Select Fresh Agent',
                                'class' => 'form-control kt_select2_class',
                                'multiple' => 'multiple'
                            )
                        );
                        ?>
                    </div>
                    
                    <div class="col-md-3 mb-1 mt-1 toggle-target">
                        <label>Dates:</label>
                        <select id="date-selector" class="form-control">
                            <option value="">-- Select --</option>
                            <option value="distribution">Distribution Date</option>
                            <option value="follow">Follow Date</option>
                            <option value="upload">Upload Date</option>
                            <option value="transfer">Transfer Date</option>
                        </select>
                    </div>
                    <!-- Distribution Date -->
                    <div id="filter-distribution" class="col-md-3 mb-1 mt-1 d-none">
                        <label>Distribution Date:
                        <button type="button" class="close btn btn-sm btn-outline-danger py-0 px-2 ml-2 remove-filter" data-target="distribution">&times;</button>
                        </label>
                        <?php echo CHtml::textField('Leads[date_range]', '', array('id' => 'filter-date-range', 'class' => 'form-control')); ?>
                        <?php echo CHtml::hiddenField('Leads[start_date]', '', array('id' => 'filter-start-date')); ?>
                        <?php echo CHtml::hiddenField('Leads[end_date]', '', array('id' => 'filter-end-date')); ?>
                    </div>
                    <!-- Follow Date -->
                    <div id="filter-follow" class="col-md-3 mb-1 mt-1 d-none">
                        <label>Follow Date:
                        <button type="button" class="close btn btn-sm btn-outline-danger py-0 px-2 ml-2 remove-filter" data-target="follow">&times;</button>
                        </label>
                        <?php echo CHtml::textField('Leads[follow_date_range]', '', array('id' => 'filter-follow-date-range', 'class' => 'form-control')); ?>
                        <?php echo CHtml::hiddenField('Leads[start_follow_date]', '', array('id' => 'filter-start-follow-date')); ?>
                        <?php echo CHtml::hiddenField('Leads[end_follow_date]', '', array('id' => 'filter-end-follow-date')); ?>
                    </div>
                    <!-- Upload Date -->
                    <div id="filter-upload" class="col-md-3 mb-1 mt-1 d-none">
                        <label>Upload Date:
                        <button type="button" class="close btn btn-sm btn-outline-danger py-0 px-2 ml-2 remove-filter" data-target="upload">&times;</button>
                        </label>
                        <?php echo CHtml::textField('Leads[upload_date_range]', '', array('id' => 'filter-upload-date-range', 'class' => 'form-control')); ?>
                        <?php echo CHtml::hiddenField('Leads[start_upload_date]', '', array('id' => 'filter-start-upload-date')); ?>
                        <?php echo CHtml::hiddenField('Leads[end_upload_date]', '', array('id' => 'filter-end-upload-date')); ?>
                    </div>
                    <!-- Transfer Date -->
                    <div id="filter-transfer" class="col-md-3 mb-1 mt-1 d-none">
                        <label>Transfer Date:
                        <button type="button" class="close btn btn-sm btn-outline-danger py-0 px-2 ml-2 remove-filter" data-target="transfer">&times;</button>
                        </label>
                        <?php echo CHtml::textField('Leads[transfer_date_range]', '', array('id' => 'filter-transfer-date-range', 'class' => 'form-control')); ?>
                        <?php echo CHtml::hiddenField('Leads[start_transfer_date]', '', array('id' => 'filter-start-transfer-date')); ?>
                        <?php echo CHtml::hiddenField('Leads[end_transfer_date]', '', array('id' => 'filter-end-transfer-date')); ?>
                    </div>
                    <!-- Campaign -->
                    <div class="col-md-3 mb-1 mt-1 toggle-target">
                        <label>Campaign:</label>
                        <?php echo CHtml::dropDownList('Leads[campaign_id]', $model->campaign_id, $campaigns, [
                            'id' => 'filter-campaign-id',
                            'prompt' => 'Select Campaign',
                            'class' => 'form-control kt_select2_class'
                        ]); ?>
                    </div>
                    
                    <!-- Platform -->
                    <div class="col-md-3 mb-1 mt-1 toggle-target">
                        <label>Platform:</label>
                        <?php echo CHtml::dropDownList('Leads[platform_id]', $model->platform_id, $platforms, [
                            'id' => 'filter-platform-id',
                            'prompt' => 'Select Platform',
                            'class' => 'form-control kt_select2_class'
                        ]); ?>
                    </div>
                    
                    <!-- Status -->
                    <div class="col-md-3 mb-1 mt-1 toggle-target">
                        <label>Status:</label>
                        <?php echo CHtml::dropDownList('Leads[status]', $model->status, $status, [
                            'id' => 'filter-status-id',
                            'prompt' => 'Select Status',
                            'class' => 'form-control kt_select2_class'
                        ]); ?>
                    </div>
                    
                    <!-- Substatus -->
                    <div class="col-md-3 mb-1 mt-1 toggle-target">
                        <label>Substatus:</label>
                        <?php echo CHtml::dropDownList('Leads[substatus]', $model->substatus, $substatus, [
                            'id' => 'filter-substatus-id',
                            'prompt' => 'Select Substatus',
                            'class' => 'form-control kt_select2_class'
                        ]); ?>
                    </div>
                    
                    <!-- Unit Type -->
                    <div class="col-md-3 mb-1 mt-1 toggle-target">
                        <label>Unit Type:</label>
                        <?php echo CHtml::dropDownList('Leads[unit_type]', $model->unit_type, $unit_type, [
                            'id' => 'filter-unit_type-id',
                            'prompt' => 'Select Unit Type',
                            'class' => 'form-control kt_select2_class'
                        ]); ?>
                    </div>
                    
                    <!-- Property Type -->
                    <div class="col-md-3 mb-1 mt-1 toggle-target">
                        <label>Property Type:</label>
                        <?php echo CHtml::dropDownList('Leads[property_type]', $model->property_type, $property_type, [
                            'id' => 'filter-property_type-id',
                            'prompt' => 'Select Property Type',
                            'class' => 'form-control kt_select2_class'
                        ]); ?>
                    </div>
                    
                    <!-- Client Type -->
                    <div class="col-md-3 mb-1 mt-1 toggle-target">
                        <label>Client Type:</label>
                        <?php echo CHtml::dropDownList('Leads[client_type]', $model->client_type, $client_type, [
                            'id' => 'filter-client_type-id',
                            'prompt' => 'Select Client Type',
                            'class' => 'form-control kt_select2_class'
                        ]); ?>
                    </div>
                </div>

                <div id="kt_demo_panel" class="kt-demo-panel" style="padding-top:150px">
                    <svg width="153" height="147" viewBox="0 0 153 147" fill="none" xmlns="http://www.w3.org/2000/svg" style="width: 70%;margin-top: -75px;position: absolute;height: auto;z-index: -1;right: 0px;">
                        <g clip-path="url(#clip0)">
                        <path d="M172.001 118.835C172.001 134.389 159.165 147.001 143.334 147.001C127.502 147.001 114.668 134.389 114.668 118.835C114.668 103.278 127.502 90.6685 143.334 90.6685C159.165 90.6685 172.001 103.278 172.001 118.835Z" fill="#F6F7F9"/>
                        <path d="M136.168 51.937C136.168 65.5495 124.938 76.5833 111.084 76.5833C97.2299 76.5833 86.0002 65.5495 86.0002 51.937C86.0002 38.3261 97.2299 27.2908 111.084 27.2908C124.938 27.2908 136.168 38.3261 136.168 51.937Z" fill="#F6F7F9"/>
                        <path d="M86.0003 104.749C86.0003 128.084 66.7479 147 42.9993 147C19.2524 147 0 128.084 0 104.749C0 81.4151 19.2524 62.5001 42.9993 62.5001C66.7479 62.5001 86.0003 81.4151 86.0003 104.749Z" fill="#F6F7F9"/>
                        <path d="M71.6689 13.2094C71.6689 32.6547 55.6249 48.4188 35.8344 48.4188C16.044 48.4188 0 32.6547 0 13.2094C0 -6.23587 16.044 -22 35.8344 -22C55.6249 -22 71.6689 -6.23587 71.6689 13.2094Z" fill="#F6F7F9"/>
                        <path d="M172.001 -0.875322C172.001 10.7918 162.374 20.2494 150.499 20.2494C138.625 20.2494 129 10.7918 129 -0.875322C129 -12.5425 138.625 -22 150.499 -22C162.374 -22 172.001 -12.5425 172.001 -0.875322Z" fill="#F6F7F9"/>
                        <path d="M164.832 69.5401C164.832 73.4291 161.624 76.5816 157.666 76.5816C153.708 76.5816 150.499 73.4291 150.499 69.5401C150.499 65.6526 153.708 62.5001 157.666 62.5001C161.624 62.5001 164.832 65.6526 164.832 69.5401Z" fill="#F6F7F9"/>
                        <path d="M111.084 2.64588C111.084 8.48027 106.271 13.209 100.333 13.209C94.3972 13.209 89.5845 8.48027 89.5845 2.64588C89.5845 -3.18689 94.3972 -7.91565 100.333 -7.91565C106.271 -7.91565 111.084 -3.18689 111.084 2.64588Z" fill="#F6F7F9"/>
                        </g>
                        <defs>
                        <clipPath id="clip0">
                        <rect y="-22" width="172" height="169" fill="white"/>
                        </clipPath>
                        </defs>
                    </svg>
                
                	<div class="kt-demo-panel__head">
                		<h3 class="kt-demo-panel__title">
                			Transfer selected Leads
                			<!--<small>5</small>-->
                		</h3>
                		<a href="#" class="kt-demo-panel__close" id="kt_demo_panel_close"><i class="flaticon2-delete"></i></a>
                	</div>
                	<div class="kt-demo-panel__body">
                        <form class="solid-form-transfer w-100" method="POST">
                        	<div class="col-md-12 padding-horizontal-0 ">
                        		<div class="row">
                        			<div class="col-md-12 mb-2">
                        			    <label>Selected Leads</label>
                        				<select class="browser-default" name="checks[]" id="Leads_check" Multiple required>
                        					<option style="display:none;" selected="" value="0"><!--Lead--> <?php echo $allwords35->label48?></option>
                        				</select>
                        			</div>
                        			<div class="col-md-12 mb-2">
                        			    <label>Number of Leads</label>
                        				<select class="browser-default" name="salescheck" id="Leads_user_sales" required>
                        					<option style="display:none;" selected="" value=""><!--Sales--> <?php echo $allwords35->label47?></option>
                        					<?php $allsales = User::model()->findAll(array( 'condition' => 'sales=1','order'=>'id DESC'  )); ?>
                        					<?php if(!empty($allsales)){
                        					foreach($allsales as  $sales){ 
                        					?>
                        			    		<?php if($sales->level == 1){ ?>
                        						<option value="<?php echo $sales->id?>"><?php echo $sales->fname ?> <?php echo $sales->lname ?> / Sales </option>
                        						<?php } ?>
                        					<?php } } ?>
                        					<?php $alltelesales = User::model()->findAll(array( 'condition' => 'telesales=1 ','order'=>'id DESC'  )); ?>
                        					<?php if(!empty($alltelesales)){
                        					foreach($alltelesales as  $telesales){ 
                        					?>
                        					    <?php if($telesales->level == 1){ ?>
                        						<option value="<?php echo $telesales->id?>"><?php echo $telesales->fname ?> <?php echo $telesales->lname ?> / Telesales</option>
                        						<?php } ?>
                        					<?php } } ?>
                        				</select>
                        			</div>
                        			<div class="col-md-12">
                        				<div class="warning margin-vertical-10">
                        					<p class="padding-horizontal-10 padding-vertical-10"><strong><!--Note:--> <?php echo $allwords34->label59?></strong> <!--Check on Hide " if you want to hide Activities .--> <?php echo $allwords35->label49?></p>
                        				</div>
                        			</div>
                        			<div class="col-md-12">
                        				<p>
                        					<label>
                        						<input type="radio" class="hideSalesSelect" name="Hideee" value="1" />
                        						<span>Hidden Activities for Sales</span>
                        					</label>
                        				</p>
                        				<p>
                        					<label>
                        						<input type="radio" class="hideTeamLeaderSelect" name="Hideteamleader" value="1" />
                        						<span>Hidden Activities for Teamleader & Sales</span>
                        					</label>
                        				</p>
                        				<p>
                        					<label>
                        						<input type="radio" class="fakeNewLeadSelect" name="fakenewlead" value="1" />
                        						<span>Fake New Lead</span>
                        					</label>
                        				</p>
                        				<script>
                        				</script>
                        			</div> 
                        		</div>
                        	</div>
                            <div class="col-md-12 kt-portlet__foot pl-3 mt-4 pb-0">
                            	<div class="kt-form__actions ">
                            		<input type="submit" name="yt0" value="Transfer" class="btn btn-success btn-md btn-tall btn-wide kt-font-bold kt-font-transform-u"/>
                            		<button type="reset" class="resetBtnForClearSelect btn btn-secondary btn-md btn-tall btn-wide">Reset</button>
                            	</div>
                            </div>
                        </form>
                        </div>
                </div>        
                <div id="loading-spinner" style="display:none;">
                    Loading...
                </div>
                <div class="alert alert-info d-none">All Lead IDs (all pages): <span id="lead-id-list">Loading...</span></div>
                <input type="hidden" id="allLeadIds" value="">
                <?php
$this->widget('application.extensions.PageSize.PageSize', array(
    'mGridId' => 'Leads-grid', // ID بتاع الجريد
    'mPageSize' => @$_GET['pageSize'], // القيمة الحالية
    'mDefPageSize' => Yii::app()->params['defaultPageSize'], // القيمة الافتراضية
    'mPageSizeOptions' => Yii::app()->params['pageSizeOptions'], // اختياراتك
));
?>
                <div class="table-responsive">
                    <?php
                    Yii::log("DataProvider Item Count: " . $dataProvider->getTotalItemCount(), 'info');
                    $this->widget('zii.widgets.grid.CGridView', array(
                        'id' => 'Leads-grid',
                        'dataProvider' => $dataProvider,
                        'filter' => $model,
                        'ajaxUpdate' => true,
                        'enableHistory' => false,
                        'enablePagination' => true,
                        'itemsCssClass' => 'responsive dataTable responsive dataTable table table-striped table-bordered table-condensed',
                        'emptyText' => 'No matching Leads found, please adjust your search criteria.',
                        "summaryText" => "Showing {start} to {end} of {count} entries",
                        'pager' => [
                            'class' => 'CLinkPager',
                            'maxButtonCount' => 5,
                            'nextPageLabel' => 'Next',
                            'prevPageLabel' => 'Prev',
                            'firstPageLabel' => 'First',
                            'lastPageLabel' => 'Last',
                        ],
                        'columns' => array(
                            array(
                                'class' => 'CCheckBoxColumn',
                                'id' => 'leadCheckbox',
                                'selectableRows' => 2, // Allows multiple selections
                                'htmlOptions' => ['class' => 'lead-checkbox'],
                                'value' => '$data->id',
                            ),
                            'id',
                            array(
                                'name' => 'user_id',
                                'header' => 'Added By',
                                'value' => function ($data) {
                                    $user = User::model()->findByPk($data->user_id);
                                    return $user ? $user->fname . ' ' . $user->lname : 'N/A';
                                },
                            ),
                            'date',
                            'transferdate',
                            'follow_date',
                            'sysdate',
                            
    // ✅ NEW: Campaign
    array(
        'name' => 'campaign_id',
        'header' => 'Campaign',
        'value' => function ($data) {
            $item = Campaign::model()->findByPk($data->campaign_id);
            return $item ? $item->title : 'N/A';
        },
    ),

    // ✅ NEW: Platform
    array(
        'name' => 'platform_id',
        'header' => 'Platform',
        'value' => function ($data) {
            $item = Platform::model()->findByPk($data->platform_id);
            return $item ? $item->title : 'N/A';
        },
    ),

    // ✅ NEW: Status
    array(
        'name' => 'status',
        'header' => 'Status',
        'value' => function ($data) {
            $item = Statues::model()->findByPk($data->status);
            return $item ? $item->title : 'N/A';
        },
    ),

    // ✅ NEW: Substatus
    array(
        'name' => 'substatus',
        'header' => 'Substatus',
        'value' => function ($data) {
            $item = Substatus::model()->findByPk($data->substatus);
            return $item ? $item->title : 'N/A';
        },
    ),

    // ✅ NEW: Unit Type
    array(
        'name' => 'unit_type',
        'header' => 'Unit Type',
        'value' => function ($data) {
            $item = TypeBuliding::model()->findByPk($data->unit_type);
            return $item ? $item->title : 'N/A';
        },
    ),

    // ✅ NEW: Property Type
    array(
        'name' => 'property_type',
        'header' => 'Property Type',
        'value' => function ($data) {
            $item = TypeBuliding::model()->findByPk($data->property_type);
            return $item ? $item->title : 'N/A';
        },
    ),

    // ✅ NEW: Client Type
    array(
        'name' => 'client_type',
        'header' => 'Client Type',
        'value' => function ($data) {
            return $data->client_type ?? 'N/A';
        },
    ),
                        ),
                    ));
                    ?>
                </div>
			</div>
		</div>
	</div>
</div>
<style>
    .toggle-target{
        display:none;
    }
    .remove-filter {
        margin-top: -10px;
    }
    .remove-filter:hover {
        padding: 0px 10px 2px !important;
    }
    .remove-employee {
        margin-top: -10px;
    }
    .remove-employee:hover {
        padding: 0px 10px 2px !important;
    }
</style>
<!-- Optional: JS access -->
<script>
document.addEventListener('DOMContentLoaded', function () {
    // Handle disabling checkboxes based on selection
    const hideSales = document.querySelector('.hideSalesSelect');
    const hideTeamLeader = document.querySelector('.hideTeamLeaderSelect');
    const hideFakeNewLead = document.querySelector('.fakeNewLeadSelect');
    const resetBtn = document.querySelector('.resetBtnForClearSelect');

    const checkboxGroups = [hideSales, hideTeamLeader, hideFakeNewLead];

    checkboxGroups.forEach((checkbox, index) => {
        checkbox.addEventListener('change', function () {
            checkboxGroups.forEach((cb, i) => {
                if (i !== index) cb.disabled = this.checked;
            });
        });
    });

    resetBtn.addEventListener('click', () => {
        checkboxGroups.forEach(cb => cb.disabled = false);
    });

    // Toggle visibility of dynamic filters
    const togglers = document.querySelectorAll('.toggle-div');
    const targets = document.querySelectorAll('.toggle-target');

    togglers.forEach(cb => {
        cb.addEventListener('change', () => {
            const index = cb.getAttribute('data-index');
            if (targets[index]) {
                targets[index].style.display = cb.checked ? 'block' : 'none';
            }
        });
    });

    // Handle dynamic date filter selection
    const dateSelector = document.getElementById('date-selector');
    if (dateSelector) {
        dateSelector.addEventListener('change', function () {
            const value = this.value;
            if (value) {
                const target = document.getElementById('filter-' + value);
                if (target) target.classList.remove('d-none');
                this.value = '';
            }
        });
    }

    // Handle employee filter selection
    // const employeeSelector = document.getElementById('employee-selector');
    // if (employeeSelector) {
    //     employeeSelector.addEventListener('change', function () {
    //         const value = this.value;
    //         if (value) {
    //             const target = document.getElementById('filter-' + value);
    //             if (target && target.classList.contains('d-none')) {
    //                 target.classList.remove('d-none');
    //             }
    //             this.value = '';
    //         }
    //     });
    // }

    // Remove individual employee filter blocks
    document.querySelectorAll('.remove-employee').forEach(btn => {
        btn.addEventListener('click', function () {
            const targetId = this.dataset.target;
            const block = document.getElementById('filter-' + targetId);
            if (block) {
                block.classList.add('d-none');
                const select = block.querySelector('select');
                if (select) select.value = '';
            }
        });
    });

    // Remove individual date filter blocks
    document.querySelectorAll('.remove-filter').forEach(btn => {
        btn.addEventListener('click', function () {
            const targetId = this.dataset.target;
            const block = document.getElementById('filter-' + targetId);
    
            if (block) {
                block.classList.add('d-none');
    
                // Clear text inputs
                block.querySelectorAll('input[type="text"]').forEach(input => {
                    input.value = '';
                });
    
                // Clear hidden inputs
                block.querySelectorAll('input[type="hidden"]').forEach(input => {
                    input.value = '';
                });
    
                // Clear select (including select2)
                block.querySelectorAll('select').forEach(select => {
                    if ($(select).hasClass('select2-hidden-accessible')) {
                        $(select).val(null).trigger('change');
                    } else {
                        select.value = '';
                    }
                });
                
                $('#filter-user-id').trigger('change'); // You can trigger any existing bound input to refresh the grid
            }
        });
    });
});

// Select 2
$(document).ready(function () {
    $('.kt_select2_class').select2({
        width: '100%',
        placeholder: 'Select Option',
        allowClear: true
    });
});

// Handle Employee Selector Behavior
$('#employee-selector').change(function () {
    const selected = $(this).val();
    $('.kt_select2_class').val(null).trigger('change'); 
    // Reset
    $('#filter-actual').addClass('d-none');
    $('#filter-fresh').addClass('d-none');
    $('#filter-user-sales').val('');
    $('#user-sales-not-value').val('');
    $('#user-sales-filter-type').val('');

    if (selected === 'actual') {
        $('#filter-actual').removeClass('d-none');
    } else if (selected === 'fresh') {
        $('#filter-fresh').removeClass('d-none');
    } else if (selected === 'isEmpty') {
        $('#user-sales-filter-type').val('isEmpty');
        $('#filter-user-id').trigger('change'); // âœ… Triggers the AJAX
    } else if (selected === 'isNotEmpty') {
        $('#user-sales-filter-type').val('isNotEmpty');
        $('#filter-user-id').trigger('change'); // âœ… Triggers the AJAX
    } else if (selected === 'isNot') {
        $('#filter-actual').removeClass('d-none');
        $('#filter-fresh').addClass('d-none');
        $('#user-sales-filter-type').val('isNot');
        $('#filter-user-sales').off('change').on('change', function () {
            $('#user-sales-not-value').val($(this).val());
            $('#filter-user-id').trigger('change'); // âœ… Triggers the AJAX
        });
    }
});

// Update fetchAllFilteredLeadIds to include new filters
function fetchAllFilteredLeadIds() {
    const data = {
        'YII_CSRF_TOKEN': $('meta[name=csrf-token]').attr('content'),
        'Leads[id]': $('#filter-id').val(),
        'Leads[user_id]': $('#filter-user-id').val(),
        'Leads[user_sales]': $('#filter-user-sales').val(),
        'Leads[user_sales_filter_type]': $('#user-sales-filter-type').val(),
        'Leads[user_sales_not_value]': $('#user-sales-not-value').val(),
        'Leads[fresh_sales]': $('#filter-fresh-sales').val(),
        'Leads[start_date]': $('#filter-start-date').val(),
        'Leads[end_date]': $('#filter-end-date').val(),
        'Leads[start_follow_date]': $('#filter-start-follow-date').val(),
        'Leads[end_follow_date]': $('#filter-end-follow-date').val(),
        'Leads[start_upload_date]': $('#filter-start-upload-date').val(),
        'Leads[end_upload_date]': $('#filter-end-upload-date').val(),
        'Leads[start_transfer_date]': $('#filter-start-transfer-date').val(),
        'Leads[end_transfer_date]': $('#filter-end-transfer-date').val(),
        'Leads[campaign_id]': $('#filter-campaign-id').val(),
        'Leads[platform_id]': $('#filter-platform-id').val(),
        'Leads[status]': $('#filter-status-id').val(),
        'Leads[substatus]': $('#filter-substatus-id').val(),
        'Leads[unit_type]': $('#filter-unit_type-id').val(),
        'Leads[property_type]': $('#filter-property_type-id').val(),
        'Leads[client_type]': $('#filter-client_type-id').val()
    };

    $.post("<?= Yii::app()->createUrl('login/getAllLeadsIds') ?>", data, function (response) {
        const ids = JSON.parse(response);
        $('#lead-id-list').text(ids.join(', '));
        $('#allLeadIds').val(ids.join(','));
        console.log('Updated IDs:', ids);
    });
}

// Track checked lead IDs and sync to dropdown
function updateCheckedLeadIds() {
    const selected = [];

    $('input[name="leadCheckbox[]"]:checked').each(function () {
        selected.push($(this).val()); 
    });

    $('#lead-id-list').text(selected.length ? selected.join(', ') : 'None');
    $('#allLeadIds').val(selected.join(','));

    const $select = $('#Leads_check');
    $select.find('option:not([value="0"])').remove();

    selected.forEach(id => {
        if (!$select.find(`option[value="${id}"]`).length) {
            $select.append(`<option value="${id}" selected>Lead #${id}</option>`);
        }
    });
}

// Trigger functions on DOM ready and after AJAX
$(document).ready(function () {
    fetchAllFilteredLeadIds();
    updateCheckedLeadIds();
});

$(document).on('ajaxComplete', function () {
    fetchAllFilteredLeadIds();
    updateCheckedLeadIds();
});

$(document).on('change', 'input[name="leadCheckbox[]"]', function () {
    updateCheckedLeadIds();
});
</script>
</section>
<style>

html {
  -webkit-font-smoothing: antialiased;
  -moz-osx-font-smoothing: grayscale;
}

body {
  background-color: hsl(0, 0%, 100%);
  font-family: system-ui, sans-serif;
  color: hsl(230, 7%, 23%);
  font-size: 1.125rem; /* 18px */
  line-height: 1.4;
}
.bg-decoration {
  --bg-decoration-color-1: hsl(240, 4%, 65%);
  --bg-decoration-color-2: hsla(230, 13%, 9%, 0.4);
  --bg-decoration-color-3: hsl(250, 84%, 54%);
  --bg-decoration-color-4: hsl(342, 89%, 48%);

  position: absolute;
  top: 0;
  left: 0;
  pointer-events: none;
  width: 100%;
  height: 100%;
  overflow: hidden;
}

.bg-decoration__svg {
  position: absolute;
  top: 0;
  left: 50%;
  transform: translateX(-50%);
  width: 134%;
  min-width: 1280px;
  max-width: 1920px;
  height: auto;
}

.bg-decoration__blending-element {
  mix-blend-mode: overlay;
}
.cd-position-relative {
  position: relative;
}

.cd-z-index-1 {
  z-index: 1;
}

.cd-z-index-2 {
  z-index: 2;
}
</style>
